/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import gg.airplane.structs.ItemListWithBitset;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.inventory.PaperInventoryMoveItemEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryHolder;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHopper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockHopper;
import net.minecraft.world.level.block.entity.IHopper;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.Inventory;

public class TileEntityHopper
extends TileEntityLootable
implements IHopper {
    public static final int f = 8;
    public static final int g = 5;
    private NonNullList<ItemStack> h;
    private ItemListWithBitset optimizedItems;
    public int i;
    private long j;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;
    private static final int HOPPER_EMPTY = 0;
    private static final int HOPPER_HAS_ITEMS = 1;
    private static final int HOPPER_IS_FULL = 2;
    private static boolean skipPullModeEventFire;
    private static boolean skipPushModeEventFire;
    public static boolean skipHopperEvents;
    private static final BiPredicate<ItemStack, Integer> STACK_SIZE_TEST;
    private static final BiPredicate<ItemStack, Integer> IS_EMPTY_TEST;
    static final AxisAlignedBB HOPPER_ITEM_SUCK_OVERALL;
    static final AxisAlignedBB[] HOPPER_ITEM_SUCK_INDIVIDUAL;

    @Override
    public List<ItemStack> getContents() {
        return this.h;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int ak_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public TileEntityHopper(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.r, pos, state);
        this.optimizedItems = new ItemListWithBitset(5);
        this.h = this.optimizedItems.nonNullList;
        this.i = -1;
    }

    @Override
    public boolean hasEmptySlot(EnumDirection enumdirection) {
        return !this.optimizedItems.hasFullStacks();
    }

    @Override
    public boolean isCompletelyFull(EnumDirection enumdirection) {
        return this.optimizedItems.hasFullStacks() && super.isCompletelyFull(enumdirection);
    }

    @Override
    public boolean isCompletelyEmpty(EnumDirection enumdirection) {
        return this.optimizedItems.isCompletelyEmpty() || super.isCompletelyEmpty(enumdirection);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.optimizedItems = new ItemListWithBitset(this.b());
        this.h = this.optimizedItems.nonNullList;
        if (!this.c_(nbt)) {
            ContainerUtil.b(nbt, this.h);
        }
        this.i = nbt.h("TransferCooldown");
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (!this.d_(nbt)) {
            ContainerUtil.a(nbt, this.h);
        }
        nbt.a("TransferCooldown", this.i);
    }

    @Override
    public int b() {
        return this.h.size();
    }

    @Override
    public ItemStack a(int slot, int amount) {
        this.e_(null);
        return ContainerUtil.a(this.k(), slot, amount);
    }

    @Override
    public void a(int slot, ItemStack stack) {
        this.e_(null);
        this.k().set(slot, stack);
        if (stack.L() > this.ak_()) {
            stack.f(this.ak_());
        }
    }

    @Override
    protected IChatBaseComponent l() {
        return IChatBaseComponent.c("container.hopper");
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityHopper blockEntity) {
        --blockEntity.i;
        blockEntity.j = world.X();
        if (!blockEntity.w()) {
            blockEntity.c(0);
            boolean result = TileEntityHopper.a(world, pos, state, blockEntity, () -> TileEntityHopper.a(world, blockEntity));
            if (!result && blockEntity.o.spigotConfig.hopperCheck > 1) {
                blockEntity.c(blockEntity.o.spigotConfig.hopperCheck);
            }
        }
    }

    private static int getFullState(TileEntityHopper tileEntity) {
        tileEntity.e_(null);
        NonNullList<ItemStack> hopperItems = tileEntity.k();
        boolean empty = true;
        boolean full = true;
        int len = hopperItems.size();
        for (int i2 = 0; i2 < len; ++i2) {
            ItemStack stack = (ItemStack)hopperItems.get(i2);
            if (stack.b()) {
                full = false;
                continue;
            }
            if (!full) {
                return 1;
            }
            empty = false;
            if (stack.L() == stack.g()) continue;
            return 1;
        }
        return empty ? 0 : (full ? 2 : 1);
    }

    private static boolean a(World world, BlockPosition pos, IBlockData state, TileEntityHopper blockEntity, BooleanSupplier booleansupplier) {
        if (world.B) {
            return false;
        }
        if (!blockEntity.w() && state.c(BlockHopper.c).booleanValue()) {
            boolean flag = false;
            int fullState = TileEntityHopper.getFullState(blockEntity);
            if (fullState != 0) {
                flag = TileEntityHopper.ejectItems(world, pos, state, blockEntity, blockEntity);
            }
            if (fullState != 2 || flag) {
                flag |= booleansupplier.getAsBoolean();
            }
            if (flag) {
                blockEntity.c(world.spigotConfig.hopperTransfer);
                TileEntityHopper.a(world, pos, state);
                return true;
            }
        }
        return false;
    }

    private boolean m() {
        ItemStack itemstack;
        Iterator iterator = this.h.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (!(itemstack = (ItemStack)iterator.next()).b() && itemstack.L() == itemstack.g());
        return false;
    }

    private static boolean hopperPush(World level, IInventory destination, EnumDirection direction, TileEntityHopper hopper) {
        skipPushModeEventFire = skipHopperEvents;
        boolean foundItem = false;
        for (int i2 = 0; i2 < hopper.b(); ++i2) {
            ItemStack origItemStack;
            ItemStack item = hopper.a(i2);
            if (item.b()) continue;
            foundItem = true;
            ItemStack movedItem = origItemStack = item;
            int originalItemCount = origItemStack.L();
            int movedItemCount = Math.min(level.spigotConfig.hopperAmount, originalItemCount);
            origItemStack.f(movedItemCount);
            if (!skipPushModeEventFire && (movedItem = TileEntityHopper.callPushMoveEvent(destination, movedItem, hopper)) == null) {
                origItemStack.f(originalItemCount);
                return false;
            }
            ItemStack remainingItem = TileEntityHopper.a((IInventory)hopper, destination, movedItem, direction);
            int remainingItemCount = remainingItem.L();
            if (remainingItemCount != movedItemCount) {
                origItemStack = origItemStack.copy(true);
                origItemStack.f(originalItemCount);
                if (!origItemStack.b()) {
                    origItemStack.f(originalItemCount - movedItemCount + remainingItemCount);
                }
                hopper.a(i2, origItemStack);
                destination.e();
                return true;
            }
            origItemStack.f(originalItemCount);
        }
        if (foundItem && level.paperConfig().hopper.cooldownWhenFull) {
            hopper.c(level.spigotConfig.hopperTransfer);
        }
        return false;
    }

    private static boolean hopperPull(World level, IHopper hopper, IInventory container, ItemStack origItemStack, int i2) {
        ItemStack movedItem = origItemStack;
        int originalItemCount = origItemStack.L();
        int movedItemCount = Math.min(level.spigotConfig.hopperAmount, originalItemCount);
        container.e();
        movedItem.f(movedItemCount);
        if (!skipPullModeEventFire && (movedItem = TileEntityHopper.callPullMoveEvent(hopper, container, movedItem)) == null) {
            origItemStack.f(originalItemCount);
            return true;
        }
        ItemStack remainingItem = TileEntityHopper.a(container, hopper, movedItem, null);
        int remainingItemCount = remainingItem.L();
        if (remainingItemCount != movedItemCount) {
            origItemStack = origItemStack.copy(true);
            origItemStack.f(originalItemCount);
            if (!origItemStack.b()) {
                origItemStack.f(originalItemCount - movedItemCount + remainingItemCount);
            }
            TileEntity.ignoreTileUpdates = true;
            container.a(i2, origItemStack);
            TileEntity.ignoreTileUpdates = false;
            container.e();
            return true;
        }
        origItemStack.f(originalItemCount);
        if (level.paperConfig().hopper.cooldownWhenFull) {
            TileEntityHopper.cooldownHopper(hopper);
        }
        return false;
    }

    @Nullable
    private static ItemStack callPushMoveEvent(IInventory iinventory, ItemStack itemstack, TileEntityHopper hopper) {
        Inventory destinationInventory = TileEntityHopper.getInventory(iinventory);
        PaperInventoryMoveItemEvent event = new PaperInventoryMoveItemEvent(hopper.getOwner(false).getInventory(), CraftItemStack.asCraftMirror(itemstack), destinationInventory, true);
        boolean result = event.callEvent();
        if (!event.calledGetItem && !event.calledSetItem) {
            skipPushModeEventFire = true;
        }
        if (!result) {
            TileEntityHopper.cooldownHopper(hopper);
            return null;
        }
        if (event.calledSetItem) {
            return CraftItemStack.asNMSCopy(event.getItem());
        }
        return itemstack;
    }

    @Nullable
    private static ItemStack callPullMoveEvent(IHopper hopper, IInventory container, ItemStack itemstack) {
        Inventory sourceInventory = TileEntityHopper.getInventory(container);
        Inventory destination = TileEntityHopper.getInventory(hopper);
        PaperInventoryMoveItemEvent event = new PaperInventoryMoveItemEvent(sourceInventory, CraftItemStack.asCraftMirror(itemstack), destination, false);
        boolean result = event.callEvent();
        if (!event.calledGetItem && !event.calledSetItem) {
            skipPullModeEventFire = true;
        }
        if (!result) {
            TileEntityHopper.cooldownHopper(hopper);
            return null;
        }
        if (event.calledSetItem) {
            return CraftItemStack.asNMSCopy(event.getItem());
        }
        return itemstack;
    }

    private static Inventory getInventory(IInventory container) {
        CraftInventory sourceInventory;
        if (container instanceof InventoryLargeChest) {
            InventoryLargeChest compoundContainer = (InventoryLargeChest)container;
            sourceInventory = new CraftInventoryDoubleChest(compoundContainer);
        } else if (container instanceof TileEntity) {
            TileEntity blockEntity = (TileEntity)((Object)container);
            sourceInventory = blockEntity.getOwner(false).getInventory();
        } else {
            sourceInventory = container.getOwner() != null ? container.getOwner().getInventory() : new CraftInventory(container);
        }
        return sourceInventory;
    }

    private static void cooldownHopper(IHopper hopper) {
        TileEntityHopper blockEntity;
        if (hopper instanceof TileEntityHopper && (blockEntity = (TileEntityHopper)hopper).i() != null) {
            blockEntity.c(blockEntity.i().spigotConfig.hopperTransfer);
        }
    }

    private static boolean allMatch(IInventory iinventory, EnumDirection enumdirection, BiPredicate<ItemStack, Integer> test) {
        if (iinventory instanceof IWorldInventory) {
            for (int i2 : ((IWorldInventory)iinventory).a(enumdirection)) {
                if (test.test(iinventory.a(i2), i2)) continue;
                return false;
            }
        } else {
            int size = iinventory.b();
            for (int i3 = 0; i3 < size; ++i3) {
                if (test.test(iinventory.a(i3), i3)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean anyMatch(IInventory iinventory, EnumDirection enumdirection, BiPredicate<ItemStack, Integer> test) {
        if (iinventory instanceof IWorldInventory) {
            for (int i2 : ((IWorldInventory)iinventory).a(enumdirection)) {
                if (!test.test(iinventory.a(i2), i2)) continue;
                return true;
            }
        } else {
            int size = iinventory.b();
            for (int i3 = 0; i3 < size; ++i3) {
                if (!test.test(iinventory.a(i3), i3)) continue;
                return true;
            }
        }
        return true;
    }

    private static boolean ejectItems(World world, BlockPosition blockposition, IBlockData iblockdata, IInventory iinventory, TileEntityHopper hopper) {
        IInventory iinventory1 = TileEntityHopper.b(world, blockposition, iblockdata);
        if (iinventory1 == null) {
            return false;
        }
        EnumDirection enumdirection = iblockdata.c(BlockHopper.b).g();
        if (TileEntityHopper.b(iinventory1, enumdirection)) {
            return false;
        }
        return TileEntityHopper.hopperPush(world, iinventory1, enumdirection, hopper);
    }

    private static IntStream a(IInventory inventory, EnumDirection side) {
        return inventory instanceof IWorldInventory ? IntStream.of(((IWorldInventory)inventory).a(side)) : IntStream.range(0, inventory.b());
    }

    private static boolean b(IInventory inventory, EnumDirection direction) {
        return inventory.isCompletelyFull(direction);
    }

    private static boolean c(IInventory inv, EnumDirection facing) {
        return inv.isCompletelyEmpty(facing);
    }

    public static boolean a(World world, IHopper hopper) {
        EntityItem entityitem;
        IInventory iinventory = TileEntityHopper.c(world, hopper);
        if (iinventory != null) {
            EnumDirection enumdirection = EnumDirection.a;
            skipPullModeEventFire = skipHopperEvents;
            if (iinventory instanceof IWorldInventory) {
                IWorldInventory worldlyContainer = (IWorldInventory)iinventory;
                for (int slot : worldlyContainer.a(enumdirection)) {
                    ItemStack item = worldlyContainer.a(slot);
                    if (item.b() || !TileEntityHopper.a((IInventory)hopper, iinventory, item, slot, enumdirection) || !TileEntityHopper.hopperPull(world, hopper, iinventory, item, slot)) continue;
                    return true;
                }
                return false;
            }
            int max = iinventory.b();
            for (int slot = 0; slot < max; ++slot) {
                ItemStack item = iinventory.a(slot);
                if (item.b() || !TileEntityHopper.a((IInventory)hopper, iinventory, item, slot, enumdirection) || !TileEntityHopper.hopperPull(world, hopper, iinventory, item, slot)) continue;
                return true;
            }
            return false;
        }
        Iterator<EntityItem> iterator = TileEntityHopper.b(world, hopper).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!TileEntityHopper.a((IInventory)hopper, entityitem = iterator.next()));
        return true;
    }

    @DoNotUse
    private static boolean a(IHopper ihopper, IInventory iinventory, int i2, EnumDirection enumdirection, World world) {
        ItemStack itemstack = iinventory.a(i2);
        if (!itemstack.b() && TileEntityHopper.a((IInventory)ihopper, iinventory, itemstack, i2, enumdirection)) {
            return TileEntityHopper.hopperPull(world, ihopper, iinventory, itemstack, i2);
        }
        return false;
    }

    public static boolean a(IInventory inventory, EntityItem itemEntity) {
        ItemStack itemstack;
        ItemStack itemstack1;
        boolean flag = false;
        if (InventoryPickupItemEvent.getHandlerList().getRegisteredListeners().length > 0) {
            InventoryPickupItemEvent event = new InventoryPickupItemEvent(TileEntityHopper.getInventory(inventory), (Item)itemEntity.getBukkitEntity());
            itemEntity.dM().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
        }
        if ((itemstack1 = TileEntityHopper.a((IInventory)null, inventory, itemstack = itemEntity.q().p(), (EnumDirection)null)).b()) {
            flag = true;
            itemEntity.a(ItemStack.f);
            itemEntity.discard(EntityRemoveEvent.Cause.PICKUP);
        } else {
            itemEntity.a(itemstack1);
        }
        return flag;
    }

    public static ItemStack a(@Nullable IInventory from, IInventory to, ItemStack stack, @Nullable EnumDirection side) {
        if (to instanceof IWorldInventory) {
            IWorldInventory iworldinventory = (IWorldInventory)to;
            if (side != null) {
                int[] aint = iworldinventory.a(side);
                for (int i2 = 0; i2 < aint.length && !stack.b(); ++i2) {
                    stack = TileEntityHopper.b(from, to, stack, aint[i2], side);
                }
                return stack;
            }
        }
        int j2 = to.b();
        for (int i3 = 0; i3 < j2 && !stack.b(); ++i3) {
            stack = TileEntityHopper.b(from, to, stack, i3, side);
        }
        return stack;
    }

    private static boolean a(IInventory inventory, ItemStack stack, int slot, @Nullable EnumDirection side) {
        IWorldInventory iworldinventory;
        if (!inventory.b(slot, stack)) {
            return false;
        }
        if (inventory instanceof IWorldInventory && !(iworldinventory = (IWorldInventory)inventory).a(slot, stack, side)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static boolean a(IInventory hopperInventory, IInventory fromInventory, ItemStack stack, int slot, EnumDirection facing) {
        IWorldInventory iworldinventory;
        if (!fromInventory.a(hopperInventory, slot, stack)) {
            return false;
        }
        if (fromInventory instanceof IWorldInventory && !(iworldinventory = (IWorldInventory)fromInventory).b(slot, stack, facing)) {
            boolean flag = false;
            return flag;
        }
        boolean flag = true;
        return flag;
    }

    private static ItemStack b(@Nullable IInventory from, IInventory to, ItemStack stack, int slot, @Nullable EnumDirection side) {
        ItemStack itemstack1 = to.a(slot);
        if (TileEntityHopper.a(to, stack, slot, side)) {
            boolean flag = false;
            boolean flag1 = to.isCompletelyEmpty(side);
            if (itemstack1.b()) {
                ItemStack leftover = ItemStack.f;
                if (!stack.b() && stack.L() > to.ak_()) {
                    leftover = stack;
                    stack = stack.a(to.ak_());
                }
                TileEntity.ignoreTileUpdates = true;
                to.a(slot, stack);
                TileEntity.ignoreTileUpdates = false;
                stack = leftover;
                flag = true;
            } else if (TileEntityHopper.a(itemstack1, stack)) {
                int j2 = Math.min(stack.g(), to.ak_()) - itemstack1.L();
                int k2 = Math.min(stack.L(), j2);
                stack.h(k2);
                itemstack1.g(k2);
                boolean bl = flag = k2 > 0;
            }
            if (flag) {
                TileEntityHopper tileentityhopper;
                if (flag1 && to instanceof TileEntityHopper && !(tileentityhopper = (TileEntityHopper)to).x()) {
                    int b0 = 0;
                    if (from instanceof TileEntityHopper) {
                        TileEntityHopper tileentityhopper1 = (TileEntityHopper)from;
                        if (tileentityhopper.j >= tileentityhopper1.j) {
                            b0 = 1;
                        }
                    }
                    tileentityhopper.c(tileentityhopper.o.spigotConfig.hopperTransfer - b0);
                }
                to.e();
            }
        }
        return stack;
    }

    @Nullable
    private static IInventory runHopperInventorySearchEvent(IInventory inventory, CraftBlock hopper, CraftBlock searchLocation, HopperInventorySearchEvent.ContainerType containerType) {
        HopperInventorySearchEvent event = new HopperInventorySearchEvent((Inventory)(inventory != null ? new CraftInventory(inventory) : null), containerType, (org.bukkit.block.Block)hopper, (org.bukkit.block.Block)searchLocation);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        CraftInventory craftInventory = (CraftInventory)event.getInventory();
        return craftInventory != null ? craftInventory.getInventory() : null;
    }

    @Nullable
    private static IInventory b(World world, BlockPosition pos, IBlockData state) {
        EnumDirection enumdirection = state.c(BlockHopper.b);
        BlockPosition searchPosition = pos.a(enumdirection);
        IInventory inventory = TileEntityHopper.a(world, pos.a(enumdirection));
        CraftBlock hopper = CraftBlock.at(world, pos);
        CraftBlock searchBlock = CraftBlock.at(world, searchPosition);
        return TileEntityHopper.runHopperInventorySearchEvent(inventory, hopper, searchBlock, HopperInventorySearchEvent.ContainerType.DESTINATION);
    }

    @Nullable
    private static IInventory c(World world, IHopper hopper) {
        IInventory inventory = TileEntityHopper.a(world, hopper.I(), hopper.J() + 1.0, hopper.K());
        BlockPosition blockPosition = BlockPosition.a(hopper.I(), hopper.J(), hopper.K());
        CraftBlock hopper1 = CraftBlock.at(world, blockPosition);
        CraftBlock container = CraftBlock.at(world, blockPosition.c());
        return TileEntityHopper.runHopperInventorySearchEvent(inventory, hopper1, container, HopperInventorySearchEvent.ContainerType.SOURCE);
    }

    public static List<EntityItem> b(World world, IHopper hopper) {
        double shiftX = hopper.I() - 0.5;
        double shiftY = hopper.J() - 0.5;
        double shiftZ = hopper.K() - 0.5;
        return world.a(EntityItem.class, HOPPER_ITEM_SUCK_OVERALL.d(shiftX, shiftY, shiftZ), (? super T entity) -> {
            if (!entity.bx()) {
                return false;
            }
            for (AxisAlignedBB aabb : HOPPER_ITEM_SUCK_INDIVIDUAL) {
                if (!aabb.d(shiftX, shiftY, shiftZ).c(entity.cH())) continue;
                return true;
            }
            return false;
        });
    }

    @Nullable
    public static IInventory a(World world, BlockPosition pos) {
        return TileEntityHopper.getContainerAt(world, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, true);
    }

    @Nullable
    private static IInventory a(World world, double x2, double y2, double z2) {
        return TileEntityHopper.getContainerAt(world, x2, y2, z2, false);
    }

    @Nullable
    private static IInventory getContainerAt(World world, double x2, double y2, double z2, boolean optimizeEntities) {
        List<Entity> list;
        TileEntity tileentity;
        IInventory object = null;
        BlockPosition blockposition = BlockPosition.a(x2, y2, z2);
        if (!world.spigotConfig.hopperCanLoadChunks && !world.B(blockposition)) {
            return null;
        }
        IBlockData iblockdata = world.a_(blockposition);
        Block block = iblockdata.b();
        if (block instanceof IInventoryHolder) {
            object = ((IInventoryHolder)((Object)block)).a(iblockdata, world, blockposition);
        } else if (iblockdata.t() && (tileentity = world.c_(blockposition)) instanceof IInventory && (object = (IInventory)((Object)tileentity)) instanceof TileEntityChest && block instanceof BlockChest) {
            object = BlockChest.a((BlockChest)block, iblockdata, world, blockposition, true);
        }
        if (!(object != null || optimizeEntities && world.paperConfig().hopper.ignoreOccludingBlocks && iblockdata.getBukkitMaterial().isOccluding() || (list = world.a(IInventory.class, new AxisAlignedBB(x2 - 0.5, y2 - 0.5, z2 - 0.5, x2 + 0.5, y2 + 0.5, z2 + 0.5), IEntitySelector.d)).isEmpty())) {
            object = (IInventory)((Object)list.get(world.z.a(list.size())));
        }
        return object;
    }

    private static boolean a(ItemStack first, ItemStack second) {
        return first.L() < first.g() && first.a(second.d()) && first.k() == second.k() && (first.b() && second.b() || Objects.equals(first.v(), second.v()));
    }

    @Override
    public double I() {
        return (double)this.p.u() + 0.5;
    }

    @Override
    public double J() {
        return (double)this.p.v() + 0.5;
    }

    @Override
    public double K() {
        return (double)this.p.w() + 0.5;
    }

    public void c(int transferCooldown) {
        this.i = transferCooldown;
    }

    private boolean w() {
        return this.i > 0;
    }

    private boolean x() {
        return this.i > 8;
    }

    @Override
    protected NonNullList<ItemStack> k() {
        return this.h;
    }

    @Override
    protected void a(NonNullList<ItemStack> list) {
        this.optimizedItems = ItemListWithBitset.fromList(list);
        this.h = this.optimizedItems.nonNullList;
    }

    public static void a(World world, BlockPosition pos, IBlockData state, Entity entity, TileEntityHopper blockEntity) {
        EntityItem entityitem;
        if (entity instanceof EntityItem && !(entityitem = (EntityItem)entity).q().b() && VoxelShapes.c(VoxelShapes.a(entity.cH().d(-pos.u(), -pos.v(), -pos.w())), blockEntity.aj_(), OperatorBoolean.i)) {
            TileEntityHopper.a(world, pos, state, blockEntity, () -> TileEntityHopper.a((IInventory)blockEntity, entityitem));
        }
    }

    @Override
    protected Container a(int syncId, PlayerInventory playerInventory) {
        return new ContainerHopper(syncId, playerInventory, this);
    }

    static {
        STACK_SIZE_TEST = (itemstack, i2) -> itemstack.L() >= itemstack.g();
        IS_EMPTY_TEST = (itemstack, i2) -> itemstack.b();
        HOPPER_ITEM_SUCK_OVERALL = IHopper.e.a();
        HOPPER_ITEM_SUCK_INDIVIDUAL = IHopper.e.e().toArray(new AxisAlignedBB[0]);
    }
}

