/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import com.destroystokyo.paper.loottable.PaperTileEntityLootableInventory;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftNamespacedKey;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityLootable
extends TileEntityContainer
implements RandomizableContainer {
    @javax.annotation.Nullable
    public MinecraftKey m;
    public long n;
    public final PaperLootableInventoryData lootableData = new PaperLootableInventoryData(new PaperTileEntityLootableInventory(this));

    protected TileEntityLootable(TileEntityTypes<?> type, BlockPosition pos, IBlockData state) {
        super(type, pos, state);
    }

    @Override
    @javax.annotation.Nullable
    public MinecraftKey az_() {
        return this.m;
    }

    @Override
    public void a(@javax.annotation.Nullable MinecraftKey lootTableId) {
        this.m = lootTableId;
    }

    @Override
    public long aA_() {
        return this.n;
    }

    @Override
    public void a(long lootTableSeed) {
        this.n = lootTableSeed;
    }

    @Override
    public boolean c_(NBTTagCompound nbt) {
        this.lootableData.loadNbt(nbt);
        if (nbt.b("LootTable", 8)) {
            this.a(MinecraftKey.a(nbt.l("LootTable")));
            try {
                CraftNamespacedKey.fromMinecraft(this.m);
            }
            catch (IllegalArgumentException ex) {
                this.m = null;
            }
            this.a(nbt.i("LootTableSeed"));
            return false;
        }
        return false;
    }

    @Override
    public boolean d_(NBTTagCompound nbt) {
        this.lootableData.saveNbt(nbt);
        RandomizableContainer.super.d_(nbt);
        return false;
    }

    @Override
    public void e_(@Nullable EntityHuman player) {
        World level = this.i();
        BlockPosition blockPos = this.aB_();
        MinecraftKey resourceLocation = this.az_();
        if (this.lootableData.shouldReplenish(player) && level != null) {
            LootTable lootTable = level.o().aJ().getLootTable(resourceLocation);
            if (player instanceof EntityPlayer) {
                CriterionTriggers.O.a((EntityPlayer)player, resourceLocation);
            }
            this.lootableData.processRefill(player);
            LootParams.a builder = new LootParams.a((WorldServer)level).a(LootContextParameters.f, Vec3D.b(blockPos));
            if (player != null) {
                builder.a(player.go()).a(LootContextParameters.a, player);
            }
            lootTable.a(this, builder.a(LootContextParameterSets.c), this.aA_());
        }
    }

    @Override
    public boolean ai_() {
        this.e_(null);
        return this.isCompletelyEmpty(null);
    }

    @Override
    public ItemStack a(int slot) {
        if (slot == 0) {
            this.e_(null);
        }
        return this.k().get(slot);
    }

    @Override
    public ItemStack a(int slot, int amount) {
        this.e_(null);
        ItemStack itemStack = ContainerUtil.a(this.k(), slot, amount);
        if (!itemStack.b()) {
            this.e();
        }
        return itemStack;
    }

    @Override
    public ItemStack b(int slot) {
        this.e_(null);
        return ContainerUtil.a(this.k(), slot);
    }

    @Override
    public void a(int slot, ItemStack stack) {
        this.e_(null);
        this.k().set(slot, stack);
        if (stack.L() > this.ak_()) {
            stack.f(this.ak_());
        }
        this.e();
    }

    @Override
    public boolean a(EntityHuman player) {
        return IInventory.a(this, player);
    }

    @Override
    public void a() {
        this.k().clear();
    }

    protected abstract NonNullList<ItemStack> k();

    protected abstract void a(NonNullList<ItemStack> var1);

    @Override
    public boolean d(EntityHuman player) {
        return super.d(player) && (this.m == null || !player.P_());
    }

    @Override
    @javax.annotation.Nullable
    public Container createMenu(int syncId, PlayerInventory playerInventory, EntityHuman player) {
        if (this.d(player)) {
            this.e_(playerInventory.m);
            return this.a(syncId, playerInventory);
        }
        return null;
    }
}

