/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.destroystokyo.paper.profile.PaperMinecraftSessionService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.Services;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockSkullAbstract;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntitySkull
extends TileEntity {
    public static final String a = "SkullOwner";
    public static final String b = "note_block_sound";
    @Nullable
    private static Executor c;
    @Nullable
    private static LoadingCache<String, CompletableFuture<Optional<GameProfile>>> d;
    private static final Executor e;
    @Nullable
    public GameProfile f;
    @Nullable
    public MinecraftKey g;
    private int h;
    private boolean i;

    public TileEntitySkull(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.p, pos, state);
    }

    public static void a(final Services apiServices, Executor executor) {
        c = executor;
        final BooleanSupplier booleansupplier = () -> d == null;
        d = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<String, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> a(String s2) {
                return booleansupplier.getAsBoolean() ? CompletableFuture.completedFuture(Optional.empty()) : TileEntitySkull.a(s2, apiServices, booleansupplier);
            }
        });
    }

    public static void c() {
        c = null;
        d = null;
    }

    static CompletableFuture<Optional<GameProfile>> a(String name, Services apiServices, BooleanSupplier booleansupplier) {
        return apiServices.f().b(name).thenApplyAsync(optional -> {
            if (optional.isPresent() && !booleansupplier.getAsBoolean()) {
                ProfileResult profileResult;
                UUID uuid = ((GameProfile)optional.get()).getId();
                MinecraftSessionService minecraftSessionService = apiServices.c();
                if (minecraftSessionService instanceof PaperMinecraftSessionService) {
                    PaperMinecraftSessionService paperMinecraftSessionService = (PaperMinecraftSessionService)minecraftSessionService;
                    profileResult = paperMinecraftSessionService.fetchProfile((GameProfile)optional.get(), true);
                } else {
                    profileResult = apiServices.c().fetchProfile(uuid, true);
                }
                ProfileResult profileresult = profileResult;
                return profileresult != null ? Optional.ofNullable(profileresult.profile()) : optional;
            }
            return Optional.empty();
        }, (Executor)SystemUtils.PROFILE_EXECUTOR);
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.f != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            GameProfileSerializer.a(nbttagcompound1, this.f);
            nbt.a(a, nbttagcompound1);
        }
        if (this.g != null) {
            nbt.a(b, this.g.toString());
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        String s2;
        super.a(nbt);
        if (nbt.b(a, 10)) {
            this.a(GameProfileSerializer.a(nbt.p(a)));
        } else if (nbt.b("ExtraType", 8) && !UtilColor.b(s2 = nbt.l("ExtraType"))) {
            this.a(new GameProfile(SystemUtils.d, s2));
        }
        if (nbt.b(b, 8)) {
            this.g = MinecraftKey.a(nbt.l(b));
        }
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntitySkull blockEntity) {
        if (state.b(BlockSkullAbstract.a) && state.c(BlockSkullAbstract.a).booleanValue()) {
            blockEntity.i = true;
            ++blockEntity.h;
        } else {
            blockEntity.i = false;
        }
    }

    public float a(float tickDelta) {
        return this.i ? (float)this.h + tickDelta : (float)this.h;
    }

    @Nullable
    public GameProfile d() {
        return this.f;
    }

    @Nullable
    public MinecraftKey f() {
        return this.g;
    }

    public PacketPlayOutTileEntityData g() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound ax_() {
        return this.q();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(@Nullable GameProfile owner) {
        TileEntitySkull tileEntitySkull = this;
        synchronized (tileEntitySkull) {
            this.f = owner;
        }
        this.k();
    }

    private void k() {
        if (this.f != null && !SystemUtils.b(this.f.getName()) && !TileEntitySkull.b(this.f)) {
            TileEntitySkull.a(this.f.getName()).thenAcceptAsync(optional -> {
                this.f = optional.orElse(this.f);
                this.e();
            }, e);
        } else {
            this.e();
        }
    }

    @Nullable
    public static GameProfile d(NBTTagCompound nbt) {
        String s2;
        if (nbt.b(a, 10)) {
            return GameProfileSerializer.a(nbt.p(a));
        }
        if (nbt.b(a, 8) && !SystemUtils.b(s2 = nbt.l(a))) {
            nbt.r(a);
            TileEntitySkull.a(nbt, s2);
        }
        return null;
    }

    public static void e(NBTTagCompound nbt) {
        String s2 = nbt.l(a);
        if (!SystemUtils.b(s2)) {
            TileEntitySkull.a(nbt, s2);
        } else {
            NBTTagList textures = nbt.p(a).p("Properties").c("textures", 10);
            for (int i2 = 0; i2 < textures.size(); ++i2) {
                if (!(textures.k(i2) instanceof NBTTagCompound) || ((NBTTagCompound)textures.k(i2)).b("Signature", 8) || !((NBTTagCompound)textures.k(i2)).l("Value").trim().isEmpty()) continue;
                nbt.r(a);
                break;
            }
        }
    }

    private static void a(NBTTagCompound nbt, String name) {
        TileEntitySkull.a(name).thenAccept(optional -> nbt.a(a, GameProfileSerializer.a(new NBTTagCompound(), optional.orElse(new GameProfile(SystemUtils.d, name)))));
    }

    private static CompletableFuture<Optional<GameProfile>> a(String name) {
        LoadingCache<String, CompletableFuture<Optional<GameProfile>>> loadingcache = d;
        return loadingcache != null && EntityHuman.c(name) ? (CompletableFuture)loadingcache.getUnchecked((Object)name) : CompletableFuture.completedFuture(Optional.empty());
    }

    private static boolean b(GameProfile profile) {
        return profile.getProperties().containsKey((Object)"textures");
    }

    static {
        e = runnable -> {
            Executor executor = c;
            if (executor != null) {
                executor.execute(runnable);
            }
        };
    }
}

