/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public final class TrialSpawner {
    public static final int a = 40;
    private static final int b = 47;
    private static final int c = MathHelper.h(47);
    private static final float d = 0.02f;
    private final TrialSpawnerConfig e;
    private final TrialSpawnerData f;
    private final a g;
    private PlayerDetector h;
    private boolean i;

    public Codec<TrialSpawner> a() {
        return RecordCodecBuilder.create(instance -> instance.group((App)TrialSpawnerConfig.b.forGetter(TrialSpawner::b), (App)TrialSpawnerData.b.forGetter(TrialSpawner::c)).apply((Applicative)instance, (trialSpawnerConfig, trialSpawnerData) -> new TrialSpawner((TrialSpawnerConfig)trialSpawnerConfig, (TrialSpawnerData)trialSpawnerData, this.g, this.h)));
    }

    public TrialSpawner(a trialSpawner, PlayerDetector entityDetector) {
        this(TrialSpawnerConfig.a, new TrialSpawnerData(), trialSpawner, entityDetector);
    }

    public TrialSpawner(TrialSpawnerConfig config, TrialSpawnerData data, a trialSpawner, PlayerDetector entityDetector) {
        this.e = config;
        this.f = data;
        this.f.a(config);
        this.g = trialSpawner;
        this.h = entityDetector;
    }

    public TrialSpawnerConfig b() {
        return this.e;
    }

    public TrialSpawnerData c() {
        return this.f;
    }

    public TrialSpawnerState d() {
        return this.g.f();
    }

    public void a(World world, TrialSpawnerState spawnerState) {
        this.g.a(world, spawnerState);
    }

    public void e() {
        this.g.g();
    }

    public PlayerDetector f() {
        return this.h;
    }

    public boolean a(World world) {
        if (this.i) {
            return true;
        }
        if (world.ak() == EnumDifficulty.a) {
            return false;
        }
        return world.Z().b(GameRules.e);
    }

    public Optional<UUID> a(WorldServer world, BlockPosition pos) {
        double f2;
        RandomSource randomSource = world.F_();
        MobSpawnerData spawnData = this.f.a(this, world.F_());
        NBTTagCompound compoundTag = spawnData.c();
        NBTTagList listTag = compoundTag.c("Pos", 6);
        Optional<EntityTypes<?>> optional = EntityTypes.a(compoundTag);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        int i2 = listTag.size();
        double d2 = i2 >= 1 ? listTag.h(0) : (double)pos.u() + (randomSource.j() - randomSource.j()) * (double)this.e.b() + 0.5;
        double e2 = i2 >= 2 ? listTag.h(1) : (double)(pos.v() + randomSource.a(3) - 1);
        double d3 = f2 = i2 >= 3 ? listTag.h(2) : (double)pos.w() + (randomSource.j() - randomSource.j()) * (double)this.e.b() + 0.5;
        if (!world.b(optional.get().a(d2, e2, f2))) {
            return Optional.empty();
        }
        Vec3D vec3 = new Vec3D(d2, e2, f2);
        if (!TrialSpawner.a((World)world, pos.b(), vec3)) {
            return Optional.empty();
        }
        BlockPosition blockPos = BlockPosition.a(vec3);
        if (!EntityPositionTypes.a(optional.get(), world, EnumMobSpawn.q, blockPos, world.F_())) {
            return Optional.empty();
        }
        Entity entity2 = EntityTypes.a(compoundTag, world, (Entity entity) -> {
            entity.b(d2, e2, f2, randomSource.i() * 360.0f, 0.0f);
            return entity;
        });
        if (entity2 == null) {
            return Optional.empty();
        }
        if (entity2 instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)entity2;
            if (!mob.a((IWorldReader)world)) {
                return Optional.empty();
            }
            if (spawnData.a().f() == 1 && spawnData.a().b("id", 8)) {
                mob.a(world, world.d_(mob.dm()), EnumMobSpawn.q, null, null);
                mob.fJ();
            }
        }
        if (!world.e(entity2)) {
            return Optional.empty();
        }
        world.c(3011, pos, 0);
        world.c(3012, blockPos, 0);
        world.a(entity2, GameEvent.t, blockPos);
        return Optional.of(entity2.cw());
    }

    public void a(WorldServer world, BlockPosition pos, MinecraftKey lootTable) {
        LootParams lootParams;
        LootTable lootTable2 = world.o().aJ().getLootTable(lootTable);
        ObjectArrayList<ItemStack> objectArrayList = lootTable2.a(lootParams = new LootParams.a(world).a(LootContextParameterSets.b));
        if (!objectArrayList.isEmpty()) {
            for (ItemStack itemStack : objectArrayList) {
                DispenseBehaviorItem.a(world, itemStack, 2, EnumDirection.b, Vec3D.c(pos).a(EnumDirection.b, 1.2));
            }
            world.c(3014, pos, 0);
        }
    }

    public void a(World world, BlockPosition pos) {
        RandomSource randomSource;
        if (!this.a(world)) {
            this.f.m = this.f.l;
            return;
        }
        TrialSpawnerState trialSpawnerState = this.d();
        trialSpawnerState.a(world, pos);
        if (trialSpawnerState.d()) {
            double d2 = Math.max(0L, this.f.f - world.X());
            this.f.m = this.f.l;
            this.f.l = (this.f.l + trialSpawnerState.b() / (d2 + 200.0)) % 360.0;
        }
        if (trialSpawnerState.e() && (randomSource = world.F_()).i() <= 0.02f) {
            world.a(pos, SoundEffects.lv, SoundCategory.e, randomSource.i() * 0.25f + 0.75f, randomSource.i() + 0.5f, false);
        }
    }

    public void b(WorldServer world, BlockPosition pos) {
        TrialSpawnerState trialSpawnerState2;
        TrialSpawnerState trialSpawnerState = this.d();
        if (!this.a(world)) {
            if (trialSpawnerState.e()) {
                this.f.a();
                this.a((World)world, TrialSpawnerState.a);
            }
            return;
        }
        if (this.f.d.removeIf(uuid -> TrialSpawner.a(world, pos, uuid))) {
            this.f.f = world.X() + (long)this.e.g();
        }
        if ((trialSpawnerState2 = trialSpawnerState.a(pos, this, world)) != trialSpawnerState) {
            this.a((World)world, trialSpawnerState2);
        }
    }

    private static boolean a(WorldServer world, BlockPosition pos, UUID uuid) {
        Entity entity = world.a(uuid);
        return entity == null || !entity.bx() || !entity.dM().ae().equals(world.ae()) || entity.dm().j(pos) > (double)c;
    }

    private static boolean a(World world, Vec3D spawnerPos, Vec3D spawnPos) {
        MovingObjectPositionBlock blockHitResult = world.a(new RayTrace(spawnPos, spawnerPos, RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, VoxelShapeCollision.a()));
        return blockHitResult.a().equals(BlockPosition.a(spawnerPos)) || blockHitResult.c() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public static void a(World world, BlockPosition pos, RandomSource random) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = (double)pos.u() + 0.5 + (random.j() - 0.5) * 2.0;
            double e2 = (double)pos.v() + 0.5 + (random.j() - 0.5) * 2.0;
            double f2 = (double)pos.w() + 0.5 + (random.j() - 0.5) * 2.0;
            world.a(Particles.ab, d2, e2, f2, 0.0, 0.0, 0.0);
            world.a(Particles.E, d2, e2, f2, 0.0, 0.0, 0.0);
        }
    }

    public static void a(World world, BlockPosition pos, RandomSource random, int playerCount) {
        for (int i2 = 0; i2 < 30 + Math.min(playerCount, 10) * 5; ++i2) {
            double d2 = (double)(2.0f * random.i() - 1.0f) * 0.65;
            double e2 = (double)(2.0f * random.i() - 1.0f) * 0.65;
            double f2 = (double)pos.u() + 0.5 + d2;
            double g2 = (double)pos.v() + 0.1 + (double)random.i() * 0.8;
            double h2 = (double)pos.w() + 0.5 + e2;
            world.a(Particles.aW, f2, g2, h2, 0.0, 0.0, 0.0);
        }
    }

    public static void b(World world, BlockPosition pos, RandomSource random) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = (double)pos.u() + 0.4 + random.j() * 0.2;
            double e2 = (double)pos.v() + 0.4 + random.j() * 0.2;
            double f2 = (double)pos.w() + 0.4 + random.j() * 0.2;
            double g2 = random.k() * 0.02;
            double h2 = random.k() * 0.02;
            double j2 = random.k() * 0.02;
            world.a(Particles.aG, d2, e2, f2, g2, h2, j2 * 0.25);
            world.a(Particles.ab, d2, e2, f2, g2, h2, j2);
        }
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void a(PlayerDetector detector) {
        this.h = detector;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void g() {
        this.i = true;
    }

    public static interface a {
        public void a(World var1, TrialSpawnerState var2);

        public TrialSpawnerState f();

        public void g();
    }
}

