/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import org.slf4j.Logger;

public class EntityStorage
implements EntityPersistentStorage<Entity> {
    private static final Logger b = LogUtils.getLogger();
    private static final String c = "Entities";
    private static final String d = "Position";
    public final WorldServer e;
    private final LongSet g = new LongOpenHashSet();
    protected final DataFixer a;

    public EntityStorage(WorldServer world, Path path, DataFixer dataFixer, boolean dsync, Executor executor) {
        this.e = world;
        this.a = dataFixer;
    }

    @Override
    public CompletableFuture<ChunkEntities<Entity>> a(ChunkCoordIntPair pos) {
        throw new UnsupportedOperationException();
    }

    public static List<Entity> readEntities(WorldServer level, NBTTagCompound compoundTag) {
        NBTTagList listTag = compoundTag.c(c, 10);
        List list = (List)EntityTypes.a(listTag, (World)level).collect(ImmutableList.toImmutableList());
        return list;
    }

    public static ChunkCoordIntPair a(NBTTagCompound chunkNbt) {
        int[] is = chunkNbt.n(d);
        return new ChunkCoordIntPair(is[0], is[1]);
    }

    private static void a(NBTTagCompound chunkNbt, ChunkCoordIntPair pos) {
        chunkNbt.a(d, new NBTTagIntArray(new int[]{pos.e, pos.f}));
    }

    private static ChunkEntities<Entity> b(ChunkCoordIntPair pos) {
        return new ChunkEntities<Entity>(pos, (List<Entity>)ImmutableList.of());
    }

    @Override
    public void a(ChunkEntities<Entity> dataList) {
        throw new UnsupportedOperationException();
    }

    public static void copyEntities(NBTTagCompound from, NBTTagCompound into) {
        if (from == null) {
            return;
        }
        NBTTagList entitiesFrom = from.c(c, 10);
        if (entitiesFrom == null || entitiesFrom.isEmpty()) {
            return;
        }
        NBTTagList entitiesInto = into.c(c, 10);
        into.a(c, entitiesInto);
        entitiesInto.addAll(0, entitiesFrom.e());
    }

    public static NBTTagCompound saveEntityChunk(List<Entity> entities, ChunkCoordIntPair chunkPos, WorldServer level) {
        return EntityStorage.saveEntityChunk0(entities, chunkPos, level, false);
    }

    private static NBTTagCompound saveEntityChunk0(List<Entity> entities, ChunkCoordIntPair chunkPos, WorldServer level, boolean force) {
        if (!force && entities.isEmpty()) {
            return null;
        }
        NBTTagList listTag = new NBTTagList();
        HashMap savedEntityCounts = new HashMap();
        entities.forEach(entity -> {
            NBTTagCompound compoundTag;
            if (!entity.canSaveToDisk()) {
                return;
            }
            EntityTypes<?> entityType = entity.ai();
            int saveLimit = level.paperConfig().chunks.entityPerChunkSaveLimit.getOrDefault(entityType, -1);
            if (saveLimit > -1) {
                if (savedEntityCounts.getOrDefault(entityType, 0) >= saveLimit) {
                    return;
                }
                savedEntityCounts.merge(entityType, 1, Integer::sum);
            }
            if (entity.e(compoundTag = new NBTTagCompound())) {
                listTag.add(compoundTag);
            }
        });
        NBTTagCompound compoundTag = GameProfileSerializer.g(new NBTTagCompound());
        compoundTag.a(c, listTag);
        EntityStorage.a(compoundTag, chunkPos);
        return !force && listTag.isEmpty() ? null : compoundTag;
    }

    @Override
    public void a(boolean sync) {
        throw new UnsupportedOperationException();
    }

    public static NBTTagCompound b(NBTTagCompound chunkNbt) {
        int i2 = GameProfileSerializer.b(chunkNbt, -1);
        return MCDataConverter.convertTag(MCTypeRegistry.ENTITY_CHUNK, chunkNbt, i2, SharedConstants.b().d().c());
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }
}

