/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentStructureLegacy;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.spigotmc.SpigotConfig;

public class IChunkLoader
implements AutoCloseable {
    public static final int d = 1493;
    private final Object persistentDataLock = new Object();
    public final RegionFileCache regionFileCache;
    protected final DataFixer e;
    @Nullable
    private volatile PersistentStructureLegacy b;

    public IChunkLoader(Path directory, DataFixer dataFixer, boolean dsync) {
        this.e = dataFixer;
        this.regionFileCache = new RegionFileCache(directory, dsync, true);
    }

    public boolean b(ChunkCoordIntPair chunkPos, int checkRadius) {
        return true;
    }

    private boolean check(ChunkProviderServer cps, int x2, int z2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTTagCompound upgradeChunkTag(ResourceKey<WorldDimension> resourcekey, Supplier<WorldPersistentData> supplier, NBTTagCompound nbttagcompound, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> optional, ChunkCoordIntPair pos, @Nullable GeneratorAccess generatoraccess) {
        boolean belowZeroGenerationInExistingChunks;
        int i2 = IChunkLoader.a(nbttagcompound = nbttagcompound.h());
        if (i2 < 1493) {
            MCDataConverter.convertTag(MCTypeRegistry.CHUNK, nbttagcompound, i2, 1493);
            if (nbttagcompound.p("Level").q("hasLegacyStructureData")) {
                Object object = this.persistentDataLock;
                synchronized (object) {
                    PersistentStructureLegacy persistentstructurelegacy = this.a(resourcekey, supplier);
                    nbttagcompound = persistentstructurelegacy.a(nbttagcompound);
                }
            }
        }
        boolean stopBelowZero = false;
        boolean bl = belowZeroGenerationInExistingChunks = generatoraccess != null ? ((WorldServer)generatoraccess).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
        if (i2 <= 2730 && !belowZeroGenerationInExistingChunks) {
            stopBelowZero = "full".equals(nbttagcompound.p("Level").l("Status"));
        }
        IChunkLoader.a(nbttagcompound, resourcekey, optional);
        nbttagcompound = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, nbttagcompound, Math.max(1493, i2), SharedConstants.b().d().c());
        if (i2 < SharedConstants.b().d().c()) {
            GameProfileSerializer.g(nbttagcompound);
        }
        if (stopBelowZero) {
            nbttagcompound.a("Status", BuiltInRegistries.n.b(ChunkStatus.m).toString());
        }
        nbttagcompound.r("__context");
        return nbttagcompound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistentStructureLegacy a(ResourceKey<WorldDimension> worldKey, Supplier<WorldPersistentData> stateManagerGetter) {
        PersistentStructureLegacy persistentstructurelegacy = this.b;
        if (persistentstructurelegacy == null) {
            Object object = this.persistentDataLock;
            synchronized (object) {
                persistentstructurelegacy = this.b;
                if (persistentstructurelegacy == null) {
                    this.b = persistentstructurelegacy = PersistentStructureLegacy.a(worldKey, stateManagerGetter.get());
                }
            }
        }
        return persistentstructurelegacy;
    }

    public static void a(NBTTagCompound nbt, ResourceKey<WorldDimension> worldKey, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> generatorCodecKey) {
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.a("dimension", worldKey.a().toString());
        generatorCodecKey.ifPresent(resourcekey1 -> nbttagcompound1.a("generator", resourcekey1.a().toString()));
        nbt.a("__context", nbttagcompound1);
    }

    public static int a(NBTTagCompound nbt) {
        return GameProfileSerializer.b(nbt, -1);
    }

    public CompletableFuture<Optional<NBTTagCompound>> e(ChunkCoordIntPair chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.readSync(chunkPos)));
        }
        catch (Throwable thr) {
            return CompletableFuture.failedFuture(thr);
        }
    }

    @Nullable
    public NBTTagCompound readSync(ChunkCoordIntPair chunkPos) throws IOException {
        return this.regionFileCache.a(chunkPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(ChunkCoordIntPair chunkPos, NBTTagCompound nbt) throws IOException {
        if (nbt != null && !chunkPos.equals(ChunkRegionLoader.getChunkCoordinate(nbt))) {
            String world = this instanceof PlayerChunkMap ? ((PlayerChunkMap)this).q.getWorld().getName() : null;
            throw new IllegalArgumentException("Chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + chunkPos + " but compound says coordinate is " + ChunkRegionLoader.getChunkCoordinate(nbt) + (String)(world == null ? " for an unknown world" : " for world: " + world));
        }
        this.regionFileCache.a(chunkPos, nbt);
        if (this.b != null) {
            Object object = this.persistentDataLock;
            synchronized (object) {
                this.b.a(chunkPos.a());
            }
        }
    }

    public void o() {
        RegionFileIOThread.flush();
    }

    @Override
    public void close() throws IOException {
        this.regionFileCache.close();
    }

    public ChunkScanAccess p() {
        return (chunkPos, streamTagVisitor) -> {
            try {
                this.regionFileCache.a(chunkPos, streamTagVisitor);
                return CompletableFuture.completedFuture(null);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        };
    }
}

