/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public final class VibrationInfo
extends Record {
    private final GameEvent b;
    private final float c;
    private final Vec3D d;
    @Nullable
    private final UUID e;
    @Nullable
    private final UUID f;
    @Nullable
    private final Entity g;
    public static final Codec<VibrationInfo> a = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.a.q().fieldOf("game_event").forGetter(VibrationInfo::a), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("distance").forGetter(VibrationInfo::b), (App)Vec3D.a.fieldOf("pos").forGetter(VibrationInfo::c), (App)UUIDUtil.a.optionalFieldOf("source").forGetter(vibration -> Optional.ofNullable(vibration.d())), (App)UUIDUtil.a.optionalFieldOf("projectile_owner").forGetter(vibration -> Optional.ofNullable(vibration.e()))).apply((Applicative)instance, (event, distance, pos, uuid, projectileOwnerUuid) -> new VibrationInfo((GameEvent)event, distance.floatValue(), (Vec3D)pos, uuid.orElse(null), projectileOwnerUuid.orElse(null))));

    public VibrationInfo(GameEvent gameEvent, float distance, Vec3D pos, @Nullable UUID uuid, @Nullable UUID projectileOwnerUuid) {
        this(gameEvent, distance, pos, uuid, projectileOwnerUuid, null);
    }

    public VibrationInfo(GameEvent gameEvent, float distance, Vec3D pos, @Nullable Entity entity) {
        this(gameEvent, distance, pos, entity == null ? null : entity.cw(), VibrationInfo.a(entity), entity);
    }

    public VibrationInfo(GameEvent gameEvent, float f2, Vec3D vec3, @Nullable UUID uUID, @Nullable UUID uUID2, @Nullable Entity entity) {
        this.b = gameEvent;
        this.c = f2;
        this.d = vec3;
        this.e = uUID;
        this.f = uUID2;
        this.g = entity;
    }

    @Nullable
    private static UUID a(@Nullable Entity entity) {
        IProjectile projectile;
        if (entity instanceof IProjectile && (projectile = (IProjectile)entity).w() != null) {
            return projectile.w().cw();
        }
        return null;
    }

    public Optional<Entity> a(WorldServer world) {
        return Optional.ofNullable(this.g).or(() -> Optional.ofNullable(this.e).map(world::a));
    }

    public Optional<Entity> b(WorldServer world) {
        return this.a(world).filter(entity -> entity instanceof IProjectile).map(entity -> (IProjectile)entity).map(IProjectile::w).or(() -> Optional.ofNullable(this.f).map(world::a));
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{VibrationInfo.class, "gameEvent;distance;pos;uuid;projectileOwnerUuid;entity", "b", "c", "d", "e", "f", "g"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{VibrationInfo.class, "gameEvent;distance;pos;uuid;projectileOwnerUuid;entity", "b", "c", "d", "e", "f", "g"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{VibrationInfo.class, "gameEvent;distance;pos;uuid;projectileOwnerUuid;entity", "b", "c", "d", "e", "f", "g"}, this, object);
    }

    public GameEvent a() {
        return this.b;
    }

    public float b() {
        return this.c;
    }

    public Vec3D c() {
        return this.d;
    }

    @Nullable
    public UUID d() {
        return this.e;
    }

    @Nullable
    public UUID e() {
        return this.f;
    }

    @Nullable
    public Entity f() {
        return this.g;
    }
}

