/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blockpredicates;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.blockpredicates.AllOfPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.AnyOfPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.blockpredicates.HasSturdyFacePredicate;
import net.minecraft.world.level.levelgen.blockpredicates.InsideWorldBoundsPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingBlockTagPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingBlocksPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.MatchingFluidsPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.NotPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.ReplaceablePredicate;
import net.minecraft.world.level.levelgen.blockpredicates.SolidPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.TrueBlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.WouldSurvivePredicate;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;

public interface BlockPredicate
extends BiPredicate<GeneratorAccessSeed, BlockPosition> {
    public static final Codec<BlockPredicate> b = BuiltInRegistries.O.q().dispatch(BlockPredicate::a, BlockPredicateType::codec);
    public static final BlockPredicate c = BlockPredicate.a(Blocks.a);
    public static final BlockPredicate d = BlockPredicate.a(Blocks.a, Blocks.G);

    public BlockPredicateType<?> a();

    public static BlockPredicate a(List<BlockPredicate> predicates) {
        return new AllOfPredicate(predicates);
    }

    public static BlockPredicate a(BlockPredicate ... predicates) {
        return BlockPredicate.a(List.of(predicates));
    }

    public static BlockPredicate a(BlockPredicate first, BlockPredicate second) {
        return BlockPredicate.a(List.of(first, second));
    }

    public static BlockPredicate b(List<BlockPredicate> predicates) {
        return new AnyOfPredicate(predicates);
    }

    public static BlockPredicate b(BlockPredicate ... predicates) {
        return BlockPredicate.b(List.of(predicates));
    }

    public static BlockPredicate b(BlockPredicate first, BlockPredicate second) {
        return BlockPredicate.b(List.of(first, second));
    }

    public static BlockPredicate a(BaseBlockPosition offset, List<Block> blocks) {
        return new MatchingBlocksPredicate(offset, HolderSet.a(Block::r, blocks));
    }

    public static BlockPredicate c(List<Block> blocks) {
        return BlockPredicate.a(BaseBlockPosition.g, blocks);
    }

    public static BlockPredicate a(BaseBlockPosition offset, Block ... blocks) {
        return BlockPredicate.a(offset, List.of(blocks));
    }

    public static BlockPredicate a(Block ... blocks) {
        return BlockPredicate.a(BaseBlockPosition.g, blocks);
    }

    public static BlockPredicate a(BaseBlockPosition offset, TagKey<Block> tag) {
        return new MatchingBlockTagPredicate(offset, tag);
    }

    public static BlockPredicate a(TagKey<Block> offset) {
        return BlockPredicate.a(BaseBlockPosition.g, offset);
    }

    public static BlockPredicate b(BaseBlockPosition offset, List<FluidType> fluids) {
        return new MatchingFluidsPredicate(offset, HolderSet.a(FluidType::k, fluids));
    }

    public static BlockPredicate a(BaseBlockPosition offset, FluidType ... fluids) {
        return BlockPredicate.b(offset, List.of(fluids));
    }

    public static BlockPredicate a(FluidType ... fluids) {
        return BlockPredicate.a(BaseBlockPosition.g, fluids);
    }

    public static BlockPredicate a(BlockPredicate predicate) {
        return new NotPredicate(predicate);
    }

    public static BlockPredicate a(BaseBlockPosition offset) {
        return new ReplaceablePredicate(offset);
    }

    public static BlockPredicate b() {
        return BlockPredicate.a(BaseBlockPosition.g);
    }

    public static BlockPredicate a(IBlockData state, BaseBlockPosition offset) {
        return new WouldSurvivePredicate(offset, state);
    }

    public static BlockPredicate a(BaseBlockPosition offset, EnumDirection face) {
        return new HasSturdyFacePredicate(offset, face);
    }

    public static BlockPredicate a(EnumDirection face) {
        return BlockPredicate.a(BaseBlockPosition.g, face);
    }

    public static BlockPredicate b(BaseBlockPosition offset) {
        return new SolidPredicate(offset);
    }

    public static BlockPredicate c() {
        return BlockPredicate.b(BaseBlockPosition.g);
    }

    public static BlockPredicate d() {
        return BlockPredicate.c(BaseBlockPosition.g);
    }

    public static BlockPredicate c(BaseBlockPosition offset) {
        return BlockPredicate.a(offset, FluidTypes.a);
    }

    public static BlockPredicate d(BaseBlockPosition offset) {
        return new InsideWorldBoundsPredicate(offset);
    }

    public static BlockPredicate e() {
        return TrueBlockPredicate.a;
    }
}

