/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureHugeFungiConfiguration;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureWeepingVines;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;

public class WorldGenFeatureHugeFungi
extends WorldGenerator<WorldGenFeatureHugeFungiConfiguration> {
    private static final float a = 0.06f;

    public WorldGenFeatureHugeFungi(Codec<WorldGenFeatureHugeFungiConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean a(FeaturePlaceContext<WorldGenFeatureHugeFungiConfiguration> context) {
        GeneratorAccessSeed worldGenLevel = context.b();
        BlockPosition blockPos = context.e();
        RandomSource randomSource = context.d();
        ChunkGenerator chunkGenerator = context.c();
        WorldGenFeatureHugeFungiConfiguration hugeFungusConfiguration = context.f();
        Block block = hugeFungusConfiguration.b.b();
        BlockPosition blockPos2 = null;
        IBlockData blockState = worldGenLevel.a_(blockPos.d());
        if (blockState.a(block)) {
            blockPos2 = blockPos;
        }
        if (blockPos2 == null) {
            return false;
        }
        int i2 = MathHelper.a(randomSource, 4, 13);
        if (randomSource.a(12) == 0) {
            i2 *= 2;
        }
        if (!hugeFungusConfiguration.g) {
            int j2 = chunkGenerator.d();
            if (blockPos2.v() + i2 + 1 >= j2) {
                return false;
            }
        }
        boolean bl = !hugeFungusConfiguration.g && randomSource.i() < 0.06f;
        worldGenLevel.a(blockPos, Blocks.a.o(), 4);
        this.a(worldGenLevel, randomSource, hugeFungusConfiguration, blockPos2, i2, bl);
        this.b(worldGenLevel, randomSource, hugeFungusConfiguration, blockPos2, i2, bl);
        return true;
    }

    private static boolean a(GeneratorAccessSeed world, BlockPosition pos, WorldGenFeatureHugeFungiConfiguration config, boolean checkConfig) {
        if (world.a(pos, BlockBase.BlockData::r)) {
            return true;
        }
        if (checkConfig) {
            return config.f.test(world, pos);
        }
        return false;
    }

    private void a(GeneratorAccessSeed world, RandomSource random, WorldGenFeatureHugeFungiConfiguration config, BlockPosition pos, int stemHeight, boolean thickStem) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        IBlockData blockState = config.c;
        int i2 = thickStem ? 1 : 0;
        for (int j2 = -i2; j2 <= i2; ++j2) {
            for (int k2 = -i2; k2 <= i2; ++k2) {
                boolean bl = thickStem && MathHelper.a(j2) == i2 && MathHelper.a(k2) == i2;
                for (int l2 = 0; l2 < stemHeight; ++l2) {
                    mutableBlockPos.a(pos, j2, l2, k2);
                    if (!WorldGenFeatureHugeFungi.a(world, mutableBlockPos, config, true)) continue;
                    if (config.g) {
                        if (!world.a_(mutableBlockPos.d()).i()) {
                            world.b((BlockPosition)mutableBlockPos, true);
                        }
                        world.a((BlockPosition)mutableBlockPos, blockState, 3);
                        continue;
                    }
                    if (bl) {
                        if (!(random.i() < 0.1f)) continue;
                        this.a(world, mutableBlockPos, blockState);
                        continue;
                    }
                    this.a(world, mutableBlockPos, blockState);
                }
            }
        }
    }

    private void b(GeneratorAccessSeed world, RandomSource random, WorldGenFeatureHugeFungiConfiguration config, BlockPosition pos, int hatHeight, boolean thickStem) {
        int j2;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        boolean bl = config.d.a(Blocks.kK);
        int i2 = Math.min(random.a(1 + hatHeight / 3) + 5, hatHeight);
        for (int k2 = j2 = hatHeight - i2; k2 <= hatHeight; ++k2) {
            int l2;
            int n2 = l2 = k2 < hatHeight - random.a(3) ? 2 : 1;
            if (i2 > 8 && k2 < j2 + 4) {
                l2 = 3;
            }
            if (thickStem) {
                ++l2;
            }
            for (int m2 = -l2; m2 <= l2; ++m2) {
                for (int n3 = -l2; n3 <= l2; ++n3) {
                    boolean bl2 = m2 == -l2 || m2 == l2;
                    boolean bl3 = n3 == -l2 || n3 == l2;
                    boolean bl4 = !bl2 && !bl3 && k2 != hatHeight;
                    boolean bl5 = bl2 && bl3;
                    boolean bl6 = k2 < j2 + 3;
                    mutableBlockPos.a(pos, m2, k2, n3);
                    if (!WorldGenFeatureHugeFungi.a(world, mutableBlockPos, config, false)) continue;
                    if (config.g && !world.a_(mutableBlockPos.d()).i()) {
                        world.b((BlockPosition)mutableBlockPos, true);
                    }
                    if (bl6) {
                        if (bl4) continue;
                        this.a(world, random, mutableBlockPos, config.d, bl);
                        continue;
                    }
                    if (bl4) {
                        this.a(world, random, config, mutableBlockPos, 0.1f, 0.2f, bl ? 0.1f : 0.0f);
                        continue;
                    }
                    if (bl5) {
                        this.a(world, random, config, mutableBlockPos, 0.01f, 0.7f, bl ? 0.083f : 0.0f);
                        continue;
                    }
                    this.a(world, random, config, mutableBlockPos, 5.0E-4f, 0.98f, bl ? 0.07f : 0.0f);
                }
            }
        }
    }

    private void a(GeneratorAccess world, RandomSource random, WorldGenFeatureHugeFungiConfiguration config, BlockPosition.MutableBlockPosition pos, float decorationChance, float generationChance, float vineChance) {
        if (random.i() < decorationChance) {
            this.a(world, pos, config.e);
        } else if (random.i() < generationChance) {
            this.a(world, pos, config.d);
            if (random.i() < vineChance) {
                WorldGenFeatureHugeFungi.a(pos, world, random);
            }
        }
    }

    private void a(GeneratorAccess world, RandomSource random, BlockPosition pos, IBlockData state, boolean vines) {
        if (world.a_(pos.d()).a(state.b())) {
            this.a(world, pos, state);
        } else if ((double)random.i() < 0.15) {
            this.a(world, pos, state);
            if (vines && random.a(11) == 0) {
                WorldGenFeatureHugeFungi.a(pos, world, random);
            }
        }
    }

    private static void a(BlockPosition pos, GeneratorAccess world, RandomSource random) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.j().c(EnumDirection.a);
        if (!world.u(mutableBlockPos)) {
            return;
        }
        int i2 = MathHelper.a(random, 1, 5);
        if (random.a(7) == 0) {
            i2 *= 2;
        }
        int j2 = 23;
        int k2 = 25;
        WorldGenFeatureWeepingVines.a(world, random, mutableBlockPos, i2, 23, 25);
    }
}

