/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.rootplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.rootplacers.AboveRootPlacement;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;

public abstract class RootPlacer {
    public static final Codec<RootPlacer> d = BuiltInRegistries.Y.q().dispatch(RootPlacer::a, RootPlacerType::a);
    protected final IntProvider e;
    protected final WorldGenFeatureStateProvider f;
    protected final Optional<AboveRootPlacement> g;

    protected static <P extends RootPlacer> Products.P3<RecordCodecBuilder.Mu<P>, IntProvider, WorldGenFeatureStateProvider, Optional<AboveRootPlacement>> a(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)IntProvider.c.fieldOf("trunk_offset_y").forGetter(rootPlacer -> rootPlacer.e), (App)WorldGenFeatureStateProvider.a.fieldOf("root_provider").forGetter(rootPlacer -> rootPlacer.f), (App)AboveRootPlacement.a.optionalFieldOf("above_root_placement").forGetter(rootPlacer -> rootPlacer.g));
    }

    public RootPlacer(IntProvider trunkOffsetY, WorldGenFeatureStateProvider rootProvider, Optional<AboveRootPlacement> aboveRootPlacement) {
        this.e = trunkOffsetY;
        this.f = rootProvider;
        this.g = aboveRootPlacement;
    }

    protected abstract RootPlacerType<?> a();

    public abstract boolean a(VirtualLevelReadable var1, BiConsumer<BlockPosition, IBlockData> var2, RandomSource var3, BlockPosition var4, BlockPosition var5, WorldGenFeatureTreeConfiguration var6);

    protected boolean a(VirtualLevelReadable world, BlockPosition pos) {
        return WorldGenTrees.c(world, pos);
    }

    protected void a(VirtualLevelReadable world, BiConsumer<BlockPosition, IBlockData> replacer, RandomSource random, BlockPosition pos, WorldGenFeatureTreeConfiguration config) {
        if (!this.a(world, pos)) {
            return;
        }
        replacer.accept(pos, this.a(world, pos, this.f.a(random, pos)));
        if (this.g.isPresent()) {
            AboveRootPlacement aboveRootPlacement = this.g.get();
            BlockPosition blockPos = pos.c();
            if (random.i() < aboveRootPlacement.b() && world.a(blockPos, BlockBase.BlockData::i)) {
                replacer.accept(blockPos, this.a(world, blockPos, aboveRootPlacement.a().a(random, blockPos)));
            }
        }
    }

    protected IBlockData a(VirtualLevelReadable world, BlockPosition pos, IBlockData state) {
        if (state.b(BlockProperties.C)) {
            boolean bl = world.b(pos, fluidState -> fluidState.a(TagsFluid.a));
            return (IBlockData)state.a(BlockProperties.C, bl);
        }
        return state;
    }

    public BlockPosition a(BlockPosition pos, RandomSource random) {
        return pos.b(this.e.a(random));
    }
}

