/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;

public class UpwardsBranchingTrunkPlacer
extends TrunkPlacer {
    public static final Codec<UpwardsBranchingTrunkPlacer> a = RecordCodecBuilder.create(instance -> UpwardsBranchingTrunkPlacer.a(instance).and(instance.group((App)IntProvider.e.fieldOf("extra_branch_steps").forGetter(trunkPlacer -> trunkPlacer.b), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.h)), (App)IntProvider.d.fieldOf("extra_branch_length").forGetter(trunkPlacer -> trunkPlacer.i), (App)RegistryCodecs.a(Registries.f).fieldOf("can_grow_through").forGetter(trunkPlacer -> trunkPlacer.j))).apply((Applicative)instance, UpwardsBranchingTrunkPlacer::new));
    private final IntProvider b;
    private final float h;
    private final IntProvider i;
    private final HolderSet<Block> j;

    public UpwardsBranchingTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.b = extraBranchSteps;
        this.h = placeBranchPerLogProbability;
        this.i = extraBranchLength;
        this.j = canGrowThrough;
    }

    @Override
    @Override
    protected TrunkPlacers<?> a() {
        return TrunkPlacers.h;
    }

    @Override
    @Override
    public List<WorldGenFoilagePlacer.a> a(VirtualLevelReadable world, BiConsumer<BlockPosition, IBlockData> replacer, RandomSource random, int height, BlockPosition startPos, WorldGenFeatureTreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 < height; ++i2) {
            int j2 = startPos.v() + i2;
            if (this.b(world, replacer, random, mutableBlockPos.d(startPos.u(), j2, startPos.w()), config) && i2 < height - 1 && random.i() < this.h) {
                EnumDirection direction = EnumDirection.EnumDirectionLimit.a.a(random);
                int k2 = this.i.a(random);
                int l2 = Math.max(0, k2 - this.i.a(random) - 1);
                int m2 = this.b.a(random);
                this.a(world, replacer, random, height, config, list, mutableBlockPos, j2, direction, l2, m2);
            }
            if (i2 != height - 1) continue;
            list.add(new WorldGenFoilagePlacer.a(mutableBlockPos.d(startPos.u(), j2 + 1, startPos.w()), 0, false));
        }
        return list;
    }

    private void a(VirtualLevelReadable world, BiConsumer<BlockPosition, IBlockData> replacer, RandomSource random, int height, WorldGenFeatureTreeConfiguration config, List<WorldGenFoilagePlacer.a> nodes, BlockPosition.MutableBlockPosition pos, int yOffset, EnumDirection direction, int length, int steps) {
        int i2 = yOffset + length;
        int j2 = pos.u();
        int k2 = pos.w();
        for (int l2 = length; l2 < height && steps > 0; ++l2, --steps) {
            if (l2 < 1) continue;
            int m2 = yOffset + l2;
            i2 = m2;
            if (this.b(world, replacer, random, pos.d(j2 += direction.j(), m2, k2 += direction.l()), config)) {
                ++i2;
            }
            nodes.add(new WorldGenFoilagePlacer.a(pos.i(), 0, false));
        }
        if (i2 - yOffset > 1) {
            BlockPosition blockPos = new BlockPosition(j2, i2, k2);
            nodes.add(new WorldGenFoilagePlacer.a(blockPos, 0, false));
            nodes.add(new WorldGenFoilagePlacer.a(blockPos.c(2), 0, false));
        }
    }

    @Override
    @Override
    protected boolean a(VirtualLevelReadable world, BlockPosition pos) {
        return super.a(world, pos) || world.a(pos, (IBlockData state) -> state.a(this.j));
    }
}

