/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class EnvironmentScanPlacement
extends PlacementModifier {
    private final EnumDirection c;
    private final BlockPredicate d;
    private final BlockPredicate e;
    private final int f;
    public static final Codec<EnvironmentScanPlacement> a = RecordCodecBuilder.create(instance -> instance.group((App)EnumDirection.h.fieldOf("direction_of_search").forGetter(environmentScanPlacement -> environmentScanPlacement.c), (App)BlockPredicate.b.fieldOf("target_condition").forGetter(environmentScanPlacement -> environmentScanPlacement.d), (App)BlockPredicate.b.optionalFieldOf("allowed_search_condition", (Object)BlockPredicate.e()).forGetter(environmentScanPlacement -> environmentScanPlacement.e), (App)Codec.intRange((int)1, (int)32).fieldOf("max_steps").forGetter(environmentScanPlacement -> environmentScanPlacement.f)).apply((Applicative)instance, EnvironmentScanPlacement::new));

    private EnvironmentScanPlacement(EnumDirection direction, BlockPredicate targetPredicate, BlockPredicate allowedSearchPredicate, int maxSteps) {
        this.c = direction;
        this.d = targetPredicate;
        this.e = allowedSearchPredicate;
        this.f = maxSteps;
    }

    public static EnvironmentScanPlacement a(EnumDirection direction, BlockPredicate targetPredicate, BlockPredicate allowedSearchPredicate, int maxSteps) {
        return new EnvironmentScanPlacement(direction, targetPredicate, allowedSearchPredicate, maxSteps);
    }

    public static EnvironmentScanPlacement a(EnumDirection direction, BlockPredicate targetPredicate, int maxSteps) {
        return EnvironmentScanPlacement.a(direction, targetPredicate, BlockPredicate.e(), maxSteps);
    }

    @Override
    @Override
    public Stream<BlockPosition> a_(PlacementContext context, RandomSource random, BlockPosition pos) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.j();
        GeneratorAccessSeed worldGenLevel = context.d();
        if (!this.e.test(worldGenLevel, mutableBlockPos)) {
            return Stream.of(new BlockPosition[0]);
        }
        for (int i2 = 0; i2 < this.f; ++i2) {
            if (this.d.test(worldGenLevel, mutableBlockPos)) {
                return Stream.of(mutableBlockPos);
            }
            mutableBlockPos.c(this.c);
            if (worldGenLevel.d(mutableBlockPos.v())) {
                return Stream.of(new BlockPosition[0]);
            }
            if (!this.e.test(worldGenLevel, mutableBlockPos)) break;
        }
        if (this.d.test(worldGenLevel, mutableBlockPos)) {
            return Stream.of(mutableBlockPos);
        }
        return Stream.of(new BlockPosition[0]);
    }

    @Override
    @Override
    public PlacementModifierType<?> b() {
        return PlacementModifierType.j;
    }
}

