/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import org.bukkit.craftbukkit.v1_20_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_20_R3.persistence.DirtyCraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_20_R3.util.TransformerGeneratorAccess;
import org.bukkit.event.world.AsyncStructureGenerateEvent;
import org.slf4j.Logger;

public final class StructureStart {
    public static final String a = "INVALID";
    public static final StructureStart b = new StructureStart(null, new ChunkCoordIntPair(0, 0), 0, new PiecesContainer(List.of()));
    private static final Logger c = LogUtils.getLogger();
    private final Structure d;
    private final PiecesContainer e;
    private final ChunkCoordIntPair f;
    private int g;
    @Nullable
    private volatile StructureBoundingBox h;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public DirtyCraftPersistentDataContainer persistentDataContainer = new DirtyCraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    public AsyncStructureGenerateEvent.Cause generationEventCause = AsyncStructureGenerateEvent.Cause.WORLD_GENERATION;

    public StructureStart(Structure structure, ChunkCoordIntPair pos, int references, PiecesContainer children) {
        this.d = structure;
        this.f = pos;
        this.g = references;
        this.e = children;
    }

    @Nullable
    public static StructureStart a(StructurePieceSerializationContext context, NBTTagCompound nbt, long seed) {
        String s2 = nbt.l("id");
        if (a.equals(s2)) {
            return b;
        }
        IRegistry<Structure> iregistry = context.b().d(Registries.aD);
        Structure structure = iregistry.a(new MinecraftKey(s2));
        if (structure == null) {
            c.error("Unknown stucture id: {}", (Object)s2);
            return null;
        }
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(nbt.h("ChunkX"), nbt.h("ChunkZ"));
        int j2 = nbt.h("references");
        NBTTagList nbttaglist = nbt.c("Children", 10);
        try {
            PiecesContainer piecescontainer = PiecesContainer.a(nbttaglist, context);
            if (structure instanceof OceanMonumentStructure) {
                piecescontainer = OceanMonumentStructure.a(chunkcoordintpair, seed, piecescontainer);
            }
            return new StructureStart(structure, chunkcoordintpair, j2, piecescontainer);
        }
        catch (Exception exception) {
            c.error("Failed Start with id {}", (Object)s2, (Object)exception);
            return null;
        }
    }

    public StructureBoundingBox a() {
        StructureBoundingBox structureboundingbox = this.h;
        if (structureboundingbox == null) {
            this.h = structureboundingbox = this.d.a(this.e.b());
        }
        return structureboundingbox;
    }

    public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos) {
        List<StructurePiece> list = this.e.c();
        if (!list.isEmpty()) {
            StructureBoundingBox structureboundingbox1 = list.get((int)0).f;
            BlockPosition blockposition = structureboundingbox1.g();
            BlockPosition blockposition1 = new BlockPosition(blockposition.u(), structureboundingbox1.i(), blockposition.w());
            List<StructurePiece> pieces = list.stream().filter(piece -> piece.f().a(chunkBox)).toList();
            if (!pieces.isEmpty()) {
                TransformerGeneratorAccess transformerAccess = new TransformerGeneratorAccess();
                transformerAccess.setHandle(world);
                transformerAccess.setStructureTransformer(new CraftStructureTransformer(this.generationEventCause, world, structureAccessor, this.d, chunkBox, chunkPos));
                for (StructurePiece piece2 : pieces) {
                    piece2.a((GeneratorAccessSeed)transformerAccess, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, blockposition1);
                }
                transformerAccess.getStructureTransformer().discard();
            }
            this.d.a(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, this.e);
        }
    }

    public NBTTagCompound a(StructurePieceSerializationContext context, ChunkCoordIntPair chunkPos) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!this.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("StructureBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        if (this.b()) {
            nbttagcompound.a("id", context.b().d(Registries.aD).b(this.d).toString());
            nbttagcompound.a("ChunkX", chunkPos.e);
            nbttagcompound.a("ChunkZ", chunkPos.f);
            nbttagcompound.a("references", this.g);
            nbttagcompound.a("Children", this.e.a(context));
            return nbttagcompound;
        }
        nbttagcompound.a("id", a);
        return nbttagcompound;
    }

    public boolean b() {
        return !this.e.a();
    }

    public ChunkCoordIntPair c() {
        return this.f;
    }

    public boolean d() {
        return this.g < this.g();
    }

    public void e() {
        ++this.g;
    }

    public int f() {
        return this.g;
    }

    protected int g() {
        return 1;
    }

    public Structure h() {
        return this.d;
    }

    public List<StructurePiece> i() {
        return this.e.c();
    }
}

