/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pieces;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

@FunctionalInterface
public interface PieceGeneratorSupplier<C extends WorldGenFeatureConfiguration> {
    public Optional<PieceGenerator<C>> createGenerator(a<C> var1);

    public static <C extends WorldGenFeatureConfiguration> PieceGeneratorSupplier<C> simple(Predicate<a<C>> predicate, PieceGenerator<C> generator) {
        Optional optional = Optional.of(generator);
        return context -> predicate.test(context) ? optional : Optional.empty();
    }

    public static <C extends WorldGenFeatureConfiguration> Predicate<a<C>> checkForBiomeOnTop(HeightMap.Type heightmapType) {
        return context -> context.a(heightmapType);
    }

    public record a<C extends WorldGenFeatureConfiguration>(ChunkGenerator a, WorldChunkManager b, RandomState c, long d, ChunkCoordIntPair e, C f, LevelHeightAccessor g, Predicate<Holder<BiomeBase>> h, StructureTemplateManager i, IRegistryCustom j) {
        public boolean a(HeightMap.Type heightmapType) {
            int i2 = this.e.b();
            int j2 = this.e.c();
            int k2 = this.a.c(i2, j2, heightmapType, this.g, this.c);
            Holder<BiomeBase> holder = this.a.c().getNoiseBiome(QuartPos.a(i2), QuartPos.a(k2), QuartPos.a(j2), this.c.b());
            return this.h.test(holder);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "chunkGenerator;biomeSource;randomState;seed;chunkPos;config;heightAccessor;validBiome;structureTemplateManager;registryAccess", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "chunkGenerator;biomeSource;randomState;seed;chunkPos;config;heightAccessor;validBiome;structureTemplateManager;registryAccess", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "chunkGenerator;biomeSource;randomState;seed;chunkPos;config;heightAccessor;validBiome;structureTemplateManager;registryAccess", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}, this, object);
        }
    }
}

