/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;

public final class JigsawStructure
extends Structure {
    public static final int d = 128;
    public static final int e = 20;
    public static final Codec<JigsawStructure> f = ExtraCodecs.a(RecordCodecBuilder.mapCodec(instance -> instance.group(JigsawStructure.a(instance), (App)WorldGenFeatureDefinedStructurePoolTemplate.b.fieldOf("start_pool").forGetter(structure -> structure.g), (App)MinecraftKey.a.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.h), (App)Codec.intRange((int)0, (int)20).fieldOf("size").forGetter(structure -> structure.i), (App)HeightProvider.c.fieldOf("start_height").forGetter(structure -> structure.j), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(structure -> structure.k), (App)HeightMap.Type.g.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.l), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.m), (App)Codec.list(PoolAliasBinding.b).optionalFieldOf("pool_aliases", List.of()).forGetter(structure -> structure.n)).apply((Applicative)instance, JigsawStructure::new)), JigsawStructure::a).codec();
    private final Holder<WorldGenFeatureDefinedStructurePoolTemplate> g;
    private final Optional<MinecraftKey> h;
    private final int i;
    private final HeightProvider j;
    private final boolean k;
    private final Optional<HeightMap.Type> l;
    private final int m;
    private final List<PoolAliasBinding> n;

    private static DataResult<JigsawStructure> a(JigsawStructure structure) {
        int i2;
        switch (structure.d()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case a: {
                int n2 = 0;
                break;
            }
            case b: 
            case c: 
            case d: {
                int n2 = i2 = 12;
            }
        }
        if (structure.m + i2 > 128) {
            return DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128");
        }
        return DataResult.success((Object)structure);
    }

    public JigsawStructure(Structure.c config, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, Optional<MinecraftKey> startJigsawName, int size, HeightProvider startHeight, boolean useExpansionHack, Optional<HeightMap.Type> projectStartToHeightmap, int maxDistanceFromCenter, List<PoolAliasBinding> poolAliasBindings) {
        super(config);
        this.g = startPool;
        this.h = startJigsawName;
        this.i = size;
        this.j = startHeight;
        this.k = useExpansionHack;
        this.l = projectStartToHeightmap;
        this.m = maxDistanceFromCenter;
        this.n = poolAliasBindings;
    }

    public JigsawStructure(Structure.c config, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, int size, HeightProvider startHeight, boolean useExpansionHack, HeightMap.Type projectStartToHeightmap) {
        this(config, startPool, Optional.empty(), size, startHeight, useExpansionHack, Optional.of(projectStartToHeightmap), 80, List.of());
    }

    public JigsawStructure(Structure.c config, Holder<WorldGenFeatureDefinedStructurePoolTemplate> startPool, int size, HeightProvider startHeight, boolean useExpansionHack) {
        this(config, startPool, Optional.empty(), size, startHeight, useExpansionHack, Optional.empty(), 80, List.of());
    }

    @Override
    @Override
    public Optional<Structure.b> a(Structure.a context) {
        ChunkCoordIntPair chunkPos = context.h();
        int i2 = this.j.a(context.f(), new WorldGenerationContext(context.b(), context.i()));
        BlockPosition blockPos = new BlockPosition(chunkPos.d(), i2, chunkPos.e());
        return WorldGenFeatureDefinedStructureJigsawPlacement.a(context, this.g, this.h, this.i, blockPos, this.k, this.l, this.m, PoolAliasLookup.create(this.n, blockPos, context.g()));
    }

    @Override
    @Override
    public StructureType<?> e() {
        return StructureType.f;
    }

    public List<PoolAliasBinding> f() {
        return this.n;
    }
}

