/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.FileUtils;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderGetter;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SavedFile;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class StructureTemplateManager {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "structures";
    private static final String c = ".nbt";
    private static final String d = ".snbt";
    public final Map<MinecraftKey, Optional<DefinedStructure>> e = Maps.newConcurrentMap();
    private final DataFixer f;
    private IResourceManager g;
    private final Path h;
    private final List<b> i;
    private final HolderGetter<Block> j;
    private static final FileToIdConverter k = new FileToIdConverter("structures", ".nbt");

    public StructureTemplateManager(IResourceManager resourceManager, Convertable.ConversionSession session, DataFixer dataFixer, HolderGetter<Block> blockLookup) {
        this.g = resourceManager;
        this.f = dataFixer;
        this.h = session.a(SavedFile.i).normalize();
        this.j = blockLookup;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new b(this::h, this::d));
        if (SharedConstants.aW) {
            builder.add((Object)new b(this::g, this::c));
        }
        builder.add((Object)new b(this::f, this::b));
        this.i = builder.build();
    }

    public DefinedStructure a(MinecraftKey id) {
        Optional<DefinedStructure> optional = this.b(id);
        if (optional.isPresent()) {
            return optional.get();
        }
        DefinedStructure structureTemplate = new DefinedStructure();
        this.e.put(id, Optional.of(structureTemplate));
        return structureTemplate;
    }

    public Optional<DefinedStructure> b(MinecraftKey id) {
        return this.e.computeIfAbsent(id, this::e);
    }

    public Stream<MinecraftKey> a() {
        return this.i.stream().flatMap(provider -> provider.b().get()).distinct();
    }

    private Optional<DefinedStructure> e(MinecraftKey id) {
        for (b source : this.i) {
            try {
                Optional<DefinedStructure> optional = source.a().apply(id);
                if (!optional.isPresent()) continue;
                return optional;
            }
            catch (Exception exception) {
            }
        }
        return Optional.empty();
    }

    public void a(IResourceManager resourceManager) {
        this.g = resourceManager;
        this.e.clear();
    }

    public Optional<DefinedStructure> f(MinecraftKey id) {
        MinecraftKey resourceLocation = k.a(id);
        return this.a(() -> this.g.open(resourceLocation), (Throwable throwable) -> a.error("Couldn't load structure {}", (Object)id, throwable));
    }

    private Stream<MinecraftKey> b() {
        return k.a(this.g).keySet().stream().map(k::b);
    }

    private Optional<DefinedStructure> g(MinecraftKey id) {
        return this.a(id, Paths.get(GameTestHarnessStructures.b, new String[0]));
    }

    private Stream<MinecraftKey> c() {
        return this.a(Paths.get(GameTestHarnessStructures.b, new String[0]), "minecraft", d);
    }

    public Optional<DefinedStructure> h(MinecraftKey id) {
        if (!Files.isDirectory(this.h, new LinkOption[0])) {
            return Optional.empty();
        }
        Path path = StructureTemplateManager.b(this.h, id, c);
        return this.a(() -> new FileInputStream(path.toFile()), (Throwable throwable) -> a.error("Couldn't load structure from {}", (Object)path, throwable));
    }

    private Stream<MinecraftKey> d() {
        if (!Files.isDirectory(this.h, new LinkOption[0])) {
            return Stream.empty();
        }
        try {
            return Files.list(this.h).filter(path -> Files.isDirectory(path, new LinkOption[0])).flatMap(path -> this.a((Path)path));
        }
        catch (IOException var2) {
            return Stream.empty();
        }
    }

    private Stream<MinecraftKey> a(Path namespaceDirectory) {
        Path path = namespaceDirectory.resolve(b);
        return this.a(path, namespaceDirectory.getFileName().toString(), c);
    }

    private Stream<MinecraftKey> a(Path structuresDirectoryPath, String namespace, String extension) {
        if (!Files.isDirectory(structuresDirectoryPath, new LinkOption[0])) {
            return Stream.empty();
        }
        int i2 = extension.length();
        Function<String, String> function = filename -> filename.substring(0, filename.length() - i2);
        try {
            return Files.walk(structuresDirectoryPath, new FileVisitOption[0]).filter(path -> path.toString().endsWith(extension)).mapMulti((path, consumer) -> {
                try {
                    consumer.accept(new MinecraftKey(namespace, (String)function.apply(this.a(structuresDirectoryPath, (Path)path))));
                }
                catch (ResourceKeyInvalidException var7x) {
                    a.error("Invalid location while listing pack contents", (Throwable)var7x);
                }
            });
        }
        catch (IOException var7) {
            a.error("Failed to list folder contents", (Throwable)var7);
            return Stream.empty();
        }
    }

    private String a(Path root, Path path) {
        return root.relativize(path).toString().replace(File.separator, "/");
    }

    private Optional<DefinedStructure> a(MinecraftKey id, Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return Optional.empty();
        }
        Path path2 = FileUtils.b(path, id.a(), d);
        try {
            Optional<DefinedStructure> var6;
            try (BufferedReader bufferedReader = Files.newBufferedReader(path2);){
                String string = IOUtils.toString((Reader)bufferedReader);
                var6 = Optional.of(this.a(GameProfileSerializer.a(string)));
            }
            return var6;
        }
        catch (NoSuchFileException var9) {
            return Optional.empty();
        }
        catch (CommandSyntaxException | IOException var10) {
            a.error("Couldn't load structure from {}", (Object)path2, (Object)var10);
            return Optional.empty();
        }
    }

    private Optional<DefinedStructure> a(a opener, Consumer<Throwable> exceptionConsumer) {
        try {
            Optional<DefinedStructure> var4;
            try (InputStream inputStream = opener.open();){
                var4 = Optional.of(this.a(inputStream));
            }
            return var4;
        }
        catch (FileNotFoundException var8) {
            return Optional.empty();
        }
        catch (Throwable var9) {
            exceptionConsumer.accept(var9);
            return Optional.empty();
        }
    }

    public DefinedStructure a(InputStream templateIInputStream) throws IOException {
        NBTTagCompound compoundTag = NBTCompressedStreamTools.a(templateIInputStream, NBTReadLimiter.a());
        return this.a(compoundTag);
    }

    public DefinedStructure a(NBTTagCompound nbt) {
        DefinedStructure structureTemplate = new DefinedStructure();
        int i2 = GameProfileSerializer.b(nbt, 500);
        structureTemplate.a(this.j, MCDataConverter.convertTag(MCTypeRegistry.STRUCTURE, nbt, i2, SharedConstants.b().d().c()));
        return structureTemplate;
    }

    public boolean c(MinecraftKey id) {
        Optional<DefinedStructure> optional = this.e.get(id);
        if (optional.isEmpty()) {
            return false;
        }
        DefinedStructure structureTemplate = optional.get();
        Path path = StructureTemplateManager.b(this.h, id, c);
        Path path2 = path.getParent();
        if (path2 == null) {
            return false;
        }
        try {
            Files.createDirectories(Files.exists(path2, new LinkOption[0]) ? path2.toRealPath(new LinkOption[0]) : path2, new FileAttribute[0]);
        }
        catch (IOException var13) {
            a.error("Failed to create parent directory: {}", (Object)path2);
            return false;
        }
        NBTTagCompound compoundTag = structureTemplate.a(new NBTTagCompound());
        try {
            try (FileOutputStream outputStream = new FileOutputStream(path.toFile());){
                NBTCompressedStreamTools.a(compoundTag, outputStream);
            }
            return true;
        }
        catch (Throwable var12) {
            return false;
        }
    }

    public Path a(MinecraftKey id, String extension) {
        return StructureTemplateManager.a(this.h, id, extension);
    }

    public static Path a(Path path, MinecraftKey id, String extension) {
        try {
            Path path2 = path.resolve(id.b());
            Path path3 = path2.resolve(b);
            return FileUtils.b(path3, id.a(), extension);
        }
        catch (InvalidPathException var5) {
            throw new ResourceKeyInvalidException("Invalid resource path: " + id, var5);
        }
    }

    public static Path b(Path path, MinecraftKey id, String extension) {
        if (id.a().contains("//")) {
            throw new ResourceKeyInvalidException("Invalid resource path: " + id);
        }
        Path path2 = StructureTemplateManager.a(path, id, extension);
        if (path2.startsWith(path) && FileUtils.a(path2) && FileUtils.b(path2)) {
            return path2;
        }
        throw new ResourceKeyInvalidException("Invalid resource path: " + path2);
    }

    public void d(MinecraftKey id) {
        this.e.remove(id);
    }

    record b(Function<MinecraftKey, Optional<DefinedStructure>> a, Supplier<Stream<MinecraftKey>> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "loader;lister", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "loader;lister", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "loader;lister", "a", "b"}, this, o2);
        }
    }

    @FunctionalInterface
    static interface a {
        public InputStream open() throws IOException;
    }
}

