/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.slf4j.Logger;

public class WorldDataServer
implements IWorldDataServer,
SaveData {
    private static final Logger f = LogUtils.getLogger();
    public static final String a = "LevelName";
    protected static final String b = "Player";
    protected static final String c = "WorldGenSettings";
    public WorldSettings g;
    private final WorldOptions h;
    private final a i;
    private final Lifecycle j;
    private int k;
    private int l;
    private int m;
    private float n;
    private long o;
    private long p;
    @Nullable
    private final NBTTagCompound q;
    private final int r;
    private int s;
    private boolean t;
    private int u;
    private boolean v;
    private int w;
    private boolean x;
    private boolean y;
    private WorldBorder.c z;
    private EnderDragonBattle.a A;
    @Nullable
    private NBTTagCompound B;
    private int C;
    private int D;
    @Nullable
    private UUID E;
    private final Set<String> F;
    private boolean G;
    private final Set<String> H;
    private final CustomFunctionCallbackTimerQueue<MinecraftServer> I;
    public IRegistry<WorldDimension> customDimensions;
    private WorldServer world;
    protected NBTBase pdc;

    public void setWorld(WorldServer world) {
        if (this.world != null) {
            return;
        }
        this.world = world;
        world.getWorld().readBukkitValues(this.pdc);
        this.pdc = null;
    }

    private WorldDataServer(@Nullable NBTTagCompound playerData, boolean modded, int spawnX, int spawnY, int spawnZ, float spawnAngle, long time, long timeOfDay, int version, int clearWeatherTime, int rainTime, boolean raining, int thunderTime, boolean thundering, boolean initialized, boolean difficultyLocked, WorldBorder.c worldBorder, int wanderingTraderSpawnDelay, int wanderingTraderSpawnChance, @Nullable UUID wanderingTraderId, Set<String> serverBrands, Set<String> removedFeatures, CustomFunctionCallbackTimerQueue<MinecraftServer> scheduledEvents, @Nullable NBTTagCompound customBossEvents, EnderDragonBattle.a dragonFight, WorldSettings levelInfo, WorldOptions generatorOptions, a specialProperty, Lifecycle lifecycle) {
        this.G = modded;
        this.k = spawnX;
        this.l = spawnY;
        this.m = spawnZ;
        this.n = spawnAngle;
        this.o = time;
        this.p = timeOfDay;
        this.r = version;
        this.s = clearWeatherTime;
        this.u = rainTime;
        this.t = raining;
        this.w = thunderTime;
        this.v = thundering;
        this.x = initialized;
        this.y = difficultyLocked;
        this.z = worldBorder;
        this.C = wanderingTraderSpawnDelay;
        this.D = wanderingTraderSpawnChance;
        this.E = wanderingTraderId;
        this.F = serverBrands;
        this.H = removedFeatures;
        this.q = playerData;
        this.I = scheduledEvents;
        this.B = customBossEvents;
        this.A = dragonFight;
        this.g = levelInfo;
        this.h = generatorOptions;
        this.i = specialProperty;
        this.j = lifecycle;
    }

    public WorldDataServer(WorldSettings levelInfo, WorldOptions generatorOptions, a specialProperty, Lifecycle lifecycle) {
        this(null, false, 0, 0, 0, 0.0f, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, WorldBorder.e, 0, 0, null, Sets.newLinkedHashSet(), new HashSet<String>(), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a), null, EnderDragonBattle.a.b, levelInfo.h(), generatorOptions, specialProperty, lifecycle);
    }

    public static <T> WorldDataServer a(Dynamic<T> dynamic, WorldSettings info, a specialProperty, WorldOptions generatorOptions, Lifecycle lifecycle) {
        long i2 = dynamic.get("Time").asLong(0L);
        NBTTagCompound nbttagcompound = NBTTagCompound.a.parse(dynamic.get(b).orElseEmptyMap()).result().orElse(null);
        boolean flag = dynamic.get("WasModded").asBoolean(false);
        int j2 = dynamic.get("SpawnX").asInt(0);
        int k2 = dynamic.get("SpawnY").asInt(0);
        int l2 = dynamic.get("SpawnZ").asInt(0);
        float f2 = dynamic.get("SpawnAngle").asFloat(0.0f);
        long i1 = dynamic.get("DayTime").asLong(i2);
        int j1 = LevelVersion.a(dynamic).a();
        int k1 = dynamic.get("clearWeatherTime").asInt(0);
        int l1 = dynamic.get("rainTime").asInt(0);
        boolean flag1 = dynamic.get("raining").asBoolean(false);
        int i22 = dynamic.get("thunderTime").asInt(0);
        boolean flag2 = dynamic.get("thundering").asBoolean(false);
        boolean flag3 = dynamic.get("initialized").asBoolean(true);
        boolean flag4 = dynamic.get("DifficultyLocked").asBoolean(false);
        WorldBorder.c worldborder_c = WorldBorder.c.a(dynamic, WorldBorder.e);
        int j22 = dynamic.get("WanderingTraderSpawnDelay").asInt(0);
        int k22 = dynamic.get("WanderingTraderSpawnChance").asInt(0);
        UUID uuid = dynamic.get("WanderingTraderId").read(UUIDUtil.a).result().orElse(null);
        Set set = dynamic.get("ServerBrands").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet));
        Set<String> set1 = dynamic.get("removed_features").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toSet());
        CustomFunctionCallbackTimerQueue<MinecraftServer> customfunctioncallbacktimerqueue = new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a, dynamic.get("ScheduledEvents").asStream());
        NBTTagCompound nbttagcompound1 = (NBTTagCompound)dynamic.get("CustomBossEvents").orElseEmptyMap().getValue();
        DataResult dataresult = dynamic.get("DragonFight").read(EnderDragonBattle.a.a);
        Logger logger = f;
        Objects.requireNonNull(logger);
        return new WorldDataServer(nbttagcompound, flag, j2, k2, l2, f2, i2, i1, j1, k1, l1, flag1, i22, flag2, flag3, flag4, worldborder_c, j22, k22, uuid, set, set1, customfunctioncallbacktimerqueue, nbttagcompound1, dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(EnderDragonBattle.a.b), info, generatorOptions, specialProperty, lifecycle);
    }

    @Override
    public NBTTagCompound a(IRegistryCustom registryManager, @Nullable NBTTagCompound playerNbt) {
        if (playerNbt == null) {
            playerNbt = this.q;
        }
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.a(registryManager, nbttagcompound1, playerNbt);
        return nbttagcompound1;
    }

    private void a(IRegistryCustom registryManager, NBTTagCompound levelNbt, @Nullable NBTTagCompound playerNbt) {
        levelNbt.a("ServerBrands", WorldDataServer.a(this.F));
        levelNbt.a("WasModded", this.G);
        if (!this.H.isEmpty()) {
            levelNbt.a("removed_features", WorldDataServer.a(this.H));
        }
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        nbttagcompound2.a("Name", SharedConstants.b().c());
        nbttagcompound2.a("Id", SharedConstants.b().d().c());
        nbttagcompound2.a("Snapshot", !SharedConstants.b().g());
        nbttagcompound2.a("Series", SharedConstants.b().d().b());
        levelNbt.a("Version", nbttagcompound2);
        GameProfileSerializer.g(levelNbt);
        RegistryOps<NBTBase> dynamicops = RegistryOps.a(DynamicOpsNBT.a, registryManager);
        DataResult<NBTBase> dataresult = GeneratorSettings.a(dynamicops, this.h, new WorldDimensions(this.customDimensions != null ? this.customDimensions : registryManager.d(Registries.aN)));
        Logger logger = f;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(SystemUtils.a("WorldGenSettings: ", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(nbtbase -> levelNbt.a(c, (NBTBase)nbtbase));
        levelNbt.a("GameType", this.g.b().a());
        levelNbt.a("SpawnX", this.k);
        levelNbt.a("SpawnY", this.l);
        levelNbt.a("SpawnZ", this.m);
        levelNbt.a("SpawnAngle", this.n);
        levelNbt.a("Time", this.o);
        levelNbt.a("DayTime", this.p);
        levelNbt.a("LastPlayed", SystemUtils.d());
        levelNbt.a(a, this.g.a());
        levelNbt.a("version", 19133);
        levelNbt.a("clearWeatherTime", this.s);
        levelNbt.a("rainTime", this.u);
        levelNbt.a("raining", this.t);
        levelNbt.a("thunderTime", this.w);
        levelNbt.a("thundering", this.v);
        levelNbt.a("hardcore", this.g.c());
        levelNbt.a("allowCommands", this.g.e());
        levelNbt.a("initialized", this.x);
        this.z.a(levelNbt);
        levelNbt.a("Difficulty", (byte)this.g.d().a());
        levelNbt.a("DifficultyLocked", this.y);
        levelNbt.a("GameRules", this.g.f().a());
        levelNbt.a("DragonFight", (NBTBase)SystemUtils.a(EnderDragonBattle.a.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.A), IllegalStateException::new));
        if (playerNbt != null) {
            levelNbt.a(b, playerNbt);
        }
        DataResult dataresult1 = WorldDataConfiguration.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.g.g());
        dataresult1.get().ifLeft(nbtbase -> levelNbt.a((NBTTagCompound)nbtbase)).ifRight(partialresult -> f.warn("Failed to encode configuration {}", (Object)partialresult.message()));
        if (this.B != null) {
            levelNbt.a("CustomBossEvents", this.B);
        }
        levelNbt.a("ScheduledEvents", this.I.b());
        levelNbt.a("WanderingTraderSpawnDelay", this.C);
        levelNbt.a("WanderingTraderSpawnChance", this.D);
        if (this.E != null) {
            levelNbt.a("WanderingTraderId", this.E);
        }
        levelNbt.a("Bukkit.Version", Bukkit.getName() + "/" + Bukkit.getVersion() + "/" + Bukkit.getBukkitVersion());
        this.world.getWorld().storeBukkitValues(levelNbt);
    }

    private static NBTTagList a(Set<String> strings) {
        NBTTagList nbttaglist = new NBTTagList();
        Stream<NBTTagString> stream = strings.stream().map(NBTTagString::a);
        Objects.requireNonNull(nbttaglist);
        stream.forEach(nbttaglist::add);
        return nbttaglist;
    }

    @Override
    public int a() {
        return this.k;
    }

    @Override
    public int b() {
        return this.l;
    }

    @Override
    public int c() {
        return this.m;
    }

    @Override
    public float d() {
        return this.n;
    }

    @Override
    public long e() {
        return this.o;
    }

    @Override
    public long f() {
        return this.p;
    }

    @Override
    @Nullable
    public NBTTagCompound y() {
        return this.q;
    }

    @Override
    public void b(int spawnX) {
        this.k = spawnX;
    }

    @Override
    public void c(int spawnY) {
        this.l = spawnY;
    }

    @Override
    public void d(int spawnZ) {
        this.m = spawnZ;
    }

    @Override
    public void a(float spawnAngle) {
        this.n = spawnAngle;
    }

    @Override
    public void a(long time) {
        this.o = time;
    }

    @Override
    public void b(long timeOfDay) {
        this.p = timeOfDay;
    }

    @Override
    public void a(BlockPosition pos, float angle) {
        this.k = pos.u();
        this.l = pos.v();
        this.m = pos.w();
        this.n = angle;
    }

    @Override
    public String g() {
        return this.g.a();
    }

    @Override
    public int z() {
        return this.r;
    }

    @Override
    public int h() {
        return this.s;
    }

    @Override
    public void a(int clearWeatherTime) {
        this.s = clearWeatherTime;
    }

    @Override
    public boolean i() {
        return this.v;
    }

    @Override
    public void a(boolean thundering) {
        this.setThundering(thundering, ThunderChangeEvent.Cause.UNKNOWN);
    }

    public void setThundering(boolean thundering, ThunderChangeEvent.Cause cause) {
        if (this.v == thundering) {
            return;
        }
        World world = Bukkit.getWorld((String)this.g());
        if (world != null) {
            ThunderChangeEvent thunder = new ThunderChangeEvent(world, thundering, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)thunder);
            if (thunder.isCancelled()) {
                return;
            }
        }
        this.v = thundering;
    }

    @Override
    public int j() {
        return this.w;
    }

    @Override
    public void e(int thunderTime) {
        this.w = thunderTime;
    }

    @Override
    public boolean k() {
        return this.t;
    }

    @Override
    public void b(boolean raining) {
        this.setRaining(raining, WeatherChangeEvent.Cause.UNKNOWN);
    }

    public void setRaining(boolean raining, WeatherChangeEvent.Cause cause) {
        if (this.t == raining) {
            return;
        }
        World world = Bukkit.getWorld((String)this.g());
        if (world != null) {
            WeatherChangeEvent weather = new WeatherChangeEvent(world, raining, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)weather);
            if (weather.isCancelled()) {
                return;
            }
        }
        this.t = raining;
    }

    @Override
    public int l() {
        return this.u;
    }

    @Override
    public void f(int rainTime) {
        this.u = rainTime;
    }

    @Override
    public EnumGamemode m() {
        return this.g.b();
    }

    @Override
    public void a(EnumGamemode gameMode) {
        this.g = this.g.a(gameMode);
    }

    @Override
    public boolean n() {
        return this.g.c();
    }

    @Override
    public boolean o() {
        return this.g.e();
    }

    @Override
    public boolean p() {
        return this.x;
    }

    @Override
    public void c(boolean initialized) {
        this.x = initialized;
    }

    @Override
    public GameRules q() {
        return this.g.f();
    }

    @Override
    public WorldBorder.c r() {
        return this.z;
    }

    @Override
    public void a(WorldBorder.c worldBorder) {
        this.z = worldBorder;
    }

    @Override
    public EnumDifficulty s() {
        return this.g.d();
    }

    @Override
    public void a(EnumDifficulty difficulty) {
        this.g = this.g.a(difficulty);
        PacketPlayOutServerDifficulty packet = new PacketPlayOutServerDifficulty(this.s(), this.t());
        for (EntityPlayer player : this.world.x()) {
            player.c.b(packet);
        }
    }

    @Override
    public boolean t() {
        return this.y;
    }

    @Override
    public void d(boolean difficultyLocked) {
        this.y = difficultyLocked;
    }

    @Override
    public CustomFunctionCallbackTimerQueue<MinecraftServer> u() {
        return this.I;
    }

    @Override
    public void a(CrashReportSystemDetails reportSection, LevelHeightAccessor world) {
        IWorldDataServer.super.a(reportSection, world);
        SaveData.super.a(reportSection);
    }

    @Override
    public WorldOptions A() {
        return this.h;
    }

    @Override
    public boolean B() {
        return this.i == net.minecraft.world.level.storage.WorldDataServer$a.b;
    }

    @Override
    public boolean C() {
        return this.i == net.minecraft.world.level.storage.WorldDataServer$a.c;
    }

    @Override
    public Lifecycle D() {
        return this.j;
    }

    @Override
    public EnderDragonBattle.a E() {
        return this.A;
    }

    @Override
    public void a(EnderDragonBattle.a dragonFight) {
        this.A = dragonFight;
    }

    @Override
    public WorldDataConfiguration F() {
        return this.g.g();
    }

    @Override
    public void a(WorldDataConfiguration dataConfiguration) {
        this.g = this.g.a(dataConfiguration);
    }

    @Override
    @Nullable
    public NBTTagCompound G() {
        return this.B;
    }

    @Override
    public void a(@Nullable NBTTagCompound customBossEvents) {
        this.B = customBossEvents;
    }

    @Override
    public int v() {
        return this.C;
    }

    @Override
    public void g(int wanderingTraderSpawnDelay) {
        this.C = wanderingTraderSpawnDelay;
    }

    @Override
    public int w() {
        return this.D;
    }

    @Override
    public void h(int wanderingTraderSpawnChance) {
        this.D = wanderingTraderSpawnChance;
    }

    @Override
    @Nullable
    public UUID x() {
        return this.E;
    }

    @Override
    public void a(UUID wanderingTraderId) {
        this.E = wanderingTraderId;
    }

    @Override
    public void a(String brand, boolean modded) {
        this.F.add(brand);
        this.G |= modded;
    }

    @Override
    public boolean H() {
        return this.G;
    }

    @Override
    public Set<String> I() {
        return ImmutableSet.copyOf(this.F);
    }

    @Override
    public Set<String> J() {
        return Set.copyOf(this.H);
    }

    @Override
    public IWorldDataServer K() {
        return this;
    }

    @Override
    public WorldSettings L() {
        return this.g.h();
    }

    public void checkName(String name) {
        if (!this.g.a.equals(name)) {
            this.g.a = name;
        }
    }

    @Deprecated
    public static enum a {
        a,
        b,
        c;

    }
}

