/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import org.slf4j.Logger;

public class WorldPersistentData
implements Closeable {
    private static final Logger a = LogUtils.getLogger();
    public final Map<String, PersistentBase> b = Maps.newHashMap();
    private final DataFixer c;
    private final File d;
    protected final ExecutorService ioExecutor;

    public WorldPersistentData(File directory, DataFixer dataFixer) {
        this.c = dataFixer;
        this.d = directory;
        String worldFolder = this.d.getParent();
        this.ioExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("DimensionDataIO - " + worldFolder + " - %d").setDaemon(true).build());
    }

    private File a(String id) {
        return new File(this.d, id + ".dat");
    }

    public <T extends PersistentBase> T a(PersistentBase.a<T> type, String id) {
        T savedData = this.b(type, id);
        if (savedData != null) {
            return savedData;
        }
        PersistentBase savedData2 = (PersistentBase)type.a().get();
        this.a(id, savedData2);
        return (T)savedData2;
    }

    @Nullable
    public <T extends PersistentBase> T b(PersistentBase.a<T> type, String id) {
        PersistentBase savedData = this.b.get(id);
        if (savedData == null && !this.b.containsKey(id)) {
            savedData = this.a(type.b(), type.c(), id);
            this.b.put(id, savedData);
        }
        return (T)savedData;
    }

    @Nullable
    public <T extends PersistentBase> T a(Function<NBTTagCompound, T> readFunction, DataFixTypes dataFixTypes, String id) {
        try {
            File file = this.a(id);
            if (file.exists()) {
                NBTTagCompound compoundTag = this.a(id, dataFixTypes, SharedConstants.b().d().c());
                return (T)((PersistentBase)readFunction.apply(compoundTag.p("data")));
            }
        }
        catch (Exception var6) {
            a.error("Error loading saved data: {}", (Object)id, (Object)var6);
        }
        return null;
    }

    public void a(String id, PersistentBase state) {
        this.b.put(id, state);
    }

    public NBTTagCompound a(String id, DataFixTypes dataFixTypes, int currentSaveVersion) throws IOException {
        NBTTagCompound var9;
        File file = this.a(id);
        try (FileInputStream fileInputStream = new FileInputStream(file);
             PushbackInputStream pushbackInputStream = new PushbackInputStream(fileInputStream, 2);){
            NBTTagCompound compoundTag;
            if (this.a(pushbackInputStream)) {
                compoundTag = NBTCompressedStreamTools.a(pushbackInputStream, NBTReadLimiter.a());
            } else {
                try (DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);){
                    compoundTag = NBTCompressedStreamTools.a(dataInputStream);
                }
            }
            int i2 = GameProfileSerializer.b(compoundTag, 1343);
            var9 = dataFixTypes.a(this.c, compoundTag, i2, currentSaveVersion);
        }
        return var9;
    }

    private boolean a(PushbackInputStream stream) throws IOException {
        int j2;
        byte[] bs = new byte[2];
        boolean bl = false;
        int i2 = stream.read(bs, 0, 2);
        if (i2 == 2 && (j2 = (bs[1] & 0xFF) << 8 | bs[0] & 0xFF) == 35615) {
            bl = true;
        }
        if (i2 != 0) {
            stream.unread(bs, 0, i2);
        }
        return bl;
    }

    @Override
    public void close() throws IOException {
        this.save(false);
        this.ioExecutor.shutdown();
    }

    public void save(boolean async) {
        this.b.forEach((id, state) -> {
            if (state != null) {
                CompletableFuture<Void> save = state.save(this.a((String)id), this.ioExecutor);
                if (!async) {
                    save.join();
                }
            }
        });
    }
}

