/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.bukkit.craftbukkit.v1_20_R3.CraftLootTable;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftNamespacedKey;
import org.slf4j.Logger;

public class LootDataManager
implements IReloadListener,
LootDataResolver {
    private static final Logger b = LogUtils.getLogger();
    private static final Gson c = new GsonBuilder().create();
    public static final LootDataId<LootTable> a = new LootDataId<LootTable>(LootDataType.c, LootTables.a);
    private Map<LootDataId<?>, ?> d = Map.of();
    private Multimap<LootDataType<?>, MinecraftKey> e = ImmutableMultimap.of();

    @Override
    public final CompletableFuture<Void> a(IReloadListener.a synchronizer, IResourceManager manager, GameProfilerFiller prepareProfiler, GameProfilerFiller applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        HashMap map = new HashMap();
        CompletableFuture[] acompletablefuture = (CompletableFuture[])LootDataType.b().map(lootdatatype -> LootDataManager.a(lootdatatype, manager, prepareExecutor, map)).toArray(CompletableFuture[]::new);
        CompletableFuture<Void> completablefuture = CompletableFuture.allOf(acompletablefuture);
        Objects.requireNonNull(synchronizer);
        return ((CompletableFuture)completablefuture.thenCompose(synchronizer::a)).thenAcceptAsync(ovoid -> this.a(map), applyExecutor);
    }

    private static <T> CompletableFuture<?> a(LootDataType<T> type, IResourceManager resourceManager, Executor executor, Map<LootDataType<?>, Map<MinecraftKey, ?>> results) {
        HashMap map1 = new HashMap();
        results.put(type, map1);
        return CompletableFuture.runAsync(() -> {
            HashMap<MinecraftKey, JsonElement> map2 = new HashMap<MinecraftKey, JsonElement>();
            ResourceDataJson.a(resourceManager, type.a(), c, map2);
            map2.forEach((minecraftkey, jsonelement) -> type.a((MinecraftKey)minecraftkey, (JsonElement)jsonelement).ifPresent(object -> map1.put(minecraftkey, object)));
        }, executor);
    }

    private void a(Map<LootDataType<?>, Map<MinecraftKey, ?>> lootData) {
        Object object = lootData.get(LootDataType.c).remove(LootTables.a);
        if (object != null) {
            b.warn("Datapack tried to redefine {} loot table, ignoring", (Object)LootTables.a);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMultimap.Builder com_google_common_collect_immutablemultimap_builder = ImmutableMultimap.builder();
        lootData.forEach((lootdatatype, map1) -> map1.forEach((minecraftkey, object1) -> {
            builder.put(new LootDataId(lootdatatype, (MinecraftKey)minecraftkey), object1);
            com_google_common_collect_immutablemultimap_builder.put(lootdatatype, minecraftkey);
        }));
        builder.put(a, (Object)LootTable.a);
        ProblemReporter.a problemreporter_a = new ProblemReporter.a();
        ImmutableMap map12 = builder.build();
        LootCollector lootcollector = new LootCollector(problemreporter_a, LootContextParameterSets.n, new LootDataResolver(){
            final /* synthetic */ Map val$map1;
            {
                this.val$map1 = map;
            }

            @Override
            @Nullable
            public <T> T getElement(LootDataId<T> key) {
                return (T)this.val$map1.get(key);
            }
        });
        map12.forEach((lootdataid, object1) -> LootDataManager.a(lootcollector, lootdataid, object1));
        problemreporter_a.a().forEach((s2, s1) -> b.warn("Found loot table element validation problem in {}: {}", s2, s1));
        map12.forEach((key, lootTable) -> {
            if (lootTable instanceof LootTable) {
                LootTable table = (LootTable)lootTable;
                table.craftLootTable = new CraftLootTable(CraftNamespacedKey.fromMinecraft(key.b()), table);
            }
        });
        this.d = map12;
        this.e = com_google_common_collect_immutablemultimap_builder.build();
    }

    private static <T> void a(LootCollector reporter, LootDataId<T> key, Object value) {
        key.a().a(reporter, key, value);
    }

    @Override
    @Nullable
    public <T> T getElement(LootDataId<T> key) {
        return (T)this.d.get(key);
    }

    public Collection<MinecraftKey> a(LootDataType<?> type) {
        return this.e.get(type);
    }
}

