/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntry;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionUser;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootSelector {
    public static final Codec<LootSelector> a = RecordCodecBuilder.create(instance -> instance.group((App)LootEntries.a.listOf().fieldOf("entries").forGetter(pool -> pool.b), (App)ExtraCodecs.a(LootItemConditions.a.listOf(), "conditions", List.of()).forGetter(pool -> pool.c), (App)ExtraCodecs.a(LootItemFunctions.b.listOf(), "functions", List.of()).forGetter(pool -> pool.e), (App)NumberProviders.a.fieldOf("rolls").forGetter(pool -> pool.g), (App)NumberProviders.a.fieldOf("bonus_rolls").orElse((Object)ConstantValue.a(0.0f)).forGetter(pool -> pool.h)).apply((Applicative)instance, LootSelector::new));
    private final List<LootEntryAbstract> b;
    private final List<LootItemCondition> c;
    private final Predicate<LootTableInfo> d;
    private final List<LootItemFunction> e;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> f;
    private final NumberProvider g;
    private final NumberProvider h;

    LootSelector(List<LootEntryAbstract> entries, List<LootItemCondition> conditions, List<LootItemFunction> functions, NumberProvider rolls, NumberProvider bonusRolls) {
        this.b = entries;
        this.c = conditions;
        this.d = LootItemConditions.a(conditions);
        this.e = functions;
        this.f = LootItemFunctions.a(functions);
        this.g = rolls;
        this.h = bonusRolls;
    }

    private void b(Consumer<ItemStack> lootConsumer, LootTableInfo context) {
        RandomSource randomSource = context.b();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableInt = new MutableInt();
        for (LootEntryAbstract lootPoolEntryContainer : this.b) {
            lootPoolEntryContainer.expand(context, choice -> {
                int i2 = choice.a(context.c());
                if (i2 > 0) {
                    list.add(choice);
                    mutableInt.add(i2);
                }
            });
        }
        int i2 = list.size();
        if (mutableInt.intValue() == 0 || i2 == 0) {
            return;
        }
        if (i2 == 1) {
            ((LootEntry)list.get(0)).a(lootConsumer, context);
            return;
        }
        int j2 = randomSource.a(mutableInt.intValue());
        for (LootEntry lootPoolEntry : list) {
            if ((j2 -= lootPoolEntry.a(context.c())) >= 0) continue;
            lootPoolEntry.a(lootConsumer, context);
            return;
        }
    }

    public void a(Consumer<ItemStack> lootConsumer, LootTableInfo context) {
        if (!this.d.test(context)) {
            return;
        }
        Consumer<ItemStack> consumer = LootItemFunction.a(this.f, lootConsumer, context);
        int i2 = this.g.a(context) + MathHelper.d(this.h.b(context) * context.c());
        for (int j2 = 0; j2 < i2; ++j2) {
            this.b(consumer, context);
        }
    }

    public void a(LootCollector reporter) {
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            this.c.get(i2).a(reporter.a(".condition[" + i2 + "]"));
        }
        for (int j2 = 0; j2 < this.e.size(); ++j2) {
            this.e.get(j2).a(reporter.a(".functions[" + j2 + "]"));
        }
        for (int k2 = 0; k2 < this.b.size(); ++k2) {
            this.b.get(k2).a(reporter.a(".entries[" + k2 + "]"));
        }
        this.g.a(reporter.a(".rolls"));
        this.h.a(reporter.a(".bonusRolls"));
    }

    public static a a() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a>,
    LootItemConditionUser<a> {
        private final ImmutableList.Builder<LootEntryAbstract> a = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemCondition> b = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> c = ImmutableList.builder();
        private NumberProvider d = ConstantValue.a(1.0f);
        private NumberProvider e = ConstantValue.a(0.0f);

        public a a(NumberProvider rolls) {
            this.d = rolls;
            return this;
        }

        @Override
        public a a() {
            return this;
        }

        public a b(NumberProvider bonusRolls) {
            this.e = bonusRolls;
            return this;
        }

        public a a(LootEntryAbstract.a<?> entry) {
            this.a.add((Object)entry.b());
            return this;
        }

        @Override
        public a a(LootItemCondition.a builder) {
            this.b.add((Object)builder.build());
            return this;
        }

        @Override
        public a a(LootItemFunction.a builder) {
            this.c.add((Object)builder.b());
            return this;
        }

        public LootSelector b() {
            return new LootSelector((List<LootEntryAbstract>)this.a.build(), (List<LootItemCondition>)this.b.build(), (List<LootItemFunction>)this.c.build(), this.d, this.e);
        }

        @Override
        public /* synthetic */ LootItemFunctionUser c() {
            return this.a();
        }

        @Override
        public /* synthetic */ LootItemFunctionUser b(LootItemFunction.a function) {
            return this.a(function);
        }

        @Override
        public /* synthetic */ LootItemConditionUser d() {
            return this.a();
        }

        @Override
        public /* synthetic */ LootItemConditionUser b(LootItemCondition.a condition) {
            return this.a(condition);
        }
    }
}

