/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.bukkit.craftbukkit.v1_20_R3.CraftLootTable;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.event.world.LootGenerateEvent;
import org.slf4j.Logger;

public class LootTable {
    private static final Logger d = LogUtils.getLogger();
    public static final LootTable a = new LootTable(LootContextParameterSets.b, Optional.empty(), List.of(), List.of());
    public static final LootContextParameterSet b = LootContextParameterSets.n;
    public static final Codec<LootTable> c = RecordCodecBuilder.create(instance -> instance.group((App)LootContextParameterSets.a.optionalFieldOf("type", (Object)b).forGetter(loottable -> loottable.e), (App)ExtraCodecs.a(MinecraftKey.a, "random_sequence").forGetter(loottable -> loottable.f), (App)ExtraCodecs.a(LootSelector.a.listOf(), "pools", List.of()).forGetter(loottable -> loottable.g), (App)ExtraCodecs.a(LootItemFunctions.b.listOf(), "functions", List.of()).forGetter(loottable -> loottable.h)).apply((Applicative)instance, LootTable::new));
    private final LootContextParameterSet e;
    private final Optional<MinecraftKey> f;
    private final List<LootSelector> g;
    private final List<LootItemFunction> h;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> i;
    public CraftLootTable craftLootTable;

    LootTable(LootContextParameterSet type, Optional<MinecraftKey> randomSequenceId, List<LootSelector> pools, List<LootItemFunction> functions) {
        this.e = type;
        this.f = randomSequenceId;
        this.g = pools;
        this.h = functions;
        this.i = LootItemFunctions.a(functions);
    }

    public static Consumer<ItemStack> a(WorldServer world, Consumer<ItemStack> consumer) {
        boolean skipSplitter = world != null && !world.paperConfig().fixes.splitOverstackedLoot;
        return itemstack -> {
            if (itemstack.a(world.I())) {
                if (skipSplitter || itemstack.L() < itemstack.g()) {
                    consumer.accept((ItemStack)itemstack);
                } else {
                    ItemStack itemstack1;
                    for (int i2 = itemstack.L(); i2 > 0; i2 -= itemstack1.L()) {
                        itemstack1 = itemstack.c(Math.min(itemstack.g(), i2));
                        consumer.accept(itemstack1);
                    }
                }
            }
        };
    }

    public void a(LootParams parameters, Consumer<ItemStack> lootConsumer) {
        this.a(new LootTableInfo.Builder(parameters).a(this.f), lootConsumer);
    }

    public void a(LootTableInfo context, Consumer<ItemStack> lootConsumer) {
        LootTableInfo.c<LootTable> loottableinfo_c = LootTableInfo.a(this);
        if (context.b(loottableinfo_c)) {
            Consumer<ItemStack> consumer1 = LootItemFunction.a(this.i, lootConsumer, context);
            for (LootSelector lootselector : this.g) {
                lootselector.a(consumer1, context);
            }
            context.c(loottableinfo_c);
        } else {
            d.warn("Detected infinite loop in loot tables");
        }
    }

    public void a(LootParams parameters, long seed, Consumer<ItemStack> lootConsumer) {
        this.a(new LootTableInfo.Builder(parameters).a(seed).a(this.f), LootTable.a(parameters.a(), lootConsumer));
    }

    public void b(LootParams parameters, Consumer<ItemStack> lootConsumer) {
        this.a(parameters, LootTable.a(parameters.a(), lootConsumer));
    }

    public void b(LootTableInfo context, Consumer<ItemStack> lootConsumer) {
        this.a(context, LootTable.a(context.d(), lootConsumer));
    }

    public ObjectArrayList<ItemStack> a(LootParams parameters, long seed) {
        return this.a(new LootTableInfo.Builder(parameters).a(seed).a(this.f));
    }

    public ObjectArrayList<ItemStack> a(LootParams parameters) {
        return this.a(new LootTableInfo.Builder(parameters).a(this.f));
    }

    private ObjectArrayList<ItemStack> a(LootTableInfo context) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        Objects.requireNonNull(objectarraylist);
        this.b(context, arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
        return objectarraylist;
    }

    public LootContextParameterSet a() {
        return this.e;
    }

    public void a(LootCollector reporter) {
        int i2;
        for (i2 = 0; i2 < this.g.size(); ++i2) {
            this.g.get(i2).a(reporter.a(".pools[" + i2 + "]"));
        }
        for (i2 = 0; i2 < this.h.size(); ++i2) {
            this.h.get(i2).a(reporter.a(".functions[" + i2 + "]"));
        }
    }

    public void a(IInventory inventory, LootParams parameters, long seed) {
        this.fillInventory(inventory, parameters, seed, false);
    }

    public void fillInventory(IInventory iinventory, LootParams lootparams, long i2, boolean plugin) {
        LootTableInfo loottableinfo = new LootTableInfo.Builder(lootparams).a(i2).a(this.f);
        ObjectArrayList objectarraylist = this.a(loottableinfo);
        RandomSource randomsource = loottableinfo.b();
        LootGenerateEvent event = CraftEventFactory.callLootGenerateEvent(iinventory, this, loottableinfo, objectarraylist, plugin);
        if (event.isCancelled()) {
            return;
        }
        objectarraylist = (ObjectArrayList)event.getLoot().stream().map(CraftItemStack::asNMSCopy).collect(ObjectArrayList.toList());
        List<Integer> list = this.a(iinventory, randomsource);
        this.a((ObjectArrayList<ItemStack>)objectarraylist, list.size(), randomsource);
        for (ItemStack itemstack : objectarraylist) {
            if (list.isEmpty()) {
                d.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.b()) {
                iinventory.a((int)list.remove(list.size() - 1), ItemStack.f);
                continue;
            }
            iinventory.a((int)list.remove(list.size() - 1), itemstack);
        }
    }

    private void a(ObjectArrayList<ItemStack> drops, int freeSlots, RandomSource random) {
        ArrayList list = Lists.newArrayList();
        ObjectListIterator objectlistiterator = drops.iterator();
        while (objectlistiterator.hasNext()) {
            ItemStack itemstack = (ItemStack)objectlistiterator.next();
            if (itemstack.b()) {
                objectlistiterator.remove();
                continue;
            }
            if (itemstack.L() <= 1) continue;
            list.add(itemstack);
            objectlistiterator.remove();
        }
        while (freeSlots - drops.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack1 = (ItemStack)list.remove(MathHelper.a(random, 0, list.size() - 1));
            int j2 = MathHelper.a(random, 1, itemstack1.L() / 2);
            ItemStack itemstack2 = itemstack1.a(j2);
            if (itemstack1.L() > 1 && random.h()) {
                list.add(itemstack1);
            } else {
                drops.add((Object)itemstack1);
            }
            if (itemstack2.L() > 1 && random.h()) {
                list.add(itemstack2);
                continue;
            }
            drops.add((Object)itemstack2);
        }
        drops.addAll((Collection)list);
        SystemUtils.c(drops, random);
    }

    private List<Integer> a(IInventory inventory, RandomSource random) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        for (int i2 = 0; i2 < inventory.b(); ++i2) {
            if (!inventory.a(i2).b()) continue;
            objectarraylist.add((Object)i2);
        }
        SystemUtils.c(objectarraylist, random);
        return objectarraylist;
    }

    public static a b() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a> {
        private final ImmutableList.Builder<LootSelector> a = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> b = ImmutableList.builder();
        private LootContextParameterSet c = b;
        private Optional<MinecraftKey> d = Optional.empty();

        public a a(LootSelector.a poolBuilder) {
            this.a.add((Object)poolBuilder.b());
            return this;
        }

        public a a(LootContextParameterSet type) {
            this.c = type;
            return this;
        }

        public a a(MinecraftKey randomSequenceId) {
            this.d = Optional.of(randomSequenceId);
            return this;
        }

        public a a(LootItemFunction.a function) {
            this.b.add((Object)function.b());
            return this;
        }

        public a a() {
            return this;
        }

        public LootTable b() {
            return new LootTable(this.c, this.d, (List<LootSelector>)this.a.build(), (List<LootItemFunction>)this.b.build());
        }
    }
}

