/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class FunctionReference
extends LootItemFunctionConditional {
    private static final Logger b = LogUtils.getLogger();
    public static final Codec<FunctionReference> a = RecordCodecBuilder.create(instance -> FunctionReference.a(instance).and((App)MinecraftKey.a.fieldOf("name").forGetter(function -> function.c)).apply((Applicative)instance, FunctionReference::new));
    private final MinecraftKey c;

    private FunctionReference(List<LootItemCondition> conditions, MinecraftKey name) {
        super(conditions);
        this.c = name;
    }

    @Override
    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.B;
    }

    @Override
    @Override
    public void a(LootCollector reporter) {
        LootDataId<LootItemFunction> lootDataId = new LootDataId<LootItemFunction>(LootDataType.b, this.c);
        if (reporter.a(lootDataId)) {
            reporter.b("Function " + this.c + " is recursively called");
            return;
        }
        super.a(reporter);
        reporter.a().getElementOptional(lootDataId).ifPresentOrElse(itemModifier -> itemModifier.a(reporter.a(".{" + this.c + "}", lootDataId)), () -> reporter.b("Unknown function table called " + this.c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    protected ItemStack a(ItemStack stack, LootTableInfo context) {
        LootItemFunction lootItemFunction = context.a().getElement(LootDataType.b, this.c);
        if (lootItemFunction == null) {
            b.warn("Unknown function: {}", (Object)this.c);
            return stack;
        }
        LootTableInfo.c<LootItemFunction> visitedEntry = LootTableInfo.a(lootItemFunction);
        if (context.b(visitedEntry)) {
            try {
                ItemStack itemStack = (ItemStack)lootItemFunction.apply(stack, context);
                return itemStack;
            }
            finally {
                context.c(visitedEntry);
            }
        }
        b.warn("Detected infinite loop in loot tables");
        return stack;
    }

    public static LootItemFunctionConditional.a<?> a(MinecraftKey name) {
        return FunctionReference.a((List<LootItemCondition> conditions) -> new FunctionReference((List<LootItemCondition>)conditions, name));
    }
}

