/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public abstract class CompositeLootItemCondition
implements LootItemCondition {
    protected final List<LootItemCondition> c;
    private final Predicate<LootTableInfo> a;

    protected CompositeLootItemCondition(List<LootItemCondition> terms, Predicate<LootTableInfo> predicate) {
        this.c = terms;
        this.a = predicate;
    }

    protected static <T extends CompositeLootItemCondition> Codec<T> a(Function<List<LootItemCondition>, T> termsToCondition) {
        return RecordCodecBuilder.create(instance -> instance.group((App)LootItemConditions.a.listOf().fieldOf("terms").forGetter(condition -> condition.c)).apply((Applicative)instance, termsToCondition));
    }

    protected static <T extends CompositeLootItemCondition> Codec<T> b(Function<List<LootItemCondition>, T> termsToCondition) {
        return LootItemConditions.a.listOf().xmap(termsToCondition, condition -> condition.c);
    }

    @Override
    public final boolean a(LootTableInfo lootContext) {
        return this.a.test(lootContext);
    }

    @Override
    @Override
    public void a(LootCollector reporter) {
        LootItemCondition.super.a(reporter);
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            this.c.get(i2).a(reporter.a(".term[" + i2 + "]"));
        }
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.a((LootTableInfo)object);
    }

    public static abstract class a
    implements LootItemCondition.a {
        private final ImmutableList.Builder<LootItemCondition> a = ImmutableList.builder();

        protected a(LootItemCondition.a ... terms) {
            for (LootItemCondition.a builder : terms) {
                this.a.add((Object)builder.build());
            }
        }

        public void a(LootItemCondition.a builder) {
            this.a.add((Object)builder.build());
        }

        @Override
        @Override
        public LootItemCondition build() {
            return this.a((List<LootItemCondition>)this.a.build());
        }

        protected abstract LootItemCondition a(List<LootItemCondition> var1);
    }
}

