/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public record LootItemConditionReference(MinecraftKey b) implements LootItemCondition
{
    private final MinecraftKey b;
    private static final Logger c = LogUtils.getLogger();
    public static final Codec<LootItemConditionReference> a = RecordCodecBuilder.create(instance -> instance.group((App)MinecraftKey.a.fieldOf("name").forGetter(LootItemConditionReference::c)).apply((Applicative)instance, LootItemConditionReference::new));

    @Override
    @Override
    public LootItemConditionType b() {
        return LootItemConditions.q;
    }

    @Override
    @Override
    public void a(LootCollector reporter) {
        LootDataId<LootItemCondition> lootDataId = new LootDataId<LootItemCondition>(LootDataType.a, this.b);
        if (reporter.a(lootDataId)) {
            reporter.b("Condition " + this.b + " is recursively called");
            return;
        }
        LootItemCondition.super.a(reporter);
        reporter.a().getElementOptional(lootDataId).ifPresentOrElse(predicate -> predicate.a(reporter.a(".{" + this.b + "}", lootDataId)), () -> reporter.b("Unknown condition table called " + this.b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean a(LootTableInfo lootContext) {
        LootItemCondition lootItemCondition = lootContext.a().getElement(LootDataType.a, this.b);
        if (lootItemCondition == null) {
            c.warn("Tried using unknown condition table called {}", (Object)this.b);
            return false;
        }
        LootTableInfo.c<LootItemCondition> visitedEntry = LootTableInfo.a(lootItemCondition);
        if (lootContext.b(visitedEntry)) {
            try {
                boolean bl = lootItemCondition.test(lootContext);
                return bl;
            }
            finally {
                lootContext.c(visitedEntry);
            }
        }
        c.warn("Detected infinite loop in loot tables");
        return false;
    }

    public static LootItemCondition.a a(MinecraftKey id) {
        return () -> new LootItemConditionReference(id);
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LootItemConditionReference.class, "name", "b"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LootItemConditionReference.class, "name", "b"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LootItemConditionReference.class, "name", "b"}, this, object);
    }

    public MinecraftKey c() {
        return this.b;
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.a((LootTableInfo)object);
    }
}

