/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.TickList;

public class TickListServer<T>
implements LevelTickAccess<T> {
    private static final Comparator<LevelChunkTicks<?>> a = (a2, b2) -> NextTickListEntry.b.compare(a2.b(), b2.b());
    private final LongPredicate b;
    private final Supplier<GameProfilerFiller> c;
    private final Long2ObjectMap<LevelChunkTicks<T>> d = new Long2ObjectOpenHashMap();
    private final Long2LongMap e = (Long2LongMap)SystemUtils.a(new Long2LongOpenHashMap(), (? super T map) -> map.defaultReturnValue(Long.MAX_VALUE));
    private final Queue<LevelChunkTicks<T>> f = new PriorityQueue(a);
    private final Queue<NextTickListEntry<T>> g = new ArrayDeque<NextTickListEntry<T>>();
    private final List<NextTickListEntry<T>> h = new ArrayList<NextTickListEntry<T>>();
    private final Set<NextTickListEntry<?>> i = new ObjectOpenCustomHashSet(NextTickListEntry.c);
    private final BiConsumer<LevelChunkTicks<T>, NextTickListEntry<T>> j = (chunkTickScheduler, tick) -> {
        if (tick.equals(chunkTickScheduler.b())) {
            this.b((NextTickListEntry<T>)tick);
        }
    };

    public TickListServer(LongPredicate tickingFutureReadyPredicate, Supplier<GameProfilerFiller> profilerGetter) {
        this.b = tickingFutureReadyPredicate;
        this.c = profilerGetter;
    }

    public void a(ChunkCoordIntPair pos, LevelChunkTicks<T> scheduler) {
        long l2 = pos.a();
        this.d.put(l2, scheduler);
        NextTickListEntry<T> scheduledTick = scheduler.b();
        if (scheduledTick != null) {
            this.e.put(l2, scheduledTick.c());
        }
        scheduler.a(this.j);
    }

    public void a(ChunkCoordIntPair pos) {
        long l2 = pos.a();
        LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.d.remove(l2);
        this.e.remove(l2);
        if (levelChunkTicks != null) {
            levelChunkTicks.a(null);
        }
    }

    @Override
    public void a(NextTickListEntry<T> orderedTick) {
        long l2 = ChunkCoordIntPair.a(orderedTick.b());
        LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.d.get(l2);
        if (levelChunkTicks == null) {
            SystemUtils.b(new IllegalStateException("Trying to schedule tick in not loaded position " + orderedTick.b()));
        } else {
            levelChunkTicks.a(orderedTick);
        }
    }

    public void a(long time, int maxTicks, BiConsumer<BlockPosition, T> ticker) {
        this.a(time, maxTicks, (GameProfilerFiller)null);
        this.a(ticker);
        this.c();
    }

    private void a(long time, int maxTicks, GameProfilerFiller profiler) {
        this.a(time);
        this.a(time, maxTicks);
        this.b();
    }

    private void a(long time) {
        ObjectIterator objectIterator = Long2LongMaps.fastIterator((Long2LongMap)this.e);
        while (objectIterator.hasNext()) {
            Long2LongMap.Entry entry = (Long2LongMap.Entry)objectIterator.next();
            long l2 = entry.getLongKey();
            long m2 = entry.getLongValue();
            if (m2 > time) continue;
            LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.d.get(l2);
            if (levelChunkTicks == null) {
                objectIterator.remove();
                continue;
            }
            NextTickListEntry scheduledTick = levelChunkTicks.b();
            if (scheduledTick == null) {
                objectIterator.remove();
                continue;
            }
            if (scheduledTick.c() > time) {
                entry.setValue(scheduledTick.c());
                continue;
            }
            if (!this.b.test(l2)) continue;
            objectIterator.remove();
            this.f.add(levelChunkTicks);
        }
    }

    private void a(long time, int maxTicks) {
        LevelChunkTicks<T> levelChunkTicks;
        while (this.a(maxTicks) && (levelChunkTicks = this.f.poll()) != null) {
            NextTickListEntry<T> scheduledTick = levelChunkTicks.c();
            this.c(scheduledTick);
            this.a(this.f, levelChunkTicks, time, maxTicks);
            NextTickListEntry<T> scheduledTick2 = levelChunkTicks.b();
            if (scheduledTick2 == null) continue;
            if (scheduledTick2.c() <= time && this.a(maxTicks)) {
                this.f.add(levelChunkTicks);
                continue;
            }
            this.b(scheduledTick2);
        }
    }

    private void b() {
        for (LevelChunkTicks levelChunkTicks : this.f) {
            this.b(levelChunkTicks.b());
        }
    }

    private void b(NextTickListEntry<T> tick) {
        this.e.put(ChunkCoordIntPair.a(tick.b()), tick.c());
    }

    private void a(Queue<LevelChunkTicks<T>> tickableChunkTickSchedulers, LevelChunkTicks<T> chunkTickScheduler, long tick, int maxTicks) {
        if (this.a(maxTicks)) {
            NextTickListEntry<T> scheduledTick2;
            NextTickListEntry<T> scheduledTick;
            LevelChunkTicks<T> levelChunkTicks = tickableChunkTickSchedulers.peek();
            NextTickListEntry<T> nextTickListEntry = scheduledTick = levelChunkTicks != null ? levelChunkTicks.b() : null;
            while (this.a(maxTicks) && (scheduledTick2 = chunkTickScheduler.b()) != null && scheduledTick2.c() <= tick && (scheduledTick == null || NextTickListEntry.b.compare(scheduledTick2, scheduledTick) <= 0)) {
                chunkTickScheduler.c();
                this.c(scheduledTick2);
            }
        }
    }

    private void c(NextTickListEntry<T> tick) {
        this.g.add(tick);
    }

    private boolean a(int maxTicks) {
        return this.g.size() < maxTicks;
    }

    private void a(BiConsumer<BlockPosition, T> ticker) {
        while (!this.g.isEmpty()) {
            NextTickListEntry<T> scheduledTick = this.g.poll();
            if (!this.i.isEmpty()) {
                this.i.remove(scheduledTick);
            }
            this.h.add(scheduledTick);
            ticker.accept(scheduledTick.b(), (BlockPosition)scheduledTick.a());
        }
    }

    private void c() {
        this.g.clear();
        this.f.clear();
        this.h.clear();
        this.i.clear();
    }

    @Override
    public boolean a(BlockPosition pos, T type) {
        LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.d.get(ChunkCoordIntPair.a(pos));
        return levelChunkTicks != null && levelChunkTicks.a(pos, type);
    }

    @Override
    public boolean b(BlockPosition pos, T type) {
        this.d();
        return this.i.contains(NextTickListEntry.a(type, pos));
    }

    private void d() {
        if (this.i.isEmpty() && !this.g.isEmpty()) {
            this.i.addAll(this.g);
        }
    }

    private void a(StructureBoundingBox box, a<T> visitor) {
        int i2 = SectionPosition.a((double)box.h());
        int j2 = SectionPosition.a((double)box.j());
        int k2 = SectionPosition.a((double)box.k());
        int l2 = SectionPosition.a((double)box.m());
        for (int m2 = i2; m2 <= k2; ++m2) {
            for (int n2 = j2; n2 <= l2; ++n2) {
                long o2 = ChunkCoordIntPair.c(m2, n2);
                LevelChunkTicks levelChunkTicks = (LevelChunkTicks)this.d.get(o2);
                if (levelChunkTicks == null) continue;
                visitor.accept(o2, levelChunkTicks);
            }
        }
    }

    public void a(StructureBoundingBox box) {
        Predicate<NextTickListEntry> predicate = tick -> box.b(tick.b());
        this.a(box, (long chunkPos, LevelChunkTicks<T> chunkTickScheduler) -> {
            NextTickListEntry scheduledTick = chunkTickScheduler.b();
            chunkTickScheduler.a(predicate);
            NextTickListEntry scheduledTick2 = chunkTickScheduler.b();
            if (scheduledTick2 != scheduledTick) {
                if (scheduledTick2 != null) {
                    this.b(scheduledTick2);
                } else {
                    this.e.remove(chunkPos);
                }
            }
        });
        this.h.removeIf(predicate);
        this.g.removeIf(predicate);
    }

    public void a(StructureBoundingBox box, BaseBlockPosition offset) {
        this.a(this, box, offset);
    }

    public void a(TickListServer<T> scheduler, StructureBoundingBox box, BaseBlockPosition offset) {
        ArrayList list = new ArrayList();
        Predicate<NextTickListEntry> predicate = tick -> box.b(tick.b());
        scheduler.h.stream().filter(predicate).forEach(list::add);
        scheduler.g.stream().filter(predicate).forEach(list::add);
        scheduler.a(box, (long chunkPos, LevelChunkTicks<T> chunkTickScheduler) -> chunkTickScheduler.d().filter(predicate).forEach(list::add));
        LongSummaryStatistics longSummaryStatistics = list.stream().mapToLong(NextTickListEntry::e).summaryStatistics();
        long l2 = longSummaryStatistics.getMin();
        long m2 = longSummaryStatistics.getMax();
        list.forEach(tick -> this.a(new NextTickListEntry(tick.a(), tick.b().a(offset), tick.c(), tick.d(), tick.e() - l2 + m2 + 1L)));
    }

    @Override
    public int a() {
        return this.d.values().stream().mapToInt(TickList::a).sum();
    }

    @FunctionalInterface
    static interface a<T> {
        public void accept(long var1, LevelChunkTicks<T> var3);
    }
}

