/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import io.papermc.paper.chunk.system.RegionizedPlayerChunkLoader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.util.ExceptionSuppressor;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;

public class Main {
    public static boolean useJline = true;
    public static boolean useConsole = true;

    public static void main(String[] args) {
        String warnWhenLegacyFormattingDetected = String.join((CharSequence)".", "net", "kyori", "adventure", "text", "warnWhenLegacyFormattingDetected");
        if (System.getProperty("jdk.nio.maxCachedBufferSize") == null) {
            System.setProperty("jdk.nio.maxCachedBufferSize", "262144");
        }
        OptionParser parser = new OptionParser(){
            {
                this.acceptsAll(Main.asList("?", "help"), "Show the help");
                this.acceptsAll(Main.asList("c", "config"), "Properties file to use").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("server.properties"), (Object[])new File[0]).describedAs("Properties file");
                this.acceptsAll(Main.asList("P", "plugins"), "Plugin directory to use").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("plugins"), (Object[])new File[0]).describedAs("Plugin directory");
                this.acceptsAll(Main.asList("h", "host", "server-ip"), "Host to listen on").withRequiredArg().ofType(String.class).describedAs("Hostname or IP");
                this.acceptsAll(Main.asList("W", "world-dir", "universe", "world-container"), "World container").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]).describedAs("Directory containing worlds");
                this.acceptsAll(Main.asList("w", "world", "level-name"), "World name").withRequiredArg().ofType(String.class).describedAs("World name");
                this.acceptsAll(Main.asList("p", "port", "server-port"), "Port to listen on").withRequiredArg().ofType(Integer.class).describedAs("Port");
                this.accepts("serverId", "Server ID").withRequiredArg();
                this.accepts("jfrProfile", "Enable JFR profiling");
                this.accepts("pidFile", "pid File").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
                this.acceptsAll(Main.asList("o", "online-mode"), "Whether to use online authentication").withRequiredArg().ofType(Boolean.class).describedAs("Authentication");
                this.acceptsAll(Main.asList("s", "size", "max-players"), "Maximum amount of players").withRequiredArg().ofType(Integer.class).describedAs("Server size");
                this.acceptsAll(Main.asList("d", "date-format"), "Format of the date to display in the console (for log entries)").withRequiredArg().ofType(SimpleDateFormat.class).describedAs("Log date format");
                this.acceptsAll(Main.asList("log-pattern"), "Specfies the log filename pattern").withRequiredArg().ofType(String.class).defaultsTo((Object)"server.log", (Object[])new String[0]).describedAs("Log filename");
                this.acceptsAll(Main.asList("log-limit"), "Limits the maximum size of the log file (0 = unlimited)").withRequiredArg().ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]).describedAs("Max log size");
                this.acceptsAll(Main.asList("log-count"), "Specified how many log files to cycle through").withRequiredArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]).describedAs("Log count");
                this.acceptsAll(Main.asList("log-append"), "Whether to append to the log file").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]).describedAs("Log append");
                this.acceptsAll(Main.asList("log-strip-color"), "Strips color codes from log file");
                this.acceptsAll(Main.asList("b", "bukkit-settings"), "File for bukkit settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("bukkit.yml"), (Object[])new File[0]).describedAs("Yml file");
                this.acceptsAll(Main.asList("C", "commands-settings"), "File for command settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("commands.yml"), (Object[])new File[0]).describedAs("Yml file");
                this.acceptsAll(Main.asList("forceUpgrade"), "Whether to force a world upgrade");
                this.acceptsAll(Main.asList("eraseCache"), "Whether to force cache erase during world upgrade");
                this.accepts("safeMode", "Loads level with vanilla datapack only");
                this.acceptsAll(Main.asList("nogui"), "Disables the graphical console");
                this.acceptsAll(Main.asList("nojline"), "Disables jline and emulates the vanilla console");
                this.acceptsAll(Main.asList("noconsole"), "Disables the console");
                this.acceptsAll(Main.asList("v", "version"), "Show the CraftBukkit Version");
                this.acceptsAll(Main.asList("demo"), "Demo mode");
                this.acceptsAll(Main.asList("initSettings"), "Only create configuration files and then exit");
                this.acceptsAll(Main.asList("S", "spigot-settings"), "File for spigot settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("spigot.yml"), (Object[])new File[0]).describedAs("Yml file");
                this.acceptsAll(Main.asList("paper-dir", "paper-settings-directory"), "Directory for Paper settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("config"), (Object[])new File[0]).describedAs("Config directory");
                this.acceptsAll(Main.asList("paper", "paper-settings"), "File for Paper settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("paper.yml"), (Object[])new File[0]).describedAs("Yml file");
                this.acceptsAll(Main.asList("add-plugin", "add-extra-plugin-jar"), "Specify paths to extra plugin jars to be loaded in addition to those in the plugins folder. This argument can be specified multiple times, once for each extra plugin jar path.").withRequiredArg().ofType(File.class).defaultsTo((Object[])new File[0]).describedAs("Jar file");
                this.acceptsAll(Main.asList("purpur", "purpur-settings"), "File for purpur settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("purpur.yml"), (Object[])new File[0]).describedAs("Yml file");
                this.acceptsAll(Main.asList("pufferfish", "pufferfish-settings"), "File for pufferfish settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("pufferfish.yml"), (Object[])new File[0]).describedAs("Yml file");
                this.acceptsAll(Main.asList("server-name"), "Name of the server").withRequiredArg().ofType(String.class).defaultsTo((Object)"Unknown Server", (Object[])new String[0]).describedAs("Name");
            }
        };
        OptionSet options = null;
        Main.tryPreloadClass("org.apache.logging.log4j.core.Core");
        Main.tryPreloadClass("org.apache.logging.log4j.core.appender.AsyncAppender");
        Main.tryPreloadClass("org.apache.logging.log4j.core.Appender");
        Main.tryPreloadClass("org.apache.logging.log4j.core.ContextDataInjector");
        Main.tryPreloadClass("org.apache.logging.log4j.core.Filter");
        Main.tryPreloadClass("org.apache.logging.log4j.core.ErrorHandler");
        Main.tryPreloadClass("org.apache.logging.log4j.core.LogEvent");
        Main.tryPreloadClass("org.apache.logging.log4j.core.Logger");
        Main.tryPreloadClass("org.apache.logging.log4j.core.LoggerContext");
        Main.tryPreloadClass("org.apache.logging.log4j.core.LogEventListener");
        Main.tryPreloadClass("org.apache.logging.log4j.core.AbstractLogEvent");
        Main.tryPreloadClass("org.apache.logging.log4j.message.AsynchronouslyFormattable");
        Main.tryPreloadClass("org.apache.logging.log4j.message.FormattedMessage");
        Main.tryPreloadClass("org.apache.logging.log4j.message.ParameterizedMessage");
        Main.tryPreloadClass("org.apache.logging.log4j.message.Message");
        Main.tryPreloadClass("org.apache.logging.log4j.message.MessageFactory");
        Main.tryPreloadClass("org.apache.logging.log4j.message.TimestampMessage");
        Main.tryPreloadClass("org.apache.logging.log4j.message.SimpleMessage");
        Main.tryPreloadClass("org.apache.logging.log4j.core.async.AsyncLogger");
        Main.tryPreloadClass("org.apache.logging.log4j.core.async.AsyncLoggerContext");
        Main.tryPreloadClass("org.apache.logging.log4j.core.async.AsyncQueueFullPolicy");
        Main.tryPreloadClass("org.apache.logging.log4j.core.async.AsyncLoggerDisruptor");
        Main.tryPreloadClass("org.apache.logging.log4j.core.async.RingBufferLogEvent");
        Main.tryPreloadClass("org.apache.logging.log4j.core.async.DisruptorUtil");
        Main.tryPreloadClass("org.apache.logging.log4j.core.async.RingBufferLogEventHandler");
        Main.tryPreloadClass("org.apache.logging.log4j.core.impl.ThrowableProxy");
        Main.tryPreloadClass("org.apache.logging.log4j.core.impl.ExtendedClassInfo");
        Main.tryPreloadClass("org.apache.logging.log4j.core.impl.ExtendedStackTraceElement");
        try {
            options = parser.parse(args);
        }
        catch (OptionException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
        }
        if (options == null || options.has("?")) {
            try {
                parser.printHelpOn((OutputStream)System.out);
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (options.has("v")) {
            System.out.println(CraftServer.class.getPackage().getImplementationVersion());
        } else {
            boolean isOldVersion;
            String path = new File(".").getAbsolutePath();
            if (path.contains("!") || path.contains("+")) {
                System.err.println("Cannot run server in a directory with ! or + in the pathname. Please rename the affected folders and try again.");
                return;
            }
            boolean skip = Boolean.getBoolean("Paper.IgnoreJavaVersion");
            float javaVersion = Float.parseFloat(System.getProperty("java.class.version"));
            boolean bl = isOldVersion = (double)javaVersion < 61.0;
            if (!skip && isOldVersion) {
                System.err.println("Unsupported Java detected (" + javaVersion + "). This version of Minecraft requires at least Java 17. Check your Java version with the command 'java -version'. For more info see https://docs.papermc.io/misc/java-install");
                return;
            }
            String javaVersionName = System.getProperty("java.version");
            boolean isPreRelease = javaVersionName.contains("-");
            if (!skip && isPreRelease) {
                System.err.println("Unsupported Java detected (" + javaVersionName + "). You are running an unsupported, non official, version. Only general availability versions of Java are supported. Please update your Java version. See https://docs.papermc.io/paper/faq#unsupported-java-detected-what-do-i-do for more information.");
                return;
            }
            if (skip && (isOldVersion || isPreRelease)) {
                System.err.println("Unsupported Java detected (" + javaVersionName + "), but the check was skipped. Proceed with caution! ");
            }
            try {
                if (options.has("nojline")) {
                    System.setProperty("terminal.jline", "false");
                    useJline = false;
                }
                if (options.has("noconsole")) {
                    useConsole = false;
                    useJline = false;
                    System.setProperty("terminal.jline", "false");
                }
                RuntimeMXBean runtimeMX = ManagementFactory.getRuntimeMXBean();
                OperatingSystemMXBean osMX = ManagementFactory.getOperatingSystemMXBean();
                if (runtimeMX != null && osMX != null) {
                    String javaInfo = "Java " + runtimeMX.getSpecVersion() + " (" + runtimeMX.getVmName() + " " + runtimeMX.getVmVersion() + ")";
                    String osInfo = "Host: " + osMX.getName() + " " + osMX.getVersion() + " (" + osMX.getArch() + ")";
                    System.out.println("System Info: " + javaInfo + " " + osInfo);
                } else {
                    System.out.println("Unable to read system info");
                }
                System.setProperty("library.jansi.version", "Paper");
                System.out.println("Loading libraries, please wait...");
                net.minecraft.server.Main.main(options);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
            Main.tryPreloadClass("com.destroystokyo.paper.util.SneakyThrow");
            Main.tryPreloadClass("com.google.common.collect.Iterators$PeekingImpl");
            Main.tryPreloadClass("com.google.common.collect.MapMakerInternalMap$Values");
            Main.tryPreloadClass("com.google.common.collect.MapMakerInternalMap$ValueIterator");
            Main.tryPreloadClass("com.google.common.collect.MapMakerInternalMap$WriteThroughEntry");
            Main.tryPreloadClass("com.google.common.collect.Iterables");
            for (int i2 = 1; i2 <= 15; ++i2) {
                Main.tryPreloadClass("com.google.common.collect.Iterables$" + i2, false);
            }
            Main.tryPreloadClass("org.apache.commons.lang3.mutable.MutableBoolean");
            Main.tryPreloadClass("org.apache.commons.lang3.mutable.MutableInt");
            Main.tryPreloadClass("org.jline.terminal.impl.MouseSupport");
            Main.tryPreloadClass("org.jline.terminal.impl.MouseSupport$1");
            Main.tryPreloadClass("org.jline.terminal.Terminal$MouseTracking");
            Main.tryPreloadClass("co.aikar.timings.TimingHistory");
            Main.tryPreloadClass("co.aikar.timings.TimingHistory$MinuteReport");
            Main.tryPreloadClass("io.netty.channel.AbstractChannelHandlerContext");
            Main.tryPreloadClass("io.netty.channel.AbstractChannelHandlerContext$11");
            Main.tryPreloadClass("io.netty.channel.AbstractChannelHandlerContext$12");
            Main.tryPreloadClass("io.netty.channel.AbstractChannel$AbstractUnsafe$8");
            Main.tryPreloadClass("io.netty.util.concurrent.DefaultPromise");
            Main.tryPreloadClass("io.netty.util.concurrent.DefaultPromise$1");
            Main.tryPreloadClass("io.netty.util.internal.PromiseNotificationUtil");
            Main.tryPreloadClass("io.netty.util.internal.SystemPropertyUtil");
            Main.tryPreloadClass("org.bukkit.craftbukkit.v1_20_R3.scheduler.CraftScheduler");
            Main.tryPreloadClass("org.bukkit.craftbukkit.v1_20_R3.scheduler.CraftScheduler$1");
            Main.tryPreloadClass("org.bukkit.craftbukkit.v1_20_R3.scheduler.CraftScheduler$2");
            Main.tryPreloadClass("org.bukkit.craftbukkit.v1_20_R3.scheduler.CraftScheduler$3");
            Main.tryPreloadClass("org.bukkit.craftbukkit.v1_20_R3.scheduler.CraftScheduler$4");
            Main.tryPreloadClass("org.slf4j.helpers.MessageFormatter");
            Main.tryPreloadClass("org.slf4j.helpers.FormattingTuple");
            Main.tryPreloadClass("org.slf4j.helpers.BasicMarker");
            Main.tryPreloadClass("org.slf4j.helpers.Util");
            Main.tryPreloadClass("com.destroystokyo.paper.event.player.PlayerConnectionCloseEvent");
            Main.tryPreloadClass("com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent");
            Main.tryPreloadClass(LightEngineLayerEventListener.Void.class.getName());
            Main.tryPreloadClass(LightEngineLayerEventListener.class.getName());
            Main.tryPreloadClass(ExceptionSuppressor.class.getName());
            Main.tryPreloadClass(RegionizedPlayerChunkLoader.PlayerChunkLoaderData.class.getName());
        }
    }

    private static void tryPreloadClass(String className) {
        Main.tryPreloadClass(className, true);
    }

    private static void tryPreloadClass(String className, boolean printError) {
        block2: {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e2) {
                if (!printError) break block2;
                System.err.println("An expected class  " + className + " was not found for preloading: " + e2.getMessage());
            }
        }
    }

    private static List<String> asList(String ... params) {
        return Arrays.asList(params);
    }

    static {
        System.setProperty("java.util.logging.manager", "io.papermc.paper.log.CustomLogManager");
    }
}

