/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.joml.Vector3f;

public abstract class CraftParticle<D>
implements Keyed {
    private static final Registry<CraftParticle<?>> CRAFT_PARTICLE_REGISTRY = new CraftParticleRegistry(CraftRegistry.getMinecraftRegistry(Registries.S));
    private final NamespacedKey key;
    private final net.minecraft.core.particles.Particle<?> particle;
    private final Class<D> clazz;

    public static Particle minecraftToBukkit(net.minecraft.core.particles.Particle<?> minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.S);
        Particle bukkit = (Particle)Registry.PARTICLE_TYPE.get(CraftNamespacedKey.fromMinecraft(registry.c(minecraft).orElseThrow().a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static net.minecraft.core.particles.Particle<?> bukkitToMinecraft(Particle bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (net.minecraft.core.particles.Particle)CraftRegistry.getMinecraftRegistry(Registries.S).b(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static <D> ParticleParam createParticleParam(Particle particle, D data) {
        Preconditions.checkArgument((particle != null ? 1 : 0) != 0);
        CraftParticle craftParticle = (CraftParticle)CRAFT_PARTICLE_REGISTRY.get(particle.getKey());
        Preconditions.checkArgument((craftParticle != null ? 1 : 0) != 0);
        return craftParticle.createParticleParam(data);
    }

    public static <T> T convertLegacy(T object) {
        if (object instanceof MaterialData) {
            MaterialData mat = (MaterialData)object;
            return (T)CraftBlockData.fromData(CraftMagicNumbers.getBlock(mat));
        }
        return object;
    }

    public static Particle convertLegacy(Particle particle) {
        return switch (particle) {
            case Particle.LEGACY_BLOCK_DUST -> Particle.BLOCK_DUST;
            case Particle.LEGACY_FALLING_DUST -> Particle.FALLING_DUST;
            case Particle.LEGACY_BLOCK_CRACK -> Particle.BLOCK_CRACK;
            default -> particle;
        };
    }

    public CraftParticle(NamespacedKey key, net.minecraft.core.particles.Particle<?> particle, Class<D> clazz) {
        this.key = key;
        this.particle = particle;
        this.clazz = clazz;
    }

    public net.minecraft.core.particles.Particle<?> getHandle() {
        return this.particle;
    }

    public abstract ParticleParam createParticleParam(D var1);

    public NamespacedKey getKey() {
        return this.key;
    }

    public static class CraftParticleRegistry
    extends CraftRegistry<CraftParticle<?>, net.minecraft.core.particles.Particle<?>> {
        private static final Map<NamespacedKey, BiFunction<NamespacedKey, net.minecraft.core.particles.Particle<?>, CraftParticle<?>>> PARTICLE_MAP = new HashMap();
        private static final BiFunction<NamespacedKey, net.minecraft.core.particles.Particle<?>, CraftParticle<?>> VOID_FUNCTION = (name, particle) -> new CraftParticle<Void>(name, particle, Void.class){

            @Override
            public ParticleParam createParticleParam(Void data) {
                return (ParticleType)this.getHandle();
            }
        };

        private static void add(String name, BiFunction<NamespacedKey, net.minecraft.core.particles.Particle<?>, CraftParticle<?>> function) {
            PARTICLE_MAP.put(NamespacedKey.fromString((String)name), function);
        }

        public CraftParticleRegistry(IRegistry<net.minecraft.core.particles.Particle<?>> minecraftRegistry) {
            super(CraftParticle.class, minecraftRegistry, null);
        }

        @Override
        public CraftParticle<?> createBukkit(NamespacedKey namespacedKey, net.minecraft.core.particles.Particle<?> particle) {
            if (particle == null) {
                return null;
            }
            BiFunction<NamespacedKey, net.minecraft.core.particles.Particle<?>, CraftParticle<?>> function = PARTICLE_MAP.getOrDefault(namespacedKey, VOID_FUNCTION);
            return function.apply(namespacedKey, particle);
        }

        static {
            BiFunction<NamespacedKey, net.minecraft.core.particles.Particle<?>, CraftParticle<?>> dustOptionsFunction = (name, particle) -> new CraftParticle<Particle.DustOptions>(name, particle, Particle.DustOptions.class){

                @Override
                public ParticleParam createParticleParam(Particle.DustOptions data) {
                    Color color = data.getColor();
                    return new ParticleParamRedstone(new Vector3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f), data.getSize());
                }
            };
            BiFunction<NamespacedKey, net.minecraft.core.particles.Particle<?>, CraftParticle<?>> itemStackFunction = (name, particle) -> new CraftParticle<ItemStack>(name, particle, ItemStack.class){

                @Override
                public ParticleParam createParticleParam(ItemStack data) {
                    return new ParticleParamItem(this.getHandle(), CraftItemStack.asNMSCopy(data));
                }
            };
            BiFunction<NamespacedKey, net.minecraft.core.particles.Particle<?>, CraftParticle<?>> blockDataFunction = (name, particle) -> new CraftParticle<BlockData>(name, particle, BlockData.class){

                @Override
                public ParticleParam createParticleParam(BlockData data) {
                    return new ParticleParamBlock(this.getHandle(), ((CraftBlockData)data).getState());
                }
            };
            BiFunction<NamespacedKey, net.minecraft.core.particles.Particle<?>, CraftParticle<?>> dustTransitionFunction = (name, particle) -> new CraftParticle<Particle.DustTransition>(name, particle, Particle.DustTransition.class){

                @Override
                public ParticleParam createParticleParam(Particle.DustTransition data) {
                    Color from = data.getColor();
                    Color to = data.getToColor();
                    return new DustColorTransitionOptions(new Vector3f((float)from.getRed() / 255.0f, (float)from.getGreen() / 255.0f, (float)from.getBlue() / 255.0f), new Vector3f((float)to.getRed() / 255.0f, (float)to.getGreen() / 255.0f, (float)to.getBlue() / 255.0f), data.getSize());
                }
            };
            BiFunction<NamespacedKey, net.minecraft.core.particles.Particle<?>, CraftParticle<?>> vibrationFunction = (name, particle) -> new CraftParticle<Vibration>(name, particle, Vibration.class){

                @Override
                public ParticleParam createParticleParam(Vibration data) {
                    PositionSource source;
                    if (data.getDestination() instanceof Vibration.Destination.BlockDestination) {
                        Location destination = ((Vibration.Destination.BlockDestination)data.getDestination()).getLocation();
                        source = new BlockPositionSource(CraftLocation.toBlockPosition(destination));
                    } else if (data.getDestination() instanceof Vibration.Destination.EntityDestination) {
                        Entity destination = ((CraftEntity)((Vibration.Destination.EntityDestination)data.getDestination()).getEntity()).getHandle();
                        source = new EntityPositionSource(destination, destination.cI());
                    } else {
                        throw new IllegalArgumentException("Unknown vibration destination " + data.getDestination());
                    }
                    return new VibrationParticleOption(source, data.getArrivalTime());
                }
            };
            BiFunction<NamespacedKey, net.minecraft.core.particles.Particle<?>, CraftParticle<?>> floatFunction = (name, particle) -> new CraftParticle<Float>(name, particle, Float.class){

                @Override
                public ParticleParam createParticleParam(Float data) {
                    return new SculkChargeParticleOptions(data.floatValue());
                }
            };
            BiFunction<NamespacedKey, net.minecraft.core.particles.Particle<?>, CraftParticle<?>> integerFunction = (name, particle) -> new CraftParticle<Integer>(name, particle, Integer.class){

                @Override
                public ParticleParam createParticleParam(Integer data) {
                    return new ShriekParticleOption(data);
                }
            };
            CraftParticleRegistry.add("dust", dustOptionsFunction);
            CraftParticleRegistry.add("item", itemStackFunction);
            CraftParticleRegistry.add("block", blockDataFunction);
            CraftParticleRegistry.add("falling_dust", blockDataFunction);
            CraftParticleRegistry.add("dust_color_transition", dustTransitionFunction);
            CraftParticleRegistry.add("vibration", vibrationFunction);
            CraftParticleRegistry.add("sculk_charge", floatFunction);
            CraftParticleRegistry.add("shriek", integerFunction);
            CraftParticleRegistry.add("block_marker", blockDataFunction);
        }
    }
}

