/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import com.destroystokyo.paper.HeightmapType;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import io.papermc.paper.math.Position;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.StackWalkerUtil;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.sound.Sound;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Color;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FeatureFlag;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameEvent;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_20_R3.CraftChunk;
import org.bukkit.craftbukkit.v1_20_R3.CraftEffect;
import org.bukkit.craftbukkit.v1_20_R3.CraftFeatureFlag;
import org.bukkit.craftbukkit.v1_20_R3.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_20_R3.CraftHeightMap;
import org.bukkit.craftbukkit.v1_20_R3.CraftParticle;
import org.bukkit.craftbukkit.v1_20_R3.CraftRaid;
import org.bukkit.craftbukkit.v1_20_R3.CraftRegionAccessor;
import org.bukkit.craftbukkit.v1_20_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftSound;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBiome;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R3.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.generator.structure.CraftGeneratedStructure;
import org.bukkit.craftbukkit.v1_20_R3.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.metadata.BlockMetadataStore;
import org.bukkit.craftbukkit.v1_20_R3.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_20_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftBiomeSearchResult;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftRayTraceResult;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftStructureSearchResult;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftVector;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BiomeSearchResult;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.StructureSearchResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.AsyncCatcher;

public class CraftWorld
extends CraftRegionAccessor
implements World {
    public static final int CUSTOM_DIMENSION_OFFSET = 10;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private static final ChunkStatus[] REGEN_CHUNK_STATUSES = new ChunkStatus[]{ChunkStatus.f, ChunkStatus.g, ChunkStatus.h, ChunkStatus.i, ChunkStatus.j, ChunkStatus.k};
    private final WorldServer world;
    private WorldBorder worldBorder;
    private World.Environment environment;
    private final CraftServer server = (CraftServer)Bukkit.getServer();
    private final ChunkGenerator generator;
    private final BiomeProvider biomeProvider;
    private final List<BlockPopulator> populators = new ArrayList<BlockPopulator>();
    private final BlockMetadataStore blockMetadata = new BlockMetadataStore(this);
    private final Object2IntOpenHashMap<SpawnCategory> spawnCategoryLimit = new Object2IntOpenHashMap();
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private Pointers adventure$pointers;
    private static final Random rand = new Random();
    private static Map<String, GameRules.GameRuleKey<?>> gamerules;
    private static Map<String, GameRules.GameRuleDefinition<?>> gameruleDefinitions;
    private final World.Spigot spigot = new World.Spigot(){

        public LightningStrike strikeLightning(Location loc, boolean isSilent) {
            return CraftWorld.this.strikeLightning(loc);
        }

        public LightningStrike strikeLightningEffect(Location loc, boolean isSilent) {
            return CraftWorld.this.strikeLightningEffect(loc);
        }
    };

    public int getEntityCount() {
        int ret = 0;
        for (net.minecraft.world.entity.Entity entity : this.world.G().a()) {
            if (!entity.isChunkLoaded()) continue;
            ++ret;
        }
        return ret;
    }

    public int getTileEntityCount() {
        int size = 0;
        for (PlayerChunk playerchunk : ChunkSystem.getVisibleChunkHolders(this.world)) {
            net.minecraft.world.level.chunk.Chunk chunk = playerchunk.d();
            if (chunk == null) continue;
            size += chunk.k.size();
        }
        return size;
    }

    public int getTickableTileEntityCount() {
        return this.world.r.size();
    }

    public int getChunkCount() {
        int ret = 0;
        for (PlayerChunk chunkHolder : ChunkSystem.getVisibleChunkHolders(this.world)) {
            if (chunkHolder.d() == null) continue;
            ++ret;
        }
        return ret;
    }

    public int getPlayerCount() {
        return this.world.x().size();
    }

    public BiomeProvider vanillaBiomeProvider() {
        ChunkProviderServer serverCache = this.getHandle().I;
        final WorldChunkManager biomeSource = serverCache.g().c();
        final Climate.Sampler sampler = serverCache.i().b();
        final List<Biome> possibleBiomes = biomeSource.c().stream().map(biome -> CraftBiome.minecraftHolderToBukkit(biome)).toList();
        return new BiomeProvider(){

            public Biome getBiome(WorldInfo worldInfo, int x2, int y2, int z2) {
                return CraftBiome.minecraftHolderToBukkit(biomeSource.getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2, sampler));
            }

            public List<Biome> getBiomes(WorldInfo worldInfo) {
                return possibleBiomes;
            }
        };
    }

    public boolean hasStructureAt(Position position, Structure structure) {
        return this.world.a().a(MCUtil.toBlockPos(position), ResourceKey.a(Registries.aD, CraftNamespacedKey.toMinecraft(structure.getKey()))).b();
    }

    public CraftWorld(WorldServer world, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env) {
        this.world = world;
        this.generator = gen;
        this.biomeProvider = biomeProvider;
        this.environment = env;
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.setSpawnLimit(spawnCategory, this.world.paperConfig().entities.spawning.spawnLimits.getInt((Object)CraftSpawnCategory.toNMS(spawnCategory)));
        }
    }

    public org.bukkit.block.Block getBlockAt(int x2, int y2, int z2) {
        return CraftBlock.at(this.world, new BlockPosition(x2, y2, z2));
    }

    public int getHighestBlockYAt(int x2, int z2, HeightmapType heightmap) throws UnsupportedOperationException {
        this.getChunkAt(x2 >> 4, z2 >> 4);
        switch (heightmap) {
            case LIGHT_BLOCKING: {
                throw new UnsupportedOperationException();
            }
            case ANY: {
                return this.world.a(HeightMap.Type.b, x2, z2);
            }
            case SOLID: {
                return this.world.a(HeightMap.Type.d, x2, z2);
            }
            case SOLID_OR_LIQUID: {
                return this.world.a(HeightMap.Type.e, x2, z2);
            }
            case SOLID_OR_LIQUID_NO_LEAVES: {
                return this.world.a(HeightMap.Type.f, x2, z2);
            }
        }
        throw new UnsupportedOperationException();
    }

    public Location getSpawnLocation() {
        BlockPosition spawn = this.world.T();
        float yaw = this.world.U();
        return CraftLocation.toBukkit(spawn, (World)this, yaw, 0.0f);
    }

    public boolean setSpawnLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        return this.equals(location.getWorld()) ? this.setSpawnLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getYaw()) : false;
    }

    public boolean setSpawnLocation(int x2, int y2, int z2, float angle) {
        try {
            this.world.a(new BlockPosition(x2, y2, z2), angle);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public boolean setSpawnLocation(int x2, int y2, int z2) {
        return this.setSpawnLocation(x2, y2, z2, 0.0f);
    }

    private static void warnUnsafeChunk(String reason, int x2, int z2) {
        if (x2 > 1875000 || z2 > 1875000 || x2 < -1875000 || z2 < -1875000) {
            JavaPlugin plugin = StackWalkerUtil.getFirstPluginCaller();
            if (plugin != null) {
                plugin.getLogger().warning("Plugin is %s at (%s, %s), this might cause issues.".formatted(reason, x2, z2));
            }
            if (MinecraftServer.getServer().isDebugging()) {
                TraceUtil.dumpTraceForThread("Dangerous chunk retrieval");
            }
        }
    }

    public Chunk getChunkAt(int x2, int z2) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk", x2, z2);
        net.minecraft.world.level.chunk.Chunk chunk = this.world.l().getChunkAtIfLoadedImmediately(x2, z2);
        if (chunk == null) {
            this.addTicket(x2, z2);
            chunk = this.world.l().a(x2, z2, true);
        }
        return new CraftChunk(chunk);
    }

    @NotNull
    public Chunk getChunkAt(int x2, int z2, boolean generate) {
        if (generate) {
            return this.getChunkAt(x2, z2);
        }
        return new CraftChunk(this.getHandle(), x2, z2);
    }

    private void addTicket(int x2, int z2) {
        MCUtil.MAIN_EXECUTOR.execute(() -> this.world.l().a(TicketType.PLUGIN, new ChunkCoordIntPair(x2, z2), 0, Unit.a));
    }

    public Chunk getChunkAt(org.bukkit.block.Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"null block");
        return this.getChunkAt(block.getX() >> 4, block.getZ() >> 4);
    }

    public boolean isChunkLoaded(int x2, int z2) {
        return this.world.l().isChunkLoaded(x2, z2);
    }

    public boolean isChunkGenerated(int x2, int z2) {
        if (!Bukkit.isPrimaryThread()) {
            return CompletableFuture.supplyAsync(() -> this.isChunkGenerated(x2, z2), this.world.l().g).join();
        }
        IChunkAccess chunk = this.world.l().getChunkAtImmediately(x2, z2);
        if (chunk == null) {
            chunk = this.world.l().a.getUnloadingChunk(x2, z2);
        }
        if (chunk != null) {
            return chunk instanceof ProtoChunkExtension || chunk instanceof net.minecraft.world.level.chunk.Chunk;
        }
        try {
            return this.world.l().a.getChunkStatusOnDisk(new ChunkCoordIntPair(x2, z2)) == ChunkStatus.n;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Chunk[] getLoadedChunks() {
        List<PlayerChunk> chunks = ChunkSystem.getVisibleChunkHolders(this.world);
        return (Chunk[])chunks.stream().map(PlayerChunk::getFullChunkNow).filter(Objects::nonNull).map(CraftChunk::new).toArray(Chunk[]::new);
    }

    public void loadChunk(int x2, int z2) {
        this.loadChunk(x2, z2, true);
    }

    public boolean unloadChunk(Chunk chunk) {
        return this.unloadChunk(chunk.getX(), chunk.getZ());
    }

    public boolean unloadChunk(int x2, int z2) {
        return this.unloadChunk(x2, z2, true);
    }

    public boolean unloadChunk(int x2, int z2, boolean save) {
        return this.unloadChunk0(x2, z2, save);
    }

    public boolean unloadChunkRequest(int x2, int z2) {
        AsyncCatcher.catchOp("chunk unload");
        if (this.isChunkLoaded(x2, z2)) {
            this.world.l().b(TicketType.PLUGIN, new ChunkCoordIntPair(x2, z2), 0, Unit.a);
        }
        return true;
    }

    private boolean unloadChunk0(int x2, int z2, boolean save) {
        AsyncCatcher.catchOp("chunk unload");
        if (!this.isChunkLoaded(x2, z2)) {
            return true;
        }
        net.minecraft.world.level.chunk.Chunk chunk = this.world.d(x2, z2);
        chunk.a(!save);
        this.unloadChunkRequest(x2, z2);
        this.world.l().purgeUnload();
        return !this.isChunkLoaded(x2, z2);
    }

    public boolean regenerateChunk(int x2, int z2) {
        AsyncCatcher.catchOp("chunk regenerate");
        CraftWorld.warnUnsafeChunk("regenerating a faraway chunk", x2, z2);
        WorldServer serverLevel = this.world;
        ChunkProviderServer serverChunkCache = serverLevel.l();
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(x2, z2);
        net.minecraft.world.level.chunk.Chunk levelChunk = serverChunkCache.a(chunkPos.e, chunkPos.f, true);
        for (BlockPosition blockPos : BlockPosition.b(chunkPos.d(), serverLevel.J_(), chunkPos.e(), chunkPos.f(), serverLevel.al() - 1, chunkPos.g())) {
            levelChunk.d(blockPos);
            serverLevel.a(blockPos, Blocks.a.o(), 16);
        }
        for (ChunkStatus chunkStatus : REGEN_CHUNK_STATUSES) {
            ArrayList<IChunkAccess> list = new ArrayList<IChunkAccess>();
            int range = Math.max(1, chunkStatus.e());
            for (int chunkX = chunkPos.f - range; chunkX <= chunkPos.f + range; ++chunkX) {
                for (int chunkZ = chunkPos.e - range; chunkZ <= chunkPos.e + range; ++chunkZ) {
                    IChunkAccess chunkAccess = serverChunkCache.a(chunkZ, chunkX, chunkStatus.d(), true);
                    if (chunkAccess instanceof ProtoChunkExtension) {
                        ProtoChunkExtension accessProtoChunk = (ProtoChunkExtension)chunkAccess;
                        chunkAccess = new ProtoChunkExtension(accessProtoChunk.C(), true);
                    } else if (chunkAccess instanceof net.minecraft.world.level.chunk.Chunk) {
                        net.minecraft.world.level.chunk.Chunk accessLevelChunk = (net.minecraft.world.level.chunk.Chunk)chunkAccess;
                        chunkAccess = new ProtoChunkExtension(accessLevelChunk, true);
                    }
                    list.add(chunkAccess);
                }
            }
            CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> future = chunkStatus.a(Runnable::run, serverLevel, serverChunkCache.g(), serverLevel.q(), serverChunkCache.a(), chunk -> {
                throw new UnsupportedOperationException("Not creating full chunks here");
            }, list);
            serverChunkCache.g.c(future::isDone);
            if (chunkStatus != ChunkStatus.g) continue;
            future.join().left().ifPresent(chunk -> net.minecraft.world.level.levelgen.HeightMap.a(chunk, ChunkStatus.b));
        }
        for (BlockPosition blockPos : BlockPosition.b(chunkPos.d(), serverLevel.J_(), chunkPos.e(), chunkPos.f(), serverLevel.al() - 1, chunkPos.g())) {
            serverChunkCache.a(blockPos);
        }
        HashSet<ChunkCoordIntPair> chunksToRelight = new HashSet<ChunkCoordIntPair>(9);
        for (int chunkX = chunkPos.e - 1; chunkX <= chunkPos.e + 1; ++chunkX) {
            for (int chunkZ = chunkPos.f - 1; chunkZ <= chunkPos.f + 1; ++chunkZ) {
                chunksToRelight.add(new ChunkCoordIntPair(chunkX, chunkZ));
            }
        }
        serverChunkCache.a().relight(chunksToRelight, pos -> {}, relit -> {});
        return true;
    }

    public boolean refreshChunk(int x2, int z2) {
        PlayerChunk playerChunk = this.world.l().a.b(ChunkCoordIntPair.c(x2, z2));
        if (playerChunk == null) {
            return false;
        }
        net.minecraft.world.level.chunk.Chunk chunk = playerChunk.getSendingChunk();
        if (chunk == null) {
            return false;
        }
        List<EntityPlayer> playersInRange = playerChunk.x.a(playerChunk.l(), false);
        if (playersInRange.isEmpty()) {
            return true;
        }
        HashMap<Object, ClientboundLevelChunkWithLightPacket> refreshPackets = new HashMap<Object, ClientboundLevelChunkWithLightPacket>();
        for (EntityPlayer player : playersInRange) {
            if (player.c == null) continue;
            Boolean shouldModify = chunk.F().chunkPacketBlockController.shouldModify(player, chunk);
            player.c.b(refreshPackets.computeIfAbsent(shouldModify, s2 -> new ClientboundLevelChunkWithLightPacket(chunk, this.world.z_(), null, null, (Boolean)s2)));
        }
        return true;
    }

    public boolean isChunkInUse(int x2, int z2) {
        return this.isChunkLoaded(x2, z2);
    }

    public boolean loadChunk(int x2, int z2, boolean generate) {
        AsyncCatcher.catchOp("chunk load");
        CraftWorld.warnUnsafeChunk("loading a faraway chunk", x2, z2);
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(x2, z2);
        IChunkAccess immediate = this.world.l().getChunkAtIfLoadedImmediately(x2, z2);
        if (immediate != null) {
            return true;
        }
        if (!generate) {
            RegionFile file;
            immediate = this.world.l().a.getUnloadingChunk(x2, z2);
            if (immediate != null) {
                if (!(immediate instanceof ProtoChunkExtension) && !(immediate instanceof net.minecraft.world.level.chunk.Chunk)) {
                    return false;
                }
                this.world.l().a(TicketType.PLUGIN, chunkPos, 0, Unit.a);
                this.world.d(x2, z2);
                return true;
            }
            try {
                file = this.world.l().a.regionFileCache.getRegionFile(chunkPos, false);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            ChunkStatus status = file.getStatusIfCached(x2, z2);
            if (!file.e(chunkPos) || status != null && status != ChunkStatus.n) {
                return false;
            }
            IChunkAccess chunk = this.world.l().a(x2, z2, ChunkStatus.c, true);
            if (!(chunk instanceof ProtoChunkExtension) && !(chunk instanceof net.minecraft.world.level.chunk.Chunk)) {
                return false;
            }
        }
        this.world.l().a(TicketType.PLUGIN, chunkPos, 0, Unit.a);
        this.world.l().a(x2, z2, ChunkStatus.n, true);
        return true;
    }

    public boolean isChunkLoaded(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        return this.isChunkLoaded(chunk.getX(), chunk.getZ());
    }

    public void loadChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        this.loadChunk(chunk.getX(), chunk.getZ());
    }

    public boolean addPluginChunkTicket(int x2, int z2, Plugin plugin) {
        CraftWorld.warnUnsafeChunk("adding a faraway chunk ticket", x2, z2);
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"null plugin");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (Object)"plugin is not enabled");
        PlayerChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.l().a.F;
        if (chunkDistanceManager.addRegionTicketAtDistance(TicketType.PLUGIN_TICKET, new ChunkCoordIntPair(x2, z2), 2, plugin)) {
            this.getChunkAt(x2, z2);
            return true;
        }
        return false;
    }

    public boolean removePluginChunkTicket(int x2, int z2, Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        PlayerChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.l().a.F;
        return chunkDistanceManager.removeRegionTicketAtDistance(TicketType.PLUGIN_TICKET, new ChunkCoordIntPair(x2, z2), 2, plugin);
    }

    public void removePluginChunkTickets(Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        PlayerChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.l().a.F;
        chunkDistanceManager.removeAllTicketsFor(TicketType.PLUGIN_TICKET, 31, plugin);
    }

    public Collection<Plugin> getPluginChunkTickets(int x2, int z2) {
        PlayerChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.l().a.F;
        return chunkDistanceManager.getChunkHolderManager().getPluginChunkTickets(x2, z2);
    }

    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets() {
        HashMap<Plugin, ImmutableList.Builder> ret = new HashMap<Plugin, ImmutableList.Builder>();
        PlayerChunkMap.ChunkDistanceManager chunkDistanceManager = this.world.l().a.F;
        for (Long2ObjectMap.Entry chunkTickets : chunkDistanceManager.getChunkHolderManager().getTicketsCopy().long2ObjectEntrySet()) {
            long chunkKey = chunkTickets.getLongKey();
            ArraySetSorted tickets = (ArraySetSorted)chunkTickets.getValue();
            Chunk chunk = null;
            for (Ticket ticket : tickets) {
                if (ticket.a() != TicketType.PLUGIN_TICKET) continue;
                if (chunk == null) {
                    chunk = this.getChunkAt(ChunkCoordIntPair.a(chunkKey), ChunkCoordIntPair.b(chunkKey));
                }
                ret.computeIfAbsent((Plugin)ticket.c, key -> ImmutableList.builder()).add((Object)chunk);
            }
        }
        return (Map)ret.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableList.Builder)entry.getValue()).build()));
    }

    @NotNull
    public Collection<Chunk> getIntersectingChunks(@NotNull BoundingBox boundingBox) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        int minX = NumberConversions.floor((double)boundingBox.getMinX()) >> 4;
        int maxX = NumberConversions.floor((double)boundingBox.getMaxX()) >> 4;
        int minZ = NumberConversions.floor((double)boundingBox.getMinZ()) >> 4;
        int maxZ = NumberConversions.floor((double)boundingBox.getMaxZ()) >> 4;
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                chunks.add(this.getChunkAt(x2, z2, false));
            }
        }
        return chunks;
    }

    public boolean isChunkForceLoaded(int x2, int z2) {
        return this.getHandle().w().contains(ChunkCoordIntPair.c(x2, z2));
    }

    public void setChunkForceLoaded(int x2, int z2, boolean forced) {
        CraftWorld.warnUnsafeChunk("forceloading a faraway chunk", x2, z2);
        this.getHandle().a(x2, z2, forced);
    }

    public Collection<Chunk> getForceLoadedChunks() {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        LongIterator longIterator = this.getHandle().w().iterator();
        while (longIterator.hasNext()) {
            long coord = (Long)longIterator.next();
            chunks.add(this.getChunkAt(ChunkCoordIntPair.a(coord), ChunkCoordIntPair.b(coord)));
        }
        return Collections.unmodifiableCollection(chunks);
    }

    @Override
    public WorldServer getHandle() {
        return this.world;
    }

    public Item dropItem(Location loc, ItemStack item) {
        return this.dropItem(loc, item, null);
    }

    public Item dropItem(Location loc, ItemStack item, Consumer<? super Item> function) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        EntityItem entity = new EntityItem(this.world, loc.getX(), loc.getY(), loc.getZ(), CraftItemStack.asNMSCopy(item));
        Item itemEntity = (Item)entity.getBukkitEntity();
        entity.h = 10;
        if (function != null) {
            function.accept((Item)itemEntity);
        }
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return itemEntity;
    }

    public Item dropItemNaturally(Location loc, ItemStack item) {
        return this.dropItemNaturally(loc, item, null);
    }

    public Item dropItemNaturally(Location loc, ItemStack item, Consumer<? super Item> function) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        double xs = (double)(this.world.z.i() * 0.5f) + 0.25;
        double ys = (double)(this.world.z.i() * 0.5f) + 0.25;
        double zs = (double)(this.world.z.i() * 0.5f) + 0.25;
        loc = loc.clone().add(xs, ys, zs);
        return this.dropItem(loc, item, function);
    }

    public Arrow spawnArrow(Location loc, Vector velocity, float speed, float spread) {
        return this.spawnArrow(loc, velocity, speed, spread, Arrow.class);
    }

    public <T extends AbstractArrow> T spawnArrow(Location loc, Vector velocity, float speed, float spread, Class<T> clazz) {
        EntityArrow arrow;
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"Vector cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz Entity for the arrow cannot be null");
        if (TippedArrow.class.isAssignableFrom(clazz)) {
            arrow = EntityTypes.e.a(this.world);
            ((Arrow)arrow.getBukkitEntity()).setBasePotionType(PotionType.WATER);
        } else {
            arrow = SpectralArrow.class.isAssignableFrom(clazz) ? (EntityArrow)EntityTypes.aS.a(this.world) : (Trident.class.isAssignableFrom(clazz) ? (EntityArrow)EntityTypes.bc.a(this.world) : (EntityArrow)EntityTypes.e.a(this.world));
        }
        arrow.b(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        arrow.c(velocity.getX(), velocity.getY(), velocity.getZ(), speed, spread);
        this.world.b(arrow);
        return (T)((AbstractArrow)arrow.getBukkitEntity());
    }

    public LightningStrike strikeLightning(Location loc) {
        return this.strikeLightning0(loc, false);
    }

    public LightningStrike strikeLightningEffect(Location loc) {
        return this.strikeLightning0(loc, true);
    }

    private LightningStrike strikeLightning0(Location loc, boolean isVisual) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        EntityLightning lightning = EntityTypes.aj.a(this.world);
        lightning.e(loc.getX(), loc.getY(), loc.getZ());
        lightning.isEffect = isVisual;
        this.world.strikeLightning(lightning, LightningStrikeEvent.Cause.CUSTOM);
        return (LightningStrike)lightning.getBukkitEntity();
    }

    public Location findLightningRod(Location location) {
        return this.world.E(MCUtil.toBlockPosition(location)).map(blockPos -> MCUtil.toLocation(this.world, blockPos).subtract(0.0, 1.0, 0.0)).orElse(null);
    }

    public Location findLightningTarget(Location location) {
        BlockPosition pos = this.world.findLightningTargetAround(MCUtil.toBlockPosition(location), true);
        return pos == null ? null : MCUtil.toLocation(this.world, pos);
    }

    public boolean generateTree(Location loc, TreeType type) {
        return this.generateTree(loc, rand, type);
    }

    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        this.world.captureTreeGeneration = true;
        this.world.captureBlockStates = true;
        boolean grownTree = this.generateTree(loc, type);
        this.world.captureBlockStates = false;
        this.world.captureTreeGeneration = false;
        if (grownTree) {
            for (BlockState blockState : this.world.capturedBlockStates.values()) {
                BlockPosition position = ((CraftBlockState)blockState).getPosition();
                IBlockData oldBlock = this.world.a_(position);
                int flag = ((CraftBlockState)blockState).getFlag();
                delegate.setBlockData(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getBlockData());
                IBlockData newBlock = this.world.a_(position);
                this.world.notifyAndUpdatePhysics(position, null, oldBlock, newBlock, newBlock, flag, 512);
            }
            this.world.capturedBlockStates.clear();
            return true;
        }
        this.world.capturedBlockStates.clear();
        return false;
    }

    public String getName() {
        return this.world.K.g();
    }

    public UUID getUID() {
        return this.world.uuid;
    }

    @Override
    public NamespacedKey getKey() {
        return CraftNamespacedKey.fromMinecraft(this.world.ae().a());
    }

    public String toString() {
        return "CraftWorld{name=" + this.getName() + "}";
    }

    public long getTime() {
        long time = this.getFullTime() % 24000L;
        if (time < 0L) {
            time += 24000L;
        }
        return time;
    }

    public void setTime(long time) {
        long margin = (time - this.getFullTime()) % 24000L;
        if (margin < 0L) {
            margin += 24000L;
        }
        this.setFullTime(this.getFullTime() + margin);
    }

    public long getFullTime() {
        return this.world.Y();
    }

    public void setFullTime(long time) {
        TimeSkipEvent event = new TimeSkipEvent((World)this, TimeSkipEvent.SkipReason.CUSTOM, time - this.world.Y());
        this.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.world.b(this.world.Y() + event.getSkipAmount());
        for (Player p2 : this.getPlayers()) {
            CraftPlayer cp = (CraftPlayer)p2;
            if (cp.getHandle().c == null) continue;
            cp.getHandle().c.b(new PacketPlayOutUpdateTime(cp.getHandle().dM().X(), cp.getHandle().getPlayerTime(), cp.getHandle().dM().Z().b(GameRules.l)));
        }
    }

    public boolean isDayTime() {
        return this.getHandle().P();
    }

    public long getGameTime() {
        return this.world.A.e();
    }

    public boolean createExplosion(double x2, double y2, double z2, float power) {
        return this.createExplosion(x2, y2, z2, power, false, true);
    }

    public boolean createExplosion(double x2, double y2, double z2, float power, boolean setFire) {
        return this.createExplosion(x2, y2, z2, power, setFire, true);
    }

    public boolean createExplosion(double x2, double y2, double z2, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(x2, y2, z2, power, setFire, breakBlocks, null);
    }

    public boolean createExplosion(double x2, double y2, double z2, float power, boolean setFire, boolean breakBlocks, Entity source) {
        return !this.world.a((net.minecraft.world.entity.Entity)(source == null ? null : ((CraftEntity)source).getHandle()), (double)x2, (double)y2, (double)z2, (float)power, (boolean)setFire, (World.a)(breakBlocks ? World.a.c : World.a.a)).wasCanceled;
    }

    public boolean createExplosion(Entity source, Location loc, float power, boolean setFire, boolean breakBlocks) {
        return !this.world.a((net.minecraft.world.entity.Entity)(source != null ? ((CraftEntity)source).getHandle() : null), (double)loc.getX(), (double)loc.getY(), (double)loc.getZ(), (float)power, (boolean)setFire, (World.a)(breakBlocks ? World.a.c : World.a.a)).wasCanceled;
    }

    public boolean createExplosion(Location loc, float power) {
        return this.createExplosion(loc, power, false);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire) {
        return this.createExplosion(loc, power, setFire, true);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(loc, power, setFire, breakBlocks, null);
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks, Entity source) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location is null");
        Preconditions.checkArgument((boolean)this.equals(loc.getWorld()), (Object)"Location not in world");
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire, breakBlocks, source);
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public org.bukkit.block.Block getBlockAt(Location location) {
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public Chunk getChunkAt(Location location) {
        return this.getChunkAt(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public ChunkGenerator getGenerator() {
        return this.generator;
    }

    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    public List<BlockPopulator> getPopulators() {
        return this.populators;
    }

    @NotNull
    public <T extends LivingEntity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, @NotNull CreatureSpawnEvent.SpawnReason spawnReason, boolean randomizeData, @Nullable Consumer<? super T> function) throws IllegalArgumentException {
        Preconditions.checkArgument((spawnReason != null ? 1 : 0) != 0, (Object)"Spawn reason cannot be null");
        return (T)((LivingEntity)this.spawn(location, clazz, function, spawnReason, randomizeData));
    }

    public org.bukkit.block.Block getHighestBlockAt(int x2, int z2) {
        return this.getBlockAt(x2, this.getHighestBlockYAt(x2, z2), z2);
    }

    public org.bukkit.block.Block getHighestBlockAt(Location location) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ());
    }

    @Override
    public int getHighestBlockYAt(int x2, int z2, HeightMap heightMap) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk", x2 >> 4, z2 >> 4);
        return this.world.d(x2 >> 4, z2 >> 4).a(CraftHeightMap.toNMS(heightMap), x2, z2);
    }

    public org.bukkit.block.Block getHighestBlockAt(int x2, int z2, HeightMap heightMap) {
        return this.getBlockAt(x2, this.getHighestBlockYAt(x2, z2, heightMap), z2);
    }

    public org.bukkit.block.Block getHighestBlockAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    public Biome getBiome(int x2, int z2) {
        return this.getBiome(x2, 0, z2);
    }

    public void setBiome(int x2, int z2, Biome bio) {
        for (int y2 = this.getMinHeight(); y2 < this.getMaxHeight(); ++y2) {
            this.setBiome(x2, y2, z2, bio);
        }
    }

    @Override
    public void setBiome(int x2, int y2, int z2, Holder<BiomeBase> bb) {
        net.minecraft.world.level.chunk.Chunk chunk;
        BlockPosition pos = new BlockPosition(x2, 0, z2);
        if (this.world.B(pos) && (chunk = this.world.m(pos)) != null) {
            chunk.setBiome(x2 >> 2, y2 >> 2, z2 >> 2, bb);
            chunk.a(true);
        }
    }

    public double getTemperature(int x2, int z2) {
        return this.getTemperature(x2, 0, z2);
    }

    public double getTemperature(int x2, int y2, int z2) {
        BlockPosition pos = new BlockPosition(x2, y2, z2);
        return this.world.getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2).a().f(pos);
    }

    public double getHumidity(int x2, int z2) {
        return this.getHumidity(x2, 0, z2);
    }

    public double getHumidity(int x2, int y2, int z2) {
        return this.world.getNoiseBiome((int)(x2 >> 2), (int)(y2 >> 2), (int)(z2 >> 2)).a().i.d();
    }

    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        return this.getEntitiesByClasses(classes);
    }

    @Override
    public Iterable<net.minecraft.world.entity.Entity> getNMSEntities() {
        return this.getHandle().G().a();
    }

    @Override
    public void addEntityToWorld(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().addFreshEntity(entity, reason);
    }

    @Override
    public void addEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().tryAddFreshEntityWithPassengers(entity, reason);
    }

    public Collection<Entity> getNearbyEntities(Location location, double x2, double y2, double z2) {
        return this.getNearbyEntities(location, x2, y2, z2, null);
    }

    public Collection<Entity> getNearbyEntities(Location location, double x2, double y2, double z2, Predicate<? super Entity> filter) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((boolean)this.equals(location.getWorld()), (Object)"Location cannot be in a different world");
        BoundingBox aabb = BoundingBox.of((Location)location, (double)x2, (double)y2, (double)z2);
        return this.getNearbyEntities(aabb, filter);
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox) {
        return this.getNearbyEntities(boundingBox, null);
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox, Predicate<? super Entity> filter) {
        AsyncCatcher.catchOp("getNearbyEntities");
        Preconditions.checkArgument((boundingBox != null ? 1 : 0) != 0, (Object)"BoundingBox cannot be null");
        AxisAlignedBB bb = new AxisAlignedBB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        List<net.minecraft.world.entity.Entity> entityList = this.getHandle().a((net.minecraft.world.entity.Entity)null, bb, (Predicate<? super net.minecraft.world.entity.Entity>)Predicates.alwaysTrue());
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
        for (net.minecraft.world.entity.Entity entity : entityList) {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (filter != null && !filter.test(bukkitEntity)) continue;
            bukkitEntityList.add(bukkitEntity);
        }
        return bukkitEntityList;
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance) {
        return this.rayTraceEntities(start, direction, maxDistance, null);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize) {
        return this.rayTraceEntities(start, direction, maxDistance, raySize, null);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, Predicate<? super Entity> filter) {
        return this.rayTraceEntities(start, direction, maxDistance, 0.0, filter);
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<? super Entity> filter) {
        return this.rayTraceEntities((Position)start, direction, maxDistance, raySize, filter);
    }

    public RayTraceResult rayTraceEntities(Position start, Vector direction, double maxDistance, double raySize, Predicate<? super Entity> filter) {
        Location location;
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((!(start instanceof Location) || this.equals((location = (Location)start).getWorld()) ? 1 : 0) != 0, (Object)"Location start cannot be in a different world");
        Preconditions.checkArgument((boolean)start.isFinite(), (Object)"Location start is not finite");
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) need to be greater than 0", (Object)direction.lengthSquared());
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir).expand(raySize);
        Collection<Entity> entities = this.getNearbyEntities(aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance) {
        return this.rayTraceBlocks(start, direction, maxDistance, FluidCollisionMode.NEVER, false);
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        return this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, false);
    }

    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        return this.rayTraceBlocks((Position)start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks, null);
    }

    public RayTraceResult rayTraceBlocks(Position start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, Predicate<? super org.bukkit.block.Block> canCollide) {
        Location location;
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((!(start instanceof Location) || this.equals((location = (Location)start).getWorld()) ? 1 : 0) != 0, (Object)"Location start cannot be in a different world");
        Preconditions.checkArgument((boolean)start.isFinite(), (Object)"Location start is not finite");
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) need to be greater than 0", (Object)direction.lengthSquared());
        Preconditions.checkArgument((fluidCollisionMode != null ? 1 : 0) != 0, (Object)"FluidCollisionMode cannot be null");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        Vec3D startPos = MCUtil.toVec3(start);
        Vec3D endPos = startPos.b(dir.getX(), dir.getY(), dir.getZ());
        MovingObjectPositionBlock nmsHitResult = this.getHandle().clip(new RayTrace(startPos, endPos, ignorePassableBlocks ? RayTrace.BlockCollisionOption.a : RayTrace.BlockCollisionOption.b, CraftFluidCollisionMode.toNMS(fluidCollisionMode), VoxelShapeCollision.a()), canCollide);
        return CraftRayTraceResult.fromNMS(this, nmsHitResult);
    }

    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<? super Entity> filter) {
        return this.rayTrace((Position)start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks, raySize, filter, null);
    }

    public RayTraceResult rayTrace(Position start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<? super Entity> filter, Predicate<? super org.bukkit.block.Block> canCollide) {
        RayTraceResult blockHit = this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks, canCollide);
        Vector startVec = null;
        double blockHitDistance = maxDistance;
        if (blockHit != null) {
            startVec = start.toVector();
            blockHitDistance = startVec.distance(blockHit.getHitPosition());
        }
        RayTraceResult entityHit = this.rayTraceEntities(start, direction, blockHitDistance, raySize, filter);
        if (blockHit == null) {
            return entityHit;
        }
        if (entityHit == null) {
            return blockHit;
        }
        double entityHitDistanceSquared = startVec.distanceSquared(entityHit.getHitPosition());
        if (entityHitDistanceSquared < blockHitDistance * blockHitDistance) {
            return entityHit;
        }
        return blockHit;
    }

    public List<Player> getPlayers() {
        ArrayList<Player> list = new ArrayList<Player>(this.world.x().size());
        for (EntityHuman entityHuman : this.world.x()) {
            CraftHumanEntity bukkitEntity = entityHuman.getBukkitEntity();
            if (bukkitEntity == null || !(bukkitEntity instanceof Player)) continue;
            list.add((Player)bukkitEntity);
        }
        return list;
    }

    public Entity getEntity(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        net.minecraft.world.entity.Entity entity = this.world.a(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void save() {
        AsyncCatcher.catchOp("world save");
        this.server.checkSaveState();
        boolean oldSave = this.world.e;
        this.world.e = false;
        this.world.a(null, false, false);
        this.world.e = oldSave;
    }

    public boolean isAutoSave() {
        return !this.world.e;
    }

    public void setAutoSave(boolean value) {
        this.world.e = !value;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.getHandle().o().setDifficulty(this.getHandle(), EnumDifficulty.a(difficulty.getValue()), true);
    }

    public Difficulty getDifficulty() {
        return Difficulty.getByValue((int)this.getHandle().ak().ordinal());
    }

    public int getViewDistance() {
        return this.getHandle().playerChunkLoader.getAPIViewDistance();
    }

    public int getSimulationDistance() {
        return this.getHandle().playerChunkLoader.getAPITickDistance();
    }

    public BlockMetadataStore getBlockMetadata() {
        return this.blockMetadata;
    }

    public boolean hasStorm() {
        return this.world.A.k();
    }

    public void setStorm(boolean hasStorm) {
        this.world.K.setRaining(hasStorm, WeatherChangeEvent.Cause.PLUGIN);
        this.setWeatherDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getWeatherDuration() {
        return this.world.K.l();
    }

    public void setWeatherDuration(int duration) {
        this.world.K.f(duration);
    }

    public boolean isThundering() {
        return this.world.A.i();
    }

    public void setThundering(boolean thundering) {
        this.world.K.setThundering(thundering, ThunderChangeEvent.Cause.PLUGIN);
        this.setThunderDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getThunderDuration() {
        return this.world.K.j();
    }

    public void setThunderDuration(int duration) {
        this.world.K.e(duration);
    }

    public boolean isClearWeather() {
        return !this.hasStorm() && !this.isThundering();
    }

    public void setClearWeatherDuration(int duration) {
        this.world.K.a(duration);
    }

    public int getClearWeatherDuration() {
        return this.world.K.h();
    }

    public long getSeed() {
        return this.world.C();
    }

    public boolean getPVP() {
        return this.world.pvpMode;
    }

    public void setPVP(boolean pvp) {
        this.world.pvpMode = pvp;
    }

    public void playEffect(Player player, Effect effect, int data) {
        this.playEffect(player.getLocation(), effect, data, 0);
    }

    public void playEffect(Location location, Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        this.playEffect(loc, effect, data, 64);
    }

    public <T> void playEffect(Location loc, Effect effect, T data, int radius) {
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null ? 1 : 0) != 0, (String)"Effect.%s does not have a valid Data", (Object)effect);
            Preconditions.checkArgument((boolean)effect.isApplicable(data), (String)"%s data cannot be used for the %s effect", (Object)data.getClass().getName(), (Object)effect);
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for the %s effect", (Object)effect);
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue, radius);
    }

    public void playEffect(Location location, Effect effect, int data, int radius) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"World of Location cannot be null");
        int packetData = effect.getId();
        PacketPlayOutWorldEvent packet = new PacketPlayOutWorldEvent(packetData, CraftLocation.toBlockPosition(location), data, false);
        radius *= radius;
        for (Player player : this.getPlayers()) {
            int distance;
            if (((CraftPlayer)player).getHandle().c == null || !location.getWorld().equals(player.getWorld()) || (distance = (int)player.getLocation().distanceSquared(location)) > radius) continue;
            ((CraftPlayer)player).getHandle().c.b(packet);
        }
    }

    public FallingBlock spawnFallingBlock(Location location, MaterialData data) throws IllegalArgumentException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"MaterialData cannot be null");
        return this.spawnFallingBlock(location, data.getItemType(), data.getData());
    }

    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isBlock(), (String)"Material.%s must be a block", (Object)material);
        EntityFallingBlock entity = new EntityFallingBlock(this.world, location.getX(), location.getY(), location.getZ(), CraftBlockType.bukkitToMinecraft(material).o());
        entity.b = 1;
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public FallingBlock spawnFallingBlock(Location location, BlockData data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        EntityFallingBlock entity = new EntityFallingBlock(this.world, location.getX(), location.getY(), location.getZ(), ((CraftBlockData)data).getState());
        entity.b = 1;
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public ChunkSnapshot getEmptyChunkSnapshot(int x2, int z2, boolean includeBiome, boolean includeBiomeTempRain) {
        return CraftChunk.getEmptyChunkSnapshot(x2, z2, this, includeBiome, includeBiomeTempRain);
    }

    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.world.b(allowMonsters, allowAnimals);
    }

    public boolean getAllowAnimals() {
        return this.world.l().k;
    }

    public boolean getAllowMonsters() {
        return this.world.l().j;
    }

    public int getMinHeight() {
        return this.world.J_();
    }

    public int getMaxHeight() {
        return this.world.al();
    }

    public int getLogicalHeight() {
        return this.world.E_().p();
    }

    public boolean isNatural() {
        return this.world.E_().j();
    }

    public boolean isBedWorks() {
        return this.world.E_().l();
    }

    public boolean hasSkyLight() {
        return this.world.E_().g();
    }

    public boolean hasCeiling() {
        return this.world.E_().h();
    }

    public boolean isPiglinSafe() {
        return this.world.E_().b();
    }

    public boolean isRespawnAnchorWorks() {
        return this.world.E_().m();
    }

    public boolean hasRaids() {
        return this.world.E_().c();
    }

    public boolean isUltraWarm() {
        return this.world.E_().i();
    }

    public int getSeaLevel() {
        return this.world.A_();
    }

    public boolean getKeepSpawnInMemory() {
        return this.world.keepSpawnInMemory;
    }

    public void setKeepSpawnInMemory(boolean keepLoaded) {
        if (keepLoaded == this.world.keepSpawnInMemory) {
            return;
        }
        this.world.keepSpawnInMemory = keepLoaded;
        BlockPosition chunkcoordinates = this.world.T();
        if (keepLoaded) {
            this.world.addTicketsForSpawn(this.world.paperConfig().spawn.keepSpawnLoadedRange * 16, chunkcoordinates);
        } else {
            this.world.removeTicketsForSpawn(this.world.paperConfig().spawn.keepSpawnLoadedRange * 16, chunkcoordinates);
        }
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftWorld other = (CraftWorld)obj;
        return this.getUID() == other.getUID();
    }

    public File getWorldFolder() {
        return this.world.convertable.a(SavedFile.l).toFile().getParentFile();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (Player player : this.getPlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getPlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public WorldType getWorldType() {
        return this.world.B() ? WorldType.FLAT : WorldType.NORMAL;
    }

    public boolean canGenerateStructures() {
        return this.world.K.A().c();
    }

    public boolean isHardcore() {
        return this.world.B_().n();
    }

    public void setHardcore(boolean hardcore) {
        this.world.K.g.c = hardcore;
    }

    @Deprecated
    public long getTicksPerAnimalSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.setTicksPerSpawns(SpawnCategory.ANIMAL, ticksPerAnimalSpawns);
    }

    @Deprecated
    public long getTicksPerMonsterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.MONSTER);
    }

    @Deprecated
    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.setTicksPerSpawns(SpawnCategory.MONSTER, ticksPerMonsterSpawns);
    }

    @Deprecated
    public long getTicksPerWaterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public void setTicksPerWaterSpawns(int ticksPerWaterSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_ANIMAL, ticksPerWaterSpawns);
    }

    @Deprecated
    public long getTicksPerWaterAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public void setTicksPerWaterAmbientSpawns(int ticksPerWaterAmbientSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_AMBIENT, ticksPerWaterAmbientSpawns);
    }

    @Deprecated
    public long getTicksPerWaterUndergroundCreatureSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated
    public void setTicksPerWaterUndergroundCreatureSpawns(int ticksPerWaterUndergroundCreatureSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE, ticksPerWaterUndergroundCreatureSpawns);
    }

    @Deprecated
    public long getTicksPerAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.AMBIENT);
    }

    @Deprecated
    public void setTicksPerAmbientSpawns(int ticksPerAmbientSpawns) {
        this.setTicksPerSpawns(SpawnCategory.AMBIENT, ticksPerAmbientSpawns);
    }

    public void setTicksPerSpawns(SpawnCategory spawnCategory, int ticksPerCategorySpawn) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        this.world.ticksPerSpawnCategory.put((Object)spawnCategory, (long)ticksPerCategorySpawn);
    }

    public long getTicksPerSpawns(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.world.ticksPerSpawnCategory.getLong((Object)spawnCategory);
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getWorldMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getWorldMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getWorldMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getWorldMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Deprecated
    public int getMonsterSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.MONSTER);
    }

    @Deprecated
    public void setMonsterSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.MONSTER, limit);
    }

    @Deprecated
    public int getAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.ANIMAL);
    }

    @Deprecated
    public void setAnimalSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.ANIMAL, limit);
    }

    @Deprecated
    public int getWaterAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_ANIMAL);
    }

    @Deprecated
    public void setWaterAnimalSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_ANIMAL, limit);
    }

    @Deprecated
    public int getWaterAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_AMBIENT);
    }

    @Deprecated
    public void setWaterAmbientSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_AMBIENT, limit);
    }

    @Deprecated
    public int getWaterUndergroundCreatureSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Deprecated
    public void setWaterUndergroundCreatureSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE, limit);
    }

    @Deprecated
    public int getAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.AMBIENT);
    }

    @Deprecated
    public void setAmbientSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.AMBIENT, limit);
    }

    public int getSpawnLimit(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.getSpawnLimitUnsafe(spawnCategory);
    }

    public final int getSpawnLimitUnsafe(SpawnCategory spawnCategory) {
        int limit = this.spawnCategoryLimit.getOrDefault((Object)spawnCategory, -1);
        if (limit < 0) {
            limit = this.server.getSpawnLimitUnsafe(spawnCategory);
        }
        return limit;
    }

    public void setSpawnLimit(SpawnCategory spawnCategory, int limit) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        this.spawnCategoryLimit.put((Object)spawnCategory, limit);
    }

    public void playNote(@NotNull Location loc, @NotNull Instrument instrument, @NotNull Note note) {
        this.playSound(loc, instrument.getSound(), SoundCategory.RECORDS, 3.0f, note.getPitch());
    }

    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().z.g());
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().z.g());
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        AsyncCatcher.catchOp("play sound");
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x2 = loc.getX();
        double y2 = loc.getY();
        double z2 = loc.getZ();
        this.getHandle().a(null, x2, y2, z2, CraftSound.bukkitToMinecraft(sound), net.minecraft.sounds.SoundCategory.valueOf(category.name()), volume, pitch, seed);
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch, long seed) {
        AsyncCatcher.catchOp("play sound");
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x2 = loc.getX();
        double y2 = loc.getY();
        double z2 = loc.getZ();
        PacketPlayOutNamedSoundEffect packet = new PacketPlayOutNamedSoundEffect(Holder.a(SoundEffect.a(new MinecraftKey(sound))), net.minecraft.sounds.SoundCategory.valueOf(category.name()), x2, y2, z2, volume, pitch, seed);
        this.world.o().ae().a(null, x2, y2, z2, volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.world.ae(), packet);
    }

    public void playSound(Entity entity, Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, String sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().z.g());
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().z.g());
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        CraftEntity craftEntity;
        block5: {
            block4: {
                AsyncCatcher.catchOp("play sound");
                if (!(entity instanceof CraftEntity)) break block4;
                craftEntity = (CraftEntity)entity;
                if (entity.getWorld() == this && sound != null && category != null) break block5;
            }
            return;
        }
        PacketPlayOutEntitySound packet = new PacketPlayOutEntitySound(CraftSound.bukkitToMinecraftHolder(sound), net.minecraft.sounds.SoundCategory.valueOf(category.name()), craftEntity.getHandle(), volume, pitch, seed);
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)this.getHandle().l().a.K.get(entity.getEntityId());
        if (entityTracker != null) {
            entityTracker.b(packet);
        }
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch, long seed) {
        CraftEntity craftEntity;
        block5: {
            block4: {
                AsyncCatcher.catchOp("play sound");
                if (!(entity instanceof CraftEntity)) break block4;
                craftEntity = (CraftEntity)entity;
                if (entity.getWorld() == this && sound != null && category != null) break block5;
            }
            return;
        }
        PacketPlayOutEntitySound packet = new PacketPlayOutEntitySound(Holder.a(SoundEffect.a(new MinecraftKey(sound))), net.minecraft.sounds.SoundCategory.valueOf(category.name()), craftEntity.getHandle(), volume, pitch, seed);
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)this.getHandle().l().a.K.get(entity.getEntityId());
        if (entityTracker != null) {
            entityTracker.b(packet);
        }
    }

    public void playSound(net.kyori.adventure.sound.Sound sound) {
        AsyncCatcher.catchOp("play sound");
        long seed = sound.seed().orElseGet(this.world.F_()::g);
        for (EntityPlayer player : this.getHandle().x()) {
            player.c.b(PaperAdventure.asSoundPacket(sound, player.dr(), player.dt(), player.dx(), seed, null));
        }
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, double x2, double y2, double z2) {
        AsyncCatcher.catchOp("play sound");
        PaperAdventure.asSoundPacket(sound, x2, y2, z2, sound.seed().orElseGet(this.world.F_()::g), this.playSound0(x2, y2, z2));
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, Sound.Emitter emitter) {
        AsyncCatcher.catchOp("play sound");
        long seed = sound.seed().orElseGet(this.getHandle().F_()::g);
        if (emitter == Sound.Emitter.self()) {
            for (EntityPlayer player : this.getHandle().x()) {
                player.c.b(PaperAdventure.asSoundPacket(sound, player, seed, null));
            }
        } else if (emitter instanceof CraftEntity) {
            CraftEntity craftEntity = (CraftEntity)emitter;
            net.minecraft.world.entity.Entity entity = craftEntity.getHandle();
            PaperAdventure.asSoundPacket(sound, entity, seed, this.playSound0(entity.dr(), entity.dt(), entity.dx()));
        } else {
            throw new IllegalArgumentException("Sound emitter must be an Entity or self(), but was: " + emitter);
        }
    }

    private BiConsumer<Packet<?>, Float> playSound0(double x2, double y2, double z2) {
        return (packet, distance) -> this.world.o().ae().a(null, x2, y2, z2, distance.floatValue(), this.world.ae(), (Packet<?>)packet);
    }

    public static synchronized Map<String, GameRules.GameRuleKey<?>> getGameRulesNMS() {
        if (gamerules != null) {
            return gamerules;
        }
        final HashMap gamerules = new HashMap();
        GameRules.a(new GameRules.GameRuleVisitor(){

            @Override
            public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                gamerules.put(key.a(), key);
            }
        });
        CraftWorld.gamerules = gamerules;
        return CraftWorld.gamerules;
    }

    public static synchronized Map<String, GameRules.GameRuleDefinition<?>> getGameRuleDefinitions() {
        if (gameruleDefinitions != null) {
            return gameruleDefinitions;
        }
        final HashMap gameruleDefinitions = new HashMap();
        GameRules.a(new GameRules.GameRuleVisitor(){

            @Override
            public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                gameruleDefinitions.put(key.a(), type);
            }
        });
        CraftWorld.gameruleDefinitions = gameruleDefinitions;
        return CraftWorld.gameruleDefinitions;
    }

    public String getGameRuleValue(String rule) {
        if (rule == null) {
            return null;
        }
        Object value = this.getHandle().Z().a(CraftWorld.getGameRulesNMS().get(rule));
        return value != null ? ((GameRules.GameRuleValue)value).toString() : "";
    }

    public boolean setGameRuleValue(String rule, String value) {
        if (rule == null || value == null) {
            return false;
        }
        if (!this.isGameRule(rule)) {
            return false;
        }
        GameRule gameRule = GameRule.getByName((String)rule);
        WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)this, null, gameRule, value);
        if (!event.callEvent()) {
            return false;
        }
        Object handle = this.getHandle().Z().a(CraftWorld.getGameRulesNMS().get(rule));
        ((GameRules.GameRuleValue)handle).a(event.getValue());
        ((GameRules.GameRuleValue)handle).onChanged(this.getHandle());
        return true;
    }

    public String[] getGameRules() {
        return CraftWorld.getGameRulesNMS().keySet().toArray(new String[CraftWorld.getGameRulesNMS().size()]);
    }

    public boolean isGameRule(String rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"String rule cannot be null");
        Preconditions.checkArgument((!rule.isEmpty() ? 1 : 0) != 0, (Object)"String rule cannot be empty");
        return CraftWorld.getGameRulesNMS().containsKey(rule);
    }

    public <T> T getGameRuleValue(GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        return this.convert(rule, (GameRules.GameRuleValue<?>)this.getHandle().Z().a(CraftWorld.getGameRulesNMS().get(rule.getName())));
    }

    public <T> T getGameRuleDefault(GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        return this.convert(rule, (GameRules.GameRuleValue<?>)CraftWorld.getGameRuleDefinitions().get(rule.getName()).a());
    }

    public <T> boolean setGameRule(GameRule<T> rule, T newValue) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        Preconditions.checkArgument((newValue != null ? 1 : 0) != 0, (Object)"GameRule value cannot be null");
        if (!this.isGameRule(rule.getName())) {
            return false;
        }
        WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)this, null, rule, String.valueOf(newValue));
        if (!event.callEvent()) {
            return false;
        }
        Object handle = this.getHandle().Z().a(CraftWorld.getGameRulesNMS().get(rule.getName()));
        ((GameRules.GameRuleValue)handle).a(event.getValue());
        ((GameRules.GameRuleValue)handle).onChanged(this.getHandle());
        return true;
    }

    private <T> T convert(GameRule<T> rule, GameRules.GameRuleValue<?> value) {
        if (value == null) {
            return null;
        }
        if (value instanceof GameRules.GameRuleBoolean) {
            return rule.getType().cast(((GameRules.GameRuleBoolean)value).a());
        }
        if (value instanceof GameRules.GameRuleInt) {
            return rule.getType().cast(value.c());
        }
        throw new IllegalArgumentException("Invalid GameRule type (" + value + ") for GameRule " + rule.getName());
    }

    public WorldBorder getWorldBorder() {
        if (this.worldBorder == null) {
            this.worldBorder = new CraftWorldBorder(this);
        }
        return this.worldBorder;
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count) {
        this.spawnParticle(particle, x2, y2, z2, count, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, data, false);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, null, null, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    public <T> void spawnParticle(Particle particle, List<Player> receivers, Player sender, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        particle = CraftParticle.convertLegacy(particle);
        if ((data = CraftParticle.convertLegacy(data)) != null) {
            Preconditions.checkArgument((boolean)particle.getDataType().isInstance(data), (String)"data (%s) should be %s", data.getClass(), (Object)particle.getDataType());
        }
        this.getHandle().sendParticles(receivers == null ? this.getHandle().x() : receivers.stream().map(player -> ((CraftPlayer)player).getHandle()).collect(Collectors.toList()), sender != null ? ((CraftPlayer)sender).getHandle() : null, CraftParticle.createParticleParam(particle, data), x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, force);
    }

    @Deprecated
    public Location locateNearestStructure(Location origin, StructureType structureType, int radius, boolean findUnexplored) {
        StructureSearchResult result = null;
        if (StructureType.MINESHAFT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.MINESHAFT, radius, findUnexplored);
        } else if (StructureType.VILLAGE == structureType) {
            result = this.locateNearestStructure(origin, List.of(Structure.VILLAGE_DESERT, Structure.VILLAGE_PLAINS, Structure.VILLAGE_SAVANNA, Structure.VILLAGE_SNOWY, Structure.VILLAGE_TAIGA), radius, findUnexplored);
        } else if (StructureType.NETHER_FORTRESS == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.FORTRESS, radius, findUnexplored);
        } else if (StructureType.STRONGHOLD == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.STRONGHOLD, radius, findUnexplored);
        } else if (StructureType.JUNGLE_PYRAMID == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.JUNGLE_TEMPLE, radius, findUnexplored);
        } else if (StructureType.OCEAN_RUIN == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.OCEAN_RUIN, radius, findUnexplored);
        } else if (StructureType.DESERT_PYRAMID == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.DESERT_PYRAMID, radius, findUnexplored);
        } else if (StructureType.IGLOO == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.IGLOO, radius, findUnexplored);
        } else if (StructureType.SWAMP_HUT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.SWAMP_HUT, radius, findUnexplored);
        } else if (StructureType.OCEAN_MONUMENT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.OCEAN_MONUMENT, radius, findUnexplored);
        } else if (StructureType.END_CITY == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.END_CITY, radius, findUnexplored);
        } else if (StructureType.WOODLAND_MANSION == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.WOODLAND_MANSION, radius, findUnexplored);
        } else if (StructureType.BURIED_TREASURE == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.BURIED_TREASURE, radius, findUnexplored);
        } else if (StructureType.SHIPWRECK == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.SHIPWRECK, radius, findUnexplored);
        } else if (StructureType.PILLAGER_OUTPOST == structureType) {
            result = this.locateNearestStructure(origin, Structure.PILLAGER_OUTPOST, radius, findUnexplored);
        } else if (StructureType.NETHER_FOSSIL == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.NETHER_FOSSIL, radius, findUnexplored);
        } else if (StructureType.RUINED_PORTAL == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.RUINED_PORTAL, radius, findUnexplored);
        } else if (StructureType.BASTION_REMNANT == structureType) {
            result = this.locateNearestStructure(origin, Structure.BASTION_REMNANT, radius, findUnexplored);
        }
        return result == null ? null : result.getLocation();
    }

    public StructureSearchResult locateNearestStructure(Location origin, org.bukkit.generator.structure.StructureType structureType, int radius, boolean findUnexplored) {
        ArrayList<Structure> structures = new ArrayList<Structure>();
        for (Structure structure : Registry.STRUCTURE) {
            if (structure.getStructureType() != structureType) continue;
            structures.add(structure);
        }
        return this.locateNearestStructure(origin, structures, radius, findUnexplored);
    }

    public StructureSearchResult locateNearestStructure(Location origin, Structure structure, int radius, boolean findUnexplored) {
        return this.locateNearestStructure(origin, List.of(structure), radius, findUnexplored);
    }

    public StructureSearchResult locateNearestStructure(Location origin, List<Structure> structures, int radius, boolean findUnexplored) {
        BlockPosition originPos = BlockPosition.a(origin.getX(), origin.getY(), origin.getZ());
        ArrayList<Holder<net.minecraft.world.level.levelgen.structure.Structure>> holders = new ArrayList<Holder<net.minecraft.world.level.levelgen.structure.Structure>>();
        for (Structure structure : structures) {
            holders.add(Holder.a(CraftStructure.bukkitToMinecraft(structure)));
        }
        Pair<BlockPosition, Holder<net.minecraft.world.level.levelgen.structure.Structure>> found = this.getHandle().l().g().a(this.getHandle(), HolderSet.a(holders), originPos, radius, findUnexplored);
        if (found == null) {
            return null;
        }
        return new CraftStructureSearchResult(CraftStructure.minecraftToBukkit((net.minecraft.world.level.levelgen.structure.Structure)((Holder)found.getSecond()).a()), CraftLocation.toBukkit((BlockPosition)found.getFirst(), (World)this));
    }

    public boolean isUltrawarm() {
        return this.getHandle().E_().i();
    }

    public double getCoordinateScale() {
        return this.getHandle().E_().k();
    }

    public boolean hasSkylight() {
        return this.getHandle().E_().g();
    }

    public boolean hasBedrockCeiling() {
        return this.getHandle().E_().g();
    }

    public boolean doesBedWork() {
        return this.getHandle().E_().l();
    }

    public boolean doesRespawnAnchorWork() {
        return this.getHandle().E_().m();
    }

    public boolean isFixedTime() {
        return this.getHandle().E_().a();
    }

    public Collection<Material> getInfiniburn() {
        return Sets.newHashSet((Iterator)Iterators.transform(BuiltInRegistries.e.c(this.getHandle().E_().q()).iterator(), blockHolder -> CraftBlockType.minecraftToBukkit((Block)blockHolder.a())));
    }

    public void sendGameEvent(Entity sourceEntity, GameEvent gameEvent, Vector position) {
        this.getHandle().a(sourceEntity != null ? ((CraftEntity)sourceEntity).getHandle() : null, BuiltInRegistries.a.a(CraftNamespacedKey.toMinecraft(gameEvent.getKey())), CraftVector.toBlockPos(position));
    }

    public BiomeSearchResult locateNearestBiome(Location origin, int radius, Biome ... biomes) {
        return this.locateNearestBiome(origin, radius, 32, 64, biomes);
    }

    public BiomeSearchResult locateNearestBiome(Location origin, int radius, int horizontalInterval, int verticalInterval, Biome ... biomes) {
        BlockPosition originPos = BlockPosition.a(origin.getX(), origin.getY(), origin.getZ());
        HashSet<Holder<BiomeBase>> holders = new HashSet<Holder<BiomeBase>>();
        for (Biome biome : biomes) {
            holders.add(CraftBiome.bukkitToMinecraftHolder(biome));
        }
        Climate.Sampler sampler = this.getHandle().l().i().b();
        Pair<BlockPosition, Holder<BiomeBase>> found = this.getHandle().l().g().c().a(originPos, radius, horizontalInterval, verticalInterval, holders::contains, sampler, this.getHandle());
        if (found == null) {
            return null;
        }
        return new CraftBiomeSearchResult(CraftBiome.minecraftHolderToBukkit((Holder)found.getSecond()), new Location((World)this, (double)((BlockPosition)found.getFirst()).u(), (double)((BlockPosition)found.getFirst()).v(), (double)((BlockPosition)found.getFirst()).w()));
    }

    public Raid locateNearestRaid(Location location, int radius) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (String)"Radius value (%s) cannot be negative", (int)radius);
        PersistentRaid persistentRaid = this.world.z();
        net.minecraft.world.entity.raid.Raid raid = persistentRaid.a(CraftLocation.toBlockPosition(location), radius * radius);
        return raid == null ? null : new CraftRaid(raid);
    }

    @Nullable
    public Raid getRaid(int id) {
        @Nullable net.minecraft.world.entity.raid.Raid nmsRaid = this.world.z().b.get(id);
        return nmsRaid != null ? new CraftRaid(nmsRaid) : null;
    }

    public List<Raid> getRaids() {
        PersistentRaid persistentRaid = this.world.z();
        return persistentRaid.b.values().stream().map(CraftRaid::new).collect(Collectors.toList());
    }

    public DragonBattle getEnderDragonBattle() {
        return this.getHandle().D() == null ? null : new CraftDragonBattle(this.getHandle().D());
    }

    public float getLocalDifficultyAt(Location location) {
        return this.getHandle().d_(MCUtil.toBlockPosition(location)).b();
    }

    public void sendBlockHighlight(Location location, int duration) {
        this.sendBlockHighlight(location, duration, "", 1677786880);
    }

    public void sendBlockHighlight(Location location, int duration, int argb) {
        this.sendBlockHighlight(location, duration, "", argb);
    }

    public void sendBlockHighlight(Location location, int duration, String text) {
        this.sendBlockHighlight(location, duration, text, 1677786880);
    }

    public void sendBlockHighlight(Location location, int duration, String text, int argb) {
        PacketDebug.a(this.getHandle(), MCUtil.toBlockPosition(location), text, argb, duration);
    }

    public void sendBlockHighlight(Location location, int duration, Color color, int transparency) {
        this.sendBlockHighlight(location, duration, "", color, transparency);
    }

    public void sendBlockHighlight(Location location, int duration, String text, Color color, int transparency) {
        if (transparency < 0 || transparency > 255) {
            throw new IllegalArgumentException("transparency is outside of 0-255 range");
        }
        this.sendBlockHighlight(location, duration, text, transparency << 24 | color.asRGB());
    }

    public void clearBlockHighlights() {
        PacketDebug.a(this.getHandle());
    }

    public Collection<GeneratedStructure> getStructures(int x2, int z2) {
        return this.getStructures(x2, z2, (net.minecraft.world.level.levelgen.structure.Structure struct) -> true);
    }

    public Collection<GeneratedStructure> getStructures(int x2, int z2, Structure structure) {
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"Structure cannot be null");
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.aD);
        MinecraftKey key = registry.b(CraftStructure.bukkitToMinecraft(structure));
        return this.getStructures(x2, z2, (net.minecraft.world.level.levelgen.structure.Structure struct) -> registry.b(struct).equals(key));
    }

    private List<GeneratedStructure> getStructures(int x2, int z2, Predicate<net.minecraft.world.level.levelgen.structure.Structure> predicate) {
        ArrayList<GeneratedStructure> structures = new ArrayList<GeneratedStructure>();
        for (StructureStart start : this.getHandle().a().a(new ChunkCoordIntPair(x2, z2), predicate)) {
            structures.add(new CraftGeneratedStructure(start));
        }
        return structures;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public Set<FeatureFlag> getFeatureFlags() {
        return CraftFeatureFlag.getFromNMS(this.getHandle().I()).stream().map(FeatureFlag.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    public void storeBukkitValues(NBTTagCompound c2) {
        if (!this.persistentDataContainer.isEmpty()) {
            c2.a("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
    }

    public void readBukkitValues(NBTBase c2) {
        if (c2 instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)c2);
        }
    }

    public World.Spigot spigot() {
        return this.spigot;
    }

    public CompletableFuture<Chunk> getChunkAtAsync(int x2, int z2, boolean gen, boolean urgent) {
        net.minecraft.world.level.chunk.Chunk immediate;
        CraftWorld.warnUnsafeChunk("getting a faraway chunk async", x2, z2);
        if (Bukkit.isPrimaryThread() && (immediate = this.world.l().getChunkAtIfLoadedImmediately(x2, z2)) != null) {
            return CompletableFuture.completedFuture(new CraftChunk(immediate));
        }
        PrioritisedExecutor.Priority priority = urgent ? PrioritisedExecutor.Priority.HIGHER : PrioritisedExecutor.Priority.NORMAL;
        CompletableFuture<Chunk> ret = new CompletableFuture<Chunk>();
        ChunkSystem.scheduleChunkLoad(this.getHandle(), x2, z2, gen, ChunkStatus.n, true, priority, c2 -> MinecraftServer.getServer().scheduleOnMain(() -> {
            net.minecraft.world.level.chunk.Chunk chunk = (net.minecraft.world.level.chunk.Chunk)c2;
            if (chunk != null) {
                this.addTicket(x2, z2);
            }
            ret.complete(chunk == null ? null : new CraftChunk(chunk));
        }));
        return ret;
    }

    public void setViewDistance(int viewDistance) {
        if (viewDistance < 2 || viewDistance > 32) {
            throw new IllegalArgumentException("View distance " + viewDistance + " is out of range of [2, 32]");
        }
        this.getHandle().I.a.a(viewDistance);
    }

    public void setSimulationDistance(int simulationDistance) {
        if (simulationDistance < 2 || simulationDistance > 32) {
            throw new IllegalArgumentException("Simulation distance " + simulationDistance + " is out of range of [2, 32]");
        }
        this.getHandle().I.a.setTickViewDistance(simulationDistance);
    }

    public int getSendViewDistance() {
        return this.getHandle().playerChunkLoader.getAPISendViewDistance();
    }

    public void setSendViewDistance(int viewDistance) {
        this.getHandle().I.a.setSendViewDistance(viewDistance);
    }

    public Pointers pointers() {
        if (this.adventure$pointers == null) {
            this.adventure$pointers = (Pointers)Pointers.builder().withDynamic(Identity.NAME, this::getName).withDynamic(Identity.UUID, this::getUID).build();
        }
        return this.adventure$pointers;
    }
}

