/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.attribute;

import com.google.common.base.Preconditions;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.v1_20_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftNamespacedKey;

public class CraftAttribute {
    public static Attribute minecraftToBukkit(AttributeBase minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.c);
        Attribute bukkit = (Attribute)Registry.ATTRIBUTE.get(CraftNamespacedKey.fromMinecraft(registry.c(minecraft).orElseThrow().a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static Attribute stringToBukkit(String bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        NamespacedKey key = NamespacedKey.fromString((String)bukkit);
        return key != null ? (Attribute)Registry.ATTRIBUTE.get(key) : null;
    }

    public static AttributeBase bukkitToMinecraft(Attribute bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (AttributeBase)CraftRegistry.getMinecraftRegistry(Registries.c).b(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }
}

