/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.block;

import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.world.ChestLock;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import org.bukkit.World;
import org.bukkit.block.Beacon;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftChatMessage;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftBeacon
extends CraftBlockEntityState<TileEntityBeacon>
implements Beacon {
    public CraftBeacon(World world, TileEntityBeacon tileEntity) {
        super(world, tileEntity);
    }

    protected CraftBeacon(CraftBeacon state) {
        super(state);
    }

    public Collection<LivingEntity> getEntitiesInRange() {
        this.ensureNoWorldGeneration();
        TileEntity tileEntity = this.getTileEntityFromWorld();
        if (tileEntity instanceof TileEntityBeacon) {
            TileEntityBeacon beacon = (TileEntityBeacon)tileEntity;
            List nms = TileEntityBeacon.getHumansInRange(beacon.i(), beacon.aB_(), beacon.n, beacon);
            ArrayList<LivingEntity> bukkit = new ArrayList<LivingEntity>(nms.size());
            for (EntityHuman human : nms) {
                bukkit.add(human.getBukkitEntity());
            }
            return bukkit;
        }
        return new ArrayList<LivingEntity>();
    }

    public int getTier() {
        return ((TileEntityBeacon)this.getSnapshot()).n;
    }

    public PotionEffect getPrimaryEffect() {
        return ((TileEntityBeacon)this.getSnapshot()).getPrimaryEffect();
    }

    public void setPrimaryEffect(PotionEffectType effect) {
        ((TileEntityBeacon)this.getSnapshot()).s = effect != null ? CraftPotionEffectType.bukkitToMinecraft(effect) : null;
    }

    public PotionEffect getSecondaryEffect() {
        return ((TileEntityBeacon)this.getSnapshot()).getSecondaryEffect();
    }

    public void setSecondaryEffect(PotionEffectType effect) {
        ((TileEntityBeacon)this.getSnapshot()).t = effect != null ? CraftPotionEffectType.bukkitToMinecraft(effect) : null;
    }

    public Component customName() {
        TileEntityBeacon be = (TileEntityBeacon)this.getSnapshot();
        return be.u != null ? PaperAdventure.asAdventure(be.u) : null;
    }

    public void customName(Component customName) {
        ((TileEntityBeacon)this.getSnapshot()).a(customName != null ? PaperAdventure.asVanilla(customName) : null);
    }

    public String getCustomName() {
        TileEntityBeacon beacon = (TileEntityBeacon)this.getSnapshot();
        return beacon.u != null ? CraftChatMessage.fromComponent(beacon.u) : null;
    }

    public void setCustomName(String name) {
        ((TileEntityBeacon)this.getSnapshot()).a(CraftChatMessage.fromStringOrNull(name));
    }

    public boolean isLocked() {
        return !((TileEntityBeacon)this.getSnapshot()).v.c.isEmpty();
    }

    public String getLock() {
        return ((TileEntityBeacon)this.getSnapshot()).v.c;
    }

    public void setLock(String key) {
        ((TileEntityBeacon)this.getSnapshot()).v = key == null ? ChestLock.a : new ChestLock(key);
    }

    @Override
    public CraftBeacon copy() {
        return new CraftBeacon(this);
    }

    public double getEffectRange() {
        return ((TileEntityBeacon)this.getSnapshot()).getEffectRange();
    }

    public void setEffectRange(double range) {
        ((TileEntityBeacon)this.getSnapshot()).setEffectRange(range);
    }

    public void resetEffectRange() {
        ((TileEntityBeacon)this.getSnapshot()).resetEffectRange();
    }
}

