/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.block;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.DecoratedPot;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftInventoryDecoratedPot;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftNamespacedKey;
import org.bukkit.inventory.DecoratedPotInventory;
import org.bukkit.loot.LootTable;

public class CraftDecoratedPot
extends CraftBlockEntityState<DecoratedPotBlockEntity>
implements DecoratedPot {
    public CraftDecoratedPot(World world, DecoratedPotBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftDecoratedPot(CraftDecoratedPot state) {
        super(state);
    }

    public DecoratedPotInventory getSnapshotInventory() {
        return new CraftInventoryDecoratedPot((IInventory)this.getSnapshot());
    }

    public DecoratedPotInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryDecoratedPot((IInventory)this.getTileEntity());
    }

    public void setLootTable(LootTable table) {
        this.setLootTable(table, this.getSeed());
    }

    public void setLootTable(LootTable table, long seed) {
        MinecraftKey key = table == null ? null : CraftNamespacedKey.toMinecraft(table.getKey());
        ((DecoratedPotBlockEntity)this.getSnapshot()).a(key, seed);
    }

    public LootTable getLootTable() {
        if (((DecoratedPotBlockEntity)this.getSnapshot()).az_() == null) {
            return null;
        }
        MinecraftKey key = ((DecoratedPotBlockEntity)this.getSnapshot()).az_();
        return Bukkit.getLootTable((NamespacedKey)CraftNamespacedKey.fromMinecraft(key));
    }

    public void setSeed(long seed) {
        ((DecoratedPotBlockEntity)this.getSnapshot()).a(seed);
    }

    public long getSeed() {
        return ((DecoratedPotBlockEntity)this.getSnapshot()).aA_();
    }

    public void setSherd(DecoratedPot.Side face, Material sherd) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        Preconditions.checkArgument((sherd == null || sherd == Material.BRICK || Tag.ITEMS_DECORATED_POT_SHERDS.isTagged((Keyed)sherd) ? 1 : 0) != 0, (String)"sherd is not a valid sherd material: %s", (Object)sherd);
        Item sherdItem = sherd != null ? CraftItemType.bukkitToMinecraft(sherd) : Items.qI;
        DecoratedPotBlockEntity.Decoration decorations = ((DecoratedPotBlockEntity)this.getSnapshot()).m();
        switch (face) {
            case BACK: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).l = new DecoratedPotBlockEntity.Decoration(sherdItem, decorations.c(), decorations.d(), decorations.e());
                break;
            }
            case LEFT: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).l = new DecoratedPotBlockEntity.Decoration(decorations.b(), sherdItem, decorations.d(), decorations.e());
                break;
            }
            case RIGHT: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).l = new DecoratedPotBlockEntity.Decoration(decorations.b(), decorations.c(), sherdItem, decorations.e());
                break;
            }
            case FRONT: {
                ((DecoratedPotBlockEntity)this.getSnapshot()).l = new DecoratedPotBlockEntity.Decoration(decorations.b(), decorations.c(), decorations.d(), sherdItem);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + face);
            }
        }
    }

    public Material getSherd(DecoratedPot.Side face) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        DecoratedPotBlockEntity.Decoration decorations = ((DecoratedPotBlockEntity)this.getSnapshot()).m();
        Item sherdItem = switch (face) {
            case DecoratedPot.Side.BACK -> decorations.b();
            case DecoratedPot.Side.LEFT -> decorations.c();
            case DecoratedPot.Side.RIGHT -> decorations.d();
            case DecoratedPot.Side.FRONT -> decorations.e();
            default -> throw new IllegalArgumentException("Unexpected value: " + face);
        };
        return CraftItemType.minecraftToBukkit(sherdItem);
    }

    public Map<DecoratedPot.Side, Material> getSherds() {
        DecoratedPotBlockEntity.Decoration decorations = ((DecoratedPotBlockEntity)this.getSnapshot()).m();
        EnumMap<DecoratedPot.Side, Material> sherds = new EnumMap<DecoratedPot.Side, Material>(DecoratedPot.Side.class);
        sherds.put(DecoratedPot.Side.BACK, CraftItemType.minecraftToBukkit(decorations.b()));
        sherds.put(DecoratedPot.Side.LEFT, CraftItemType.minecraftToBukkit(decorations.c()));
        sherds.put(DecoratedPot.Side.RIGHT, CraftItemType.minecraftToBukkit(decorations.d()));
        sherds.put(DecoratedPot.Side.FRONT, CraftItemType.minecraftToBukkit(decorations.e()));
        return sherds;
    }

    public List<Material> getShards() {
        return ((DecoratedPotBlockEntity)this.getSnapshot()).m().a().map(CraftItemType::minecraftToBukkit).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public CraftDecoratedPot copy() {
        return new CraftDecoratedPot(this);
    }
}

