/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Furnace;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftContainer;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftNamespacedKey;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Recipe;

public abstract class CraftFurnace<T extends TileEntityFurnace>
extends CraftContainer<T>
implements Furnace {
    public CraftFurnace(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CraftFurnace(CraftFurnace<T> state) {
        super(state);
    }

    public FurnaceInventory getSnapshotInventory() {
        return new CraftInventoryFurnace((TileEntityFurnace)this.getSnapshot());
    }

    public FurnaceInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryFurnace((TileEntityFurnace)this.getTileEntity());
    }

    public short getBurnTime() {
        return (short)((TileEntityFurnace)this.getSnapshot()).u;
    }

    public void setBurnTime(short burnTime) {
        ((TileEntityFurnace)this.getSnapshot()).u = burnTime;
        this.data = (IBlockData)this.data.a(BlockFurnace.b, burnTime > 0);
    }

    public short getCookTime() {
        return (short)((TileEntityFurnace)this.getSnapshot()).w;
    }

    public void setCookTime(short cookTime) {
        ((TileEntityFurnace)this.getSnapshot()).w = cookTime;
    }

    public int getCookTimeTotal() {
        return ((TileEntityFurnace)this.getSnapshot()).x;
    }

    public void setCookTimeTotal(int cookTimeTotal) {
        ((TileEntityFurnace)this.getSnapshot()).x = cookTimeTotal;
    }

    public Map<CookingRecipe<?>, Integer> getRecipesUsed() {
        ImmutableMap.Builder recipesUsed = ImmutableMap.builder();
        for (Map.Entry entrySet : ((TileEntityFurnace)this.getSnapshot()).getRecipesUsed().object2IntEntrySet()) {
            Recipe recipe = Bukkit.getRecipe((NamespacedKey)CraftNamespacedKey.fromMinecraft((MinecraftKey)entrySet.getKey()));
            if (!(recipe instanceof CookingRecipe)) continue;
            CookingRecipe cookingRecipe = (CookingRecipe)recipe;
            recipesUsed.put((Object)cookingRecipe, (Object)((Integer)entrySet.getValue()));
        }
        return recipesUsed.build();
    }

    @Override
    public abstract CraftFurnace<T> copy();

    public double getCookSpeedMultiplier() {
        return ((TileEntityFurnace)this.getSnapshot()).cookSpeedMultiplier;
    }

    public void setCookSpeedMultiplier(double multiplier) {
        Preconditions.checkArgument((multiplier >= 0.0 ? 1 : 0) != 0, (Object)"Furnace speed multiplier cannot be negative");
        Preconditions.checkArgument((multiplier <= 200.0 ? 1 : 0) != 0, (Object)"Furnace speed multiplier cannot more than 200");
        TileEntityFurnace snapshot = (TileEntityFurnace)this.getSnapshot();
        snapshot.cookSpeedMultiplier = multiplier;
        snapshot.x = TileEntityFurnace.getTotalCookTime(this.isPlaced() ? this.world.getHandle() : null, snapshot.recipeType, snapshot, snapshot.cookSpeedMultiplier);
    }

    public int getRecipeUsedCount(NamespacedKey furnaceRecipe) {
        return ((TileEntityFurnace)this.getSnapshot()).getRecipesUsed().getInt((Object)CraftNamespacedKey.toMinecraft(furnaceRecipe));
    }

    public boolean hasRecipeUsedCount(NamespacedKey furnaceRecipe) {
        return ((TileEntityFurnace)this.getSnapshot()).getRecipesUsed().containsKey((Object)CraftNamespacedKey.toMinecraft(furnaceRecipe));
    }

    public void setRecipeUsedCount(CookingRecipe<?> furnaceRecipe, int count) {
        MinecraftKey location = CraftNamespacedKey.toMinecraft(furnaceRecipe.getKey());
        Optional<RecipeHolder<?>> nmsRecipe = (this.isPlaced() ? this.world.getHandle().r() : MinecraftServer.getServer().aG()).a(location);
        Preconditions.checkArgument((nmsRecipe.isPresent() && nmsRecipe.get().b() instanceof RecipeCooking ? 1 : 0) != 0, (Object)(furnaceRecipe.getKey() + " is not recognized as a valid and registered furnace recipe"));
        if (count > 0) {
            ((TileEntityFurnace)this.getSnapshot()).getRecipesUsed().put((Object)location, count);
        } else {
            ((TileEntityFurnace)this.getSnapshot()).getRecipesUsed().removeInt((Object)location);
        }
    }

    public void setRecipesUsed(Map<CookingRecipe<?>, Integer> recipesUsed) {
        ((TileEntityFurnace)this.getSnapshot()).getRecipesUsed().clear();
        recipesUsed.forEach((recipe, integer) -> {
            if (integer != null) {
                this.setRecipeUsedCount((CookingRecipe<?>)recipe, (int)integer);
            }
        });
    }
}

