/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.command;

import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.command.ServerCommandSender;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftChatMessage;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.ServerOperator;

public class CraftBlockCommandSender
extends ServerCommandSender
implements BlockCommandSender {
    private static final PermissibleBase SHARED_PERM = new PermissibleBase(new ServerOperator(){

        public boolean isOp() {
            return true;
        }

        public void setOp(boolean value) {
            throw new UnsupportedOperationException("Cannot change operator status of a block");
        }
    });
    private final CommandListenerWrapper block;
    private final TileEntity tile;

    public CraftBlockCommandSender(CommandListenerWrapper commandBlockListenerAbstract, TileEntity tile) {
        super(SHARED_PERM);
        this.block = commandBlockListenerAbstract;
        this.tile = tile;
    }

    public Block getBlock() {
        return CraftBlock.at(this.tile.i(), this.tile.aB_());
    }

    public void sendMessage(String message) {
        for (IChatBaseComponent component : CraftChatMessage.fromString(message)) {
            this.block.c.a(component);
        }
    }

    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    public String getName() {
        return this.block.c();
    }

    public void sendMessage(Identity identity, Component message, MessageType type) {
        this.block.c.a(PaperAdventure.asVanilla(message));
    }

    public Component name() {
        return PaperAdventure.asAdventure(this.block.b());
    }

    public boolean isOp() {
        return SHARED_PERM.isOp();
    }

    public void setOp(boolean value) {
        SHARED_PERM.setOp(value);
    }

    public CommandListenerWrapper getWrapper() {
        return this.block;
    }
}

