/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.enchantments;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.enchantments.EnchantmentRarity;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentSlotType;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_20_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.util.Handleable;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.entity.EntityCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class CraftEnchantment
extends org.bukkit.enchantments.Enchantment
implements Handleable<Enchantment> {
    private final NamespacedKey key;
    private final Enchantment handle;
    private final int id;

    public static org.bukkit.enchantments.Enchantment minecraftToBukkit(Enchantment minecraft) {
        return (org.bukkit.enchantments.Enchantment)CraftRegistry.minecraftToBukkit(minecraft, Registries.t, Registry.ENCHANTMENT);
    }

    public static Enchantment bukkitToMinecraft(org.bukkit.enchantments.Enchantment bukkit) {
        return (Enchantment)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public CraftEnchantment(NamespacedKey key, Enchantment handle) {
        this.key = key;
        this.handle = handle;
        this.id = BuiltInRegistries.f.a(handle);
    }

    @Override
    public Enchantment getHandle() {
        return this.handle;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public int getMaxLevel() {
        return this.handle.a();
    }

    public int getStartLevel() {
        return this.handle.e();
    }

    public EnchantmentTarget getItemTarget() {
        return switch (this.handle.e) {
            default -> throw new IncompatibleClassChangeError();
            case EnchantmentSlotType.a -> EnchantmentTarget.ARMOR;
            case EnchantmentSlotType.b -> EnchantmentTarget.ARMOR_FEET;
            case EnchantmentSlotType.e -> EnchantmentTarget.ARMOR_HEAD;
            case EnchantmentSlotType.c -> EnchantmentTarget.ARMOR_LEGS;
            case EnchantmentSlotType.d -> EnchantmentTarget.ARMOR_TORSO;
            case EnchantmentSlotType.g -> EnchantmentTarget.TOOL;
            case EnchantmentSlotType.f -> EnchantmentTarget.WEAPON;
            case EnchantmentSlotType.k -> EnchantmentTarget.BOW;
            case EnchantmentSlotType.h -> EnchantmentTarget.FISHING_ROD;
            case EnchantmentSlotType.j -> EnchantmentTarget.BREAKABLE;
            case EnchantmentSlotType.l -> EnchantmentTarget.WEARABLE;
            case EnchantmentSlotType.i -> EnchantmentTarget.TRIDENT;
            case EnchantmentSlotType.m -> EnchantmentTarget.CROSSBOW;
            case EnchantmentSlotType.n -> EnchantmentTarget.VANISHABLE;
            case EnchantmentSlotType.BOW_AND_CROSSBOW -> EnchantmentTarget.BOW_AND_CROSSBOW;
            case EnchantmentSlotType.WEAPON_AND_SHEARS -> EnchantmentTarget.WEAPON_AND_SHEARS;
        };
    }

    public boolean isTreasure() {
        return this.handle.b();
    }

    public boolean isCursed() {
        return this.handle.c();
    }

    public boolean canEnchantItem(ItemStack item) {
        return this.handle.a(CraftItemStack.asNMSCopy(item));
    }

    public String getName() {
        return switch (this.id) {
            case 0 -> "PROTECTION_ENVIRONMENTAL";
            case 1 -> "PROTECTION_FIRE";
            case 2 -> "PROTECTION_FALL";
            case 3 -> "PROTECTION_EXPLOSIONS";
            case 4 -> "PROTECTION_PROJECTILE";
            case 5 -> "OXYGEN";
            case 6 -> "WATER_WORKER";
            case 7 -> "THORNS";
            case 8 -> "DEPTH_STRIDER";
            case 9 -> "FROST_WALKER";
            case 10 -> "BINDING_CURSE";
            case 11 -> "SOUL_SPEED";
            case 12 -> "SWIFT_SNEAK";
            case 13 -> "DAMAGE_ALL";
            case 14 -> "DAMAGE_UNDEAD";
            case 15 -> "DAMAGE_ARTHROPODS";
            case 16 -> "KNOCKBACK";
            case 17 -> "FIRE_ASPECT";
            case 18 -> "LOOT_BONUS_MOBS";
            case 19 -> "SWEEPING_EDGE";
            case 20 -> "DIG_SPEED";
            case 21 -> "SILK_TOUCH";
            case 22 -> "DURABILITY";
            case 23 -> "LOOT_BONUS_BLOCKS";
            case 24 -> "ARROW_DAMAGE";
            case 25 -> "ARROW_KNOCKBACK";
            case 26 -> "ARROW_FIRE";
            case 27 -> "ARROW_INFINITE";
            case 28 -> "LUCK";
            case 29 -> "LURE";
            case 30 -> "LOYALTY";
            case 31 -> "IMPALING";
            case 32 -> "RIPTIDE";
            case 33 -> "CHANNELING";
            case 34 -> "MULTISHOT";
            case 35 -> "QUICK_CHARGE";
            case 36 -> "PIERCING";
            case 37 -> "MENDING";
            case 38 -> "VANISHING_CURSE";
            default -> this.getKey().toString();
        };
    }

    public boolean conflictsWith(org.bukkit.enchantments.Enchantment other) {
        if (other instanceof EnchantmentWrapper) {
            other = ((EnchantmentWrapper)other).getEnchantment();
        }
        if (!(other instanceof CraftEnchantment)) {
            return false;
        }
        CraftEnchantment ench = (CraftEnchantment)other;
        return !this.handle.b(ench.getHandle());
    }

    public Component displayName(int level) {
        return PaperAdventure.asAdventure(this.getHandle().d(level));
    }

    public String translationKey() {
        return this.handle.g();
    }

    public boolean isTradeable() {
        return this.handle.h();
    }

    public boolean isDiscoverable() {
        return this.handle.i();
    }

    public int getMinModifiedCost(int level) {
        return this.handle.a(level);
    }

    public int getMaxModifiedCost(int level) {
        return this.handle.b(level);
    }

    public EnchantmentRarity getRarity() {
        return CraftEnchantment.fromNMSRarity(this.handle.d());
    }

    public float getDamageIncrease(int level, EntityCategory entityCategory) {
        return this.handle.a(level, CraftLivingEntity.fromBukkitEntityCategory(entityCategory));
    }

    public Set<EquipmentSlot> getActiveSlots() {
        return Stream.of(this.handle.a).map(CraftEquipmentSlot::getSlot).collect(Collectors.toSet());
    }

    public static EnchantmentRarity fromNMSRarity(Enchantment.Rarity nmsRarity) {
        if (nmsRarity == Enchantment.Rarity.a) {
            return EnchantmentRarity.COMMON;
        }
        if (nmsRarity == Enchantment.Rarity.b) {
            return EnchantmentRarity.UNCOMMON;
        }
        if (nmsRarity == Enchantment.Rarity.c) {
            return EnchantmentRarity.RARE;
        }
        if (nmsRarity == Enchantment.Rarity.d) {
            return EnchantmentRarity.VERY_RARE;
        }
        throw new IllegalArgumentException(String.format("Unable to convert %s to a enum value of %s.", new Object[]{nmsRarity, EnchantmentRarity.class}));
    }

    public String getTranslationKey() {
        return this.handle.g();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftEnchantment)) {
            return false;
        }
        return this.getKey().equals((Object)((org.bukkit.enchantments.Enchantment)other).getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "CraftEnchantment[" + this.getKey() + "]";
    }
}

