/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.google.common.base.Preconditions;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftSaddledInventory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.AbstractHorseInventory;

public abstract class CraftAbstractHorse
extends CraftAnimals
implements AbstractHorse {
    public CraftAbstractHorse(CraftServer server, EntityHorseAbstract entity) {
        super(server, entity);
    }

    @Override
    public EntityHorseAbstract getHandle() {
        return (EntityHorseAbstract)this.entity;
    }

    public void setVariant(Horse.Variant variant) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public int getDomestication() {
        return this.getHandle().gz();
    }

    public void setDomestication(int value) {
        Preconditions.checkArgument((value >= 0 && value <= this.getMaxDomestication() ? 1 : 0) != 0, (String)"Domestication level (%s) need to be between %s and %s (max domestication)", (Object)value, (Object)0, (Object)this.getMaxDomestication());
        this.getHandle().u(value);
    }

    public int getMaxDomestication() {
        return this.getHandle().gF();
    }

    public void setMaxDomestication(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Max domestication (%s) cannot be zero or less", (int)value);
        this.getHandle().maxDomestication = value;
    }

    public double getJumpStrength() {
        return this.getHandle().gC();
    }

    public void setJumpStrength(double strength) {
        Preconditions.checkArgument((strength >= 0.0 ? 1 : 0) != 0, (String)"Jump strength (%s) cannot be less than zero", (Object)strength);
        this.getHandle().a(GenericAttributes.h).a(strength);
    }

    public boolean isTamed() {
        return this.getHandle().gt();
    }

    public void setTamed(boolean tamed) {
        this.getHandle().x(tamed);
    }

    public AnimalTamer getOwner() {
        if (this.getOwnerUUID() == null) {
            return null;
        }
        return this.getServer().getOfflinePlayer(this.getOwnerUUID());
    }

    public void setOwner(AnimalTamer owner) {
        if (owner != null) {
            this.setTamed(true);
            this.getHandle().setTarget(null, null, false);
            this.setOwnerUUID(owner.getUniqueId());
        } else {
            this.setTamed(false);
            this.setOwnerUUID(null);
        }
    }

    public UUID getOwnerUniqueId() {
        return this.getOwnerUUID();
    }

    public UUID getOwnerUUID() {
        return this.getHandle().d();
    }

    public void setOwnerUUID(UUID uuid) {
        this.getHandle().b(uuid);
    }

    public boolean isEatingHaystack() {
        return this.getHandle().gw();
    }

    public void setEatingHaystack(boolean eatingHaystack) {
        this.getHandle().A(eatingHaystack);
    }

    public AbstractHorseInventory getInventory() {
        return new CraftSaddledInventory(this.getHandle().cp);
    }

    public boolean isEatingGrass() {
        return this.getHandle().gw();
    }

    public void setEatingGrass(boolean eating) {
        this.getHandle().A(eating);
    }

    public boolean isRearing() {
        return this.getHandle().gx();
    }

    public void setRearing(boolean rearing) {
        this.getHandle().setForceStanding(rearing);
    }

    public boolean isEating() {
        return this.getHandle().isMouthOpen();
    }

    public void setEating(boolean eating) {
        this.getHandle().setMouthOpen(eating);
    }
}

