/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.projectile.EntityArrow;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftSound;
import org.bukkit.craftbukkit.v1_20_R3.entity.AbstractProjectile;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftArrow
extends AbstractProjectile
implements AbstractArrow {
    public CraftArrow(CraftServer server, EntityArrow entity) {
        super(server, entity);
    }

    public void setKnockbackStrength(int knockbackStrength) {
        Preconditions.checkArgument((knockbackStrength >= 0 ? 1 : 0) != 0, (String)"Knockback value (%s) cannot be negative", (int)knockbackStrength);
        this.getHandle().b(knockbackStrength);
    }

    public int getKnockbackStrength() {
        return this.getHandle().o;
    }

    public double getDamage() {
        return this.getHandle().A();
    }

    public void setDamage(double damage) {
        Preconditions.checkArgument((damage >= 0.0 ? 1 : 0) != 0, (String)"Damage value (%s) must be positive", (Object)damage);
        this.getHandle().h(damage);
    }

    public int getPierceLevel() {
        return this.getHandle().E();
    }

    public void setPierceLevel(int pierceLevel) {
        Preconditions.checkArgument((0 <= pierceLevel && pierceLevel <= 127 ? 1 : 0) != 0, (String)"Pierce level (%s) out of range, expected 0 < level < 127", (int)pierceLevel);
        this.getHandle().a((byte)pierceLevel);
    }

    public boolean isCritical() {
        return this.getHandle().C();
    }

    public void setCritical(boolean critical) {
        this.getHandle().a(critical);
    }

    public boolean isInBlock() {
        return this.getHandle().b;
    }

    public Block getAttachedBlock() {
        if (!this.isInBlock()) {
            return null;
        }
        BlockPosition pos = this.getHandle().dm();
        return this.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
    }

    public AbstractArrow.PickupStatus getPickupStatus() {
        return AbstractArrow.PickupStatus.values()[this.getHandle().d.ordinal()];
    }

    public void setPickupStatus(AbstractArrow.PickupStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0, (Object)"PickupStatus cannot be null");
        this.getHandle().d = EntityArrow.PickupStatus.a(status.ordinal());
    }

    @NotNull
    public CraftItemStack getItemStack() {
        return CraftItemStack.asCraftMirror(this.getHandle().y());
    }

    public void setLifetimeTicks(int ticks) {
        this.getHandle().m = ticks;
    }

    public int getLifetimeTicks() {
        return this.getHandle().m;
    }

    @NotNull
    public Sound getHitSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().p);
    }

    public void setHitSound(@NotNull Sound sound) {
        this.getHandle().b(CraftSound.bukkitToMinecraft(sound));
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().m = value;
    }

    public boolean isShotFromCrossbow() {
        return this.getHandle().D();
    }

    public void setShotFromCrossbow(boolean shotFromCrossbow) {
        this.getHandle().q(shotFromCrossbow);
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().s);
    }

    public void setItem(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        this.getHandle().s = CraftItemStack.asNMSCopy(item);
    }

    @Override
    public EntityArrow getHandle() {
        return (EntityArrow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftArrow";
    }
}

