/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.google.common.base.Preconditions;
import java.util.stream.Collectors;
import net.minecraft.world.entity.vehicle.EntityBoat;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftVehicle;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Boat;

public class CraftBoat
extends CraftVehicle
implements Boat {
    public CraftBoat(CraftServer server, EntityBoat entity) {
        super(server, entity);
    }

    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().y());
    }

    public void setWoodType(TreeSpecies species) {
        this.getHandle().a(CraftBoat.getBoatType(species));
    }

    public Boat.Type getBoatType() {
        return CraftBoat.boatTypeFromNms(this.getHandle().y());
    }

    public void setBoatType(Boat.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Boat.Type cannot be null");
        this.getHandle().a(CraftBoat.boatTypeToNms(type));
    }

    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    public Material getBoatMaterial() {
        return CraftMagicNumbers.getMaterial(this.getHandle().ah_());
    }

    public Boat.Status getStatus() {
        EntityBoat handle = this.getHandle();
        if (handle.aM == null) {
            if (handle.valid) {
                return CraftBoat.boatStatusFromNms(handle.C());
            }
            return Boat.Status.NOT_IN_WORLD;
        }
        return CraftBoat.boatStatusFromNms(this.getHandle().aM);
    }

    @Override
    public EntityBoat getHandle() {
        return (EntityBoat)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBoat{boatType=" + this.getBoatType() + ",status=" + this.getStatus() + ",passengers=" + this.getPassengers().stream().map(Object::toString).collect(Collectors.joining("-", "{", "}")) + "}";
    }

    public static Boat.Type boatTypeFromNms(EntityBoat.EnumBoatType boatType) {
        return switch (boatType) {
            default -> throw new EnumConstantNotPresentException(Boat.Type.class, boatType.name());
            case EntityBoat.EnumBoatType.a -> Boat.Type.OAK;
            case EntityBoat.EnumBoatType.c -> Boat.Type.BIRCH;
            case EntityBoat.EnumBoatType.e -> Boat.Type.ACACIA;
            case EntityBoat.EnumBoatType.f -> Boat.Type.CHERRY;
            case EntityBoat.EnumBoatType.d -> Boat.Type.JUNGLE;
            case EntityBoat.EnumBoatType.b -> Boat.Type.SPRUCE;
            case EntityBoat.EnumBoatType.g -> Boat.Type.DARK_OAK;
            case EntityBoat.EnumBoatType.h -> Boat.Type.MANGROVE;
            case EntityBoat.EnumBoatType.i -> Boat.Type.BAMBOO;
        };
    }

    public static EntityBoat.EnumBoatType boatTypeToNms(Boat.Type type) {
        return switch (type) {
            default -> throw new EnumConstantNotPresentException(EntityBoat.EnumBoatType.class, type.name());
            case Boat.Type.BAMBOO -> EntityBoat.EnumBoatType.i;
            case Boat.Type.MANGROVE -> EntityBoat.EnumBoatType.h;
            case Boat.Type.SPRUCE -> EntityBoat.EnumBoatType.b;
            case Boat.Type.DARK_OAK -> EntityBoat.EnumBoatType.g;
            case Boat.Type.JUNGLE -> EntityBoat.EnumBoatType.d;
            case Boat.Type.CHERRY -> EntityBoat.EnumBoatType.f;
            case Boat.Type.ACACIA -> EntityBoat.EnumBoatType.e;
            case Boat.Type.BIRCH -> EntityBoat.EnumBoatType.c;
            case Boat.Type.OAK -> EntityBoat.EnumBoatType.a;
        };
    }

    public static Boat.Status boatStatusFromNms(EntityBoat.EnumStatus enumStatus) {
        return switch (enumStatus) {
            default -> throw new EnumConstantNotPresentException(Boat.Status.class, enumStatus.name());
            case EntityBoat.EnumStatus.e -> Boat.Status.IN_AIR;
            case EntityBoat.EnumStatus.d -> Boat.Status.ON_LAND;
            case EntityBoat.EnumStatus.b -> Boat.Status.UNDER_WATER;
            case EntityBoat.EnumStatus.c -> Boat.Status.UNDER_FLOWING_WATER;
            case EntityBoat.EnumStatus.a -> Boat.Status.IN_WATER;
        };
    }

    @Deprecated
    public static TreeSpecies getTreeSpecies(EntityBoat.EnumBoatType boatType) {
        switch (boatType) {
            case b: {
                return TreeSpecies.REDWOOD;
            }
            case c: {
                return TreeSpecies.BIRCH;
            }
            case d: {
                return TreeSpecies.JUNGLE;
            }
            case e: {
                return TreeSpecies.ACACIA;
            }
            case g: {
                return TreeSpecies.DARK_OAK;
            }
        }
        return TreeSpecies.GENERIC;
    }

    @Deprecated
    public static EntityBoat.EnumBoatType getBoatType(TreeSpecies species) {
        switch (species) {
            case REDWOOD: {
                return EntityBoat.EnumBoatType.b;
            }
            case BIRCH: {
                return EntityBoat.EnumBoatType.c;
            }
            case JUNGLE: {
                return EntityBoat.EnumBoatType.d;
            }
            case ACACIA: {
                return EntityBoat.EnumBoatType.e;
            }
            case DARK_OAK: {
                return EntityBoat.EnumBoatType.g;
            }
        }
        return EntityBoat.EnumBoatType.a;
    }
}

