/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.google.common.base.Preconditions;
import net.minecraft.util.Brightness;
import net.minecraft.world.entity.Display;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.entity.Display;
import org.bukkit.util.Transformation;
import org.joml.Matrix4f;

public class CraftDisplay
extends CraftEntity
implements Display {
    public CraftDisplay(CraftServer server, net.minecraft.world.entity.Display entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.Display getHandle() {
        return (net.minecraft.world.entity.Display)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftDisplay";
    }

    public Transformation getTransformation() {
        com.mojang.math.Transformation nms = net.minecraft.world.entity.Display.a(this.getHandle().an());
        return new Transformation(nms.d(), nms.e(), nms.f(), nms.g());
    }

    public void setTransformation(Transformation transformation) {
        Preconditions.checkArgument((transformation != null ? 1 : 0) != 0, (Object)"Transformation cannot be null");
        this.getHandle().a(new com.mojang.math.Transformation(transformation.getTranslation(), transformation.getLeftRotation(), transformation.getScale(), transformation.getRightRotation()));
    }

    public void setTransformationMatrix(Matrix4f transformationMatrix) {
        Preconditions.checkArgument((transformationMatrix != null ? 1 : 0) != 0, (Object)"Transformation matrix cannot be null");
        this.getHandle().a(new com.mojang.math.Transformation(transformationMatrix));
    }

    public int getInterpolationDuration() {
        return this.getHandle().s();
    }

    public void setInterpolationDuration(int duration) {
        this.getHandle().b(duration);
    }

    public int getTeleportDuration() {
        return this.getHandle().an().b(net.minecraft.world.entity.Display.s);
    }

    public void setTeleportDuration(int duration) {
        Preconditions.checkArgument((duration >= 0 && duration <= 59 ? 1 : 0) != 0, (String)"duration (%s) cannot be lower than 0 or higher than 59", (int)duration);
        this.getHandle().an().b(net.minecraft.world.entity.Display.s, duration);
    }

    public float getViewRange() {
        return this.getHandle().A();
    }

    public void setViewRange(float range) {
        this.getHandle().b(range);
    }

    public float getShadowRadius() {
        return this.getHandle().B();
    }

    public void setShadowRadius(float radius) {
        this.getHandle().c(radius);
    }

    public float getShadowStrength() {
        return this.getHandle().C();
    }

    public void setShadowStrength(float strength) {
        this.getHandle().u(strength);
    }

    public float getDisplayWidth() {
        return this.getHandle().D();
    }

    public void setDisplayWidth(float width) {
        this.getHandle().v(width);
    }

    public float getDisplayHeight() {
        return this.getHandle().G();
    }

    public void setDisplayHeight(float height) {
        this.getHandle().w(height);
    }

    public int getInterpolationDelay() {
        return this.getHandle().u();
    }

    public void setInterpolationDelay(int ticks) {
        this.getHandle().c(ticks);
    }

    public Display.Billboard getBillboard() {
        return Display.Billboard.valueOf((String)this.getHandle().x().name());
    }

    public void setBillboard(Display.Billboard billboard) {
        Preconditions.checkArgument((billboard != null ? 1 : 0) != 0, (Object)"Billboard cannot be null");
        this.getHandle().a(Display.BillboardConstraints.valueOf(billboard.name()));
    }

    public Color getGlowColorOverride() {
        int color = this.getHandle().E();
        return color == -1 ? null : Color.fromARGB((int)color);
    }

    public void setGlowColorOverride(Color color) {
        if (color == null) {
            this.getHandle().m(-1);
        } else {
            this.getHandle().m(color.asARGB());
        }
    }

    public Display.Brightness getBrightness() {
        Brightness nms = this.getHandle().y();
        return nms != null ? new Display.Brightness(nms.b(), nms.c()) : null;
    }

    public void setBrightness(Display.Brightness brightness) {
        if (brightness != null) {
            this.getHandle().a(new Brightness(brightness.getBlockLight(), brightness.getSkyLight()));
        } else {
            this.getHandle().a((Brightness)null);
        }
    }
}

