/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityTypes;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_20_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class CraftEntityType {
    private static final Map<EntityType, ResourceKey<EntityTypes<?>>> KEY_CACHE = Collections.synchronizedMap(new EnumMap(EntityType.class));

    public static EntityType minecraftToBukkit(EntityTypes<?> minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.u);
        EntityType bukkit = (EntityType)Registry.ENTITY_TYPE.get(CraftNamespacedKey.fromMinecraft(registry.c(minecraft).orElseThrow().a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static EntityTypes<?> bukkitToMinecraft(EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (EntityTypes)CraftRegistry.getMinecraftRegistry(Registries.u).d(KEY_CACHE.computeIfAbsent(bukkit, type -> ResourceKey.a(Registries.u, CraftNamespacedKey.toMinecraft(type.getKey())))).orElseThrow();
    }
}

