/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.destroystokyo.paper.entity.CraftRangedEntity;
import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftChestedHorse;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftInventoryLlama;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.LlamaInventory;
import org.jetbrains.annotations.NotNull;

public class CraftLlama
extends CraftChestedHorse
implements Llama,
CraftRangedEntity<EntityLlama> {
    public CraftLlama(CraftServer server, EntityLlama entity) {
        super(server, entity);
    }

    @Override
    public EntityLlama getHandle() {
        return (EntityLlama)super.getHandle();
    }

    public Llama.Color getColor() {
        return Llama.Color.values()[this.getHandle().gq().ordinal()];
    }

    public void setColor(Llama.Color color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.getHandle().a(EntityLlama.Variant.a(color.ordinal()));
    }

    public LlamaInventory getInventory() {
        return new CraftInventoryLlama(this.getHandle().cp);
    }

    public int getStrength() {
        return this.getHandle().go();
    }

    public void setStrength(int strength) {
        Preconditions.checkArgument((1 <= strength && strength <= 5 ? 1 : 0) != 0, (Object)"strength must be [1,5]");
        if (strength == this.getStrength()) {
            return;
        }
        this.getHandle().setStrengthPublic(strength);
        this.getHandle().gA();
    }

    public Horse.Variant getVariant() {
        return Horse.Variant.LLAMA;
    }

    @Override
    public String toString() {
        return "CraftLlama";
    }

    public boolean inCaravan() {
        return this.getHandle().gS();
    }

    public void joinCaravan(@NotNull Llama llama) {
        this.getHandle().a(((CraftLlama)llama).getHandle());
    }

    public void leaveCaravan() {
        this.getHandle().gQ();
    }

    public boolean hasCaravanTail() {
        return this.getHandle().gR();
    }

    public Llama getCaravanHead() {
        return this.getHandle().gT() == null ? null : (Llama)this.getHandle().gT().getBukkitEntity();
    }

    public Llama getCaravanTail() {
        return this.getHandle().cc == null ? null : (Llama)this.getHandle().cc.getBukkitEntity();
    }

    public boolean shouldJoinCaravan() {
        return this.getHandle().shouldJoinCaravan;
    }

    public void setShouldJoinCaravan(boolean shouldJoinCaravan) {
        this.getHandle().shouldJoinCaravan = shouldJoinCaravan;
    }
}

