/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.item.ItemArrow;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftMetaItem;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaCrossbow
extends CraftMetaItem
implements CrossbowMeta {
    static final CraftMetaItem.ItemMetaKey CHARGED = new CraftMetaItem.ItemMetaKey("Charged", "charged");
    static final CraftMetaItem.ItemMetaKey CHARGED_PROJECTILES = new CraftMetaItem.ItemMetaKey("ChargedProjectiles", "charged-projectiles");
    private boolean charged;
    private List<ItemStack> chargedProjectiles;

    CraftMetaCrossbow(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaCrossbow)) {
            return;
        }
        CraftMetaCrossbow crossbow = (CraftMetaCrossbow)meta;
        this.charged = crossbow.charged;
        if (crossbow.hasChargedProjectiles()) {
            this.chargedProjectiles = new ArrayList<ItemStack>(crossbow.chargedProjectiles);
        }
    }

    CraftMetaCrossbow(NBTTagCompound tag) {
        super(tag);
        NBTTagList list;
        this.charged = tag.q(CraftMetaCrossbow.CHARGED.NBT);
        if (tag.b(CraftMetaCrossbow.CHARGED_PROJECTILES.NBT, 9) && (list = tag.c(CraftMetaCrossbow.CHARGED_PROJECTILES.NBT, 10)) != null && !list.isEmpty()) {
            this.chargedProjectiles = new ArrayList<ItemStack>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                NBTTagCompound nbttagcompound1 = list.a(i2);
                this.chargedProjectiles.add(CraftItemStack.asCraftMirror(net.minecraft.world.item.ItemStack.a(nbttagcompound1)));
            }
        }
    }

    CraftMetaCrossbow(Map<String, Object> map) {
        super(map);
        Iterable projectiles;
        Boolean charged = CraftMetaItem.SerializableMeta.getObject(Boolean.class, map, CraftMetaCrossbow.CHARGED.BUKKIT, true);
        if (charged != null) {
            this.charged = charged;
        }
        if ((projectiles = CraftMetaItem.SerializableMeta.getObject(Iterable.class, map, CraftMetaCrossbow.CHARGED_PROJECTILES.BUKKIT, true)) != null) {
            for (Object stack : projectiles) {
                if (!(stack instanceof ItemStack)) continue;
                this.addChargedProjectile((ItemStack)stack);
            }
        }
    }

    @Override
    void applyToItem(NBTTagCompound tag) {
        super.applyToItem(tag);
        tag.a(CraftMetaCrossbow.CHARGED.NBT, this.charged);
        if (this.hasChargedProjectiles()) {
            NBTTagList list = new NBTTagList();
            for (ItemStack item : this.chargedProjectiles) {
                NBTTagCompound saved = new NBTTagCompound();
                CraftItemStack.asNMSCopy(item).b(saved);
                list.add(saved);
            }
            tag.a(CraftMetaCrossbow.CHARGED_PROJECTILES.NBT, list);
        }
    }

    @Override
    boolean applicableTo(Material type) {
        return type == Material.CROSSBOW;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isCrossbowEmpty();
    }

    boolean isCrossbowEmpty() {
        return !this.hasChargedProjectiles();
    }

    public boolean hasChargedProjectiles() {
        return this.chargedProjectiles != null;
    }

    public List<ItemStack> getChargedProjectiles() {
        return this.chargedProjectiles == null ? ImmutableList.of() : ImmutableList.copyOf(this.chargedProjectiles);
    }

    public void setChargedProjectiles(List<ItemStack> projectiles) {
        this.chargedProjectiles = null;
        this.charged = false;
        if (projectiles == null) {
            return;
        }
        for (ItemStack i2 : projectiles) {
            this.addChargedProjectile(i2);
        }
    }

    public void addChargedProjectile(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"item");
        Preconditions.checkArgument((item.getType() == Material.FIREWORK_ROCKET || CraftItemType.bukkitToMinecraft(item.getType()) instanceof ItemArrow ? 1 : 0) != 0, (String)"Item %s is not an arrow or firework rocket", (Object)item);
        if (this.chargedProjectiles == null) {
            this.chargedProjectiles = new ArrayList<ItemStack>();
        }
        this.charged = true;
        this.chargedProjectiles.add(item);
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaCrossbow) {
            CraftMetaCrossbow that = (CraftMetaCrossbow)meta;
            return this.charged == that.charged && (this.hasChargedProjectiles() ? that.hasChargedProjectiles() && this.chargedProjectiles.equals(that.chargedProjectiles) : !that.hasChargedProjectiles());
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaCrossbow || this.isCrossbowEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasChargedProjectiles()) {
            hash = 61 * hash + (this.charged ? 1 : 0);
            hash = 61 * hash + this.chargedProjectiles.hashCode();
        }
        return original != hash ? CraftMetaCrossbow.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaCrossbow clone() {
        return (CraftMetaCrossbow)super.clone();
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        builder.put((Object)CraftMetaCrossbow.CHARGED.BUKKIT, (Object)this.charged);
        if (this.hasChargedProjectiles()) {
            builder.put((Object)CraftMetaCrossbow.CHARGED_PROJECTILES.BUKKIT, this.chargedProjectiles);
        }
        return builder;
    }
}

