/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.inventory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeItemStack;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.recipe.CookingBookCategory;

public interface CraftRecipe
extends Recipe {
    public void addToCraftingManager();

    default public RecipeItemStack toNMS(RecipeChoice bukkit, boolean requireNotEmpty) {
        return CraftRecipe.toIngredient(bukkit, requireNotEmpty);
    }

    public static RecipeItemStack toIngredient(RecipeChoice bukkit, boolean requireNotEmpty) {
        RecipeItemStack stack;
        if (bukkit == null) {
            stack = RecipeItemStack.a;
        } else if (bukkit instanceof RecipeChoice.MaterialChoice) {
            stack = new RecipeItemStack(((RecipeChoice.MaterialChoice)bukkit).getChoices().stream().map(mat -> new RecipeItemStack.StackProvider(CraftItemStack.asNMSCopy(new ItemStack(mat)))));
        } else if (bukkit instanceof RecipeChoice.ExactChoice) {
            stack = new RecipeItemStack(((RecipeChoice.ExactChoice)bukkit).getChoices().stream().map(mat -> new RecipeItemStack.StackProvider(CraftItemStack.asNMSCopy(mat))));
            stack.exact = true;
            stack.predicate = ((RecipeChoice.ExactChoice)bukkit).getPredicate();
        } else {
            throw new IllegalArgumentException("Unknown recipe stack instance " + bukkit);
        }
        stack.a();
        if (requireNotEmpty) {
            Preconditions.checkArgument((stack.e.length != 0 ? 1 : 0) != 0, (Object)"Recipe requires at least one non-air choice");
        }
        return stack;
    }

    public static RecipeChoice toBukkit(RecipeItemStack list) {
        list.a();
        if (list.e.length == 0) {
            return null;
        }
        if (list.exact) {
            ArrayList<ItemStack> choices = new ArrayList<ItemStack>(list.e.length);
            for (net.minecraft.world.item.ItemStack i2 : list.e) {
                choices.add(CraftItemStack.asBukkitCopy(i2));
            }
            return new RecipeChoice.ExactChoice(choices);
        }
        ArrayList<Material> choices = new ArrayList<Material>(list.e.length);
        for (net.minecraft.world.item.ItemStack i3 : list.e) {
            choices.add(CraftItemType.minecraftToBukkit(i3.d()));
        }
        return new RecipeChoice.MaterialChoice(choices);
    }

    public static CraftingBookCategory getCategory(org.bukkit.inventory.recipe.CraftingBookCategory bukkit) {
        return CraftingBookCategory.valueOf(bukkit.name());
    }

    public static org.bukkit.inventory.recipe.CraftingBookCategory getCategory(CraftingBookCategory nms) {
        return org.bukkit.inventory.recipe.CraftingBookCategory.valueOf((String)nms.name());
    }

    public static net.minecraft.world.item.crafting.CookingBookCategory getCategory(CookingBookCategory bukkit) {
        return net.minecraft.world.item.crafting.CookingBookCategory.valueOf(bukkit.name());
    }

    public static CookingBookCategory getCategory(net.minecraft.world.item.crafting.CookingBookCategory nms) {
        return CookingBookCategory.valueOf((String)nms.name());
    }
}

