/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.map;

import io.papermc.paper.adventure.PaperAdventure;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.map.CraftMapView;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class CraftMapRenderer
extends MapRenderer {
    private final WorldMap worldMap;

    public CraftMapRenderer(CraftMapView mapView, WorldMap worldMap) {
        super(false);
        this.worldMap = worldMap;
    }

    public void render(MapView map, MapCanvas canvas, Player player) {
        for (int x2 = 0; x2 < 128; ++x2) {
            for (int y2 = 0; y2 < 128; ++y2) {
                canvas.setPixel(x2, y2, this.worldMap.g[y2 * 128 + x2]);
            }
        }
        MapCursorCollection cursors = canvas.getCursors();
        while (cursors.size() > 0) {
            cursors.removeCursor(cursors.getCursor(0));
        }
        for (String key : this.worldMap.q.keySet()) {
            Player other = Bukkit.getPlayerExact((String)key);
            if (other != null && !player.canSee(other)) continue;
            MapIcon decoration = this.worldMap.q.get(key);
            cursors.addCursor((int)decoration.d(), (int)decoration.e(), (byte)(decoration.f() & 0xF), decoration.c().a(), true, decoration.g() == null ? null : PaperAdventure.asAdventure(decoration.g()));
        }
    }

    public boolean isExplorerMap() {
        return this.worldMap.isExplorerMap;
    }
}

