/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.potion;

import com.google.common.base.Preconditions;
import io.papermc.paper.potion.PotionMix;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionUtil;
import org.bukkit.potion.PotionBrewer;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class CraftPotionBrewer
implements PotionBrewer {
    public Collection<PotionEffect> getEffects(PotionType type, boolean upgraded, boolean extended) {
        Preconditions.checkArgument((!type.getKey().getKey().startsWith("strong_") ? 1 : 0) != 0, (String)"Strong potion type cannot be used directly, got %s", (Object)type.getKey());
        Preconditions.checkArgument((!type.getKey().getKey().startsWith("long_") ? 1 : 0) != 0, (String)"Extended potion type cannot be used directly, got %s", (Object)type.getKey());
        return CraftPotionUtil.fromBukkit(new PotionData(type, upgraded, extended)).getPotionEffects();
    }

    public Collection<PotionEffect> getEffectsFromDamage(int damage) {
        return new ArrayList<PotionEffect>();
    }

    public PotionEffect createEffect(PotionEffectType potion, int duration, int amplifier) {
        return new PotionEffect(potion, potion.isInstant() ? 1 : (int)((double)duration * potion.getDurationModifier()), amplifier);
    }

    public void addPotionMix(PotionMix potionMix) {
        net.minecraft.world.item.alchemy.PotionBrewer.addPotionMix(potionMix);
    }

    public void removePotionMix(NamespacedKey key) {
        net.minecraft.world.item.alchemy.PotionBrewer.removePotionMix(key);
    }

    public void resetPotionMixes() {
        net.minecraft.world.item.alchemy.PotionBrewer.reload();
    }
}

