/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.server.MinecraftServer;
import org.purpurmc.purpur.PurpurConfig;

public class UptimeCommand {
    public static void register(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("uptime").requires(listener -> listener.hasPermission(2, "bukkit.command.uptime"))).executes(context -> UptimeCommand.execute((CommandListenerWrapper)context.getSource()))));
    }

    private static int execute(CommandListenerWrapper sender) {
        Data data = new Data();
        data.format = PurpurConfig.uptimeFormat;
        data.hide = true;
        data.millis = System.currentTimeMillis() - MinecraftServer.startTimeMillis;
        UptimeCommand.process(data, "<days>", PurpurConfig.uptimeDay, PurpurConfig.uptimeDays, TimeUnit.DAYS, TimeUnit.MILLISECONDS::toDays);
        UptimeCommand.process(data, "<hours>", PurpurConfig.uptimeHour, PurpurConfig.uptimeHours, TimeUnit.HOURS, TimeUnit.MILLISECONDS::toHours);
        UptimeCommand.process(data, "<minutes>", PurpurConfig.uptimeMinute, PurpurConfig.uptimeMinutes, TimeUnit.MINUTES, TimeUnit.MILLISECONDS::toMinutes);
        data.hide = false;
        UptimeCommand.process(data, "<seconds>", PurpurConfig.uptimeSecond, PurpurConfig.uptimeSeconds, TimeUnit.SECONDS, TimeUnit.MILLISECONDS::toSeconds);
        Component output = MiniMessage.miniMessage().deserialize(PurpurConfig.uptimeCommandOutput, (TagResolver)Placeholder.unparsed((String)"uptime", (String)data.format));
        sender.sendSuccess(output, false);
        return 1;
    }

    private static void process(Data data, String replace, String singular, String plural, TimeUnit unit, Function<Long, Long> func) {
        if (data.format.contains(replace)) {
            long val = func.apply(data.millis);
            if (data.hide) {
                boolean bl = data.hide = val == 0L;
            }
            if (!data.hide) {
                data.millis -= unit.toMillis(val);
            }
            data.format = data.format.replace(replace, data.hide ? "" : String.format(val == 1L ? singular : plural, val));
        }
    }

    private static class Data {
        String format;
        boolean hide;
        long millis;

        private Data() {
        }
    }
}

