/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.entity;

import io.papermc.paper.adventure.PaperAdventure;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import org.bukkit.block.EntityBlockStorage;
import org.bukkit.craftbukkit.v1_20_R3.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_20_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.entity.Bee;
import org.bukkit.entity.EntityType;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.purpurmc.purpur.entity.StoredEntity;

public class PurpurStoredBee
implements StoredEntity<Bee> {
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private final EntityBlockStorage<Bee> blockStorage;
    private final TileEntityBeehive.HiveBee handle;
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private Component customName;

    public PurpurStoredBee(TileEntityBeehive.HiveBee data, EntityBlockStorage<Bee> blockStorage) {
        this.handle = data;
        this.blockStorage = blockStorage;
        Component component = this.customName = this.handle.a.b("CustomName", 8) ? PaperAdventure.asAdventure(IChatBaseComponent.ChatSerializer.a(this.handle.a.l("CustomName"))) : null;
        if (this.handle.a.b("BukkitValues", 10)) {
            this.persistentDataContainer.putAll(this.handle.a.p("BukkitValues"));
        }
    }

    public TileEntityBeehive.HiveBee getHandle() {
        return this.handle;
    }

    @Nullable
    public Component customName() {
        return this.customName;
    }

    public void customName(@Nullable Component customName) {
        this.customName = customName;
    }

    @Nullable
    public String getCustomName() {
        return PaperAdventure.asPlain(this.customName, Locale.US);
    }

    public void setCustomName(@Nullable String name) {
        this.customName((Component)(name != null ? Component.text((String)name) : null));
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public boolean hasBeenReleased() {
        return !this.blockStorage.getEntities().contains(this);
    }

    @Nullable
    public Bee release() {
        return (Bee)this.blockStorage.releaseEntity((StoredEntity)this);
    }

    @Nullable
    public EntityBlockStorage<Bee> getBlockStorage() {
        if (this.hasBeenReleased()) {
            return null;
        }
        return this.blockStorage;
    }

    @NotNull
    public EntityType getType() {
        return EntityType.BEE;
    }

    public void update() {
        this.handle.a.a("BukkitValues", this.persistentDataContainer.toTagCompound());
        if (this.customName == null) {
            this.handle.a.r("CustomName");
        } else {
            this.handle.a.a("CustomName", IChatBaseComponent.ChatSerializer.a(PaperAdventure.asVanilla(this.customName)));
        }
    }
}

