/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.task;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.scheduler.MinecraftInternalPlugin;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginBase;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class BeehiveTask
implements PluginMessageListener {
    public static final MinecraftKey BEEHIVE_C2S = new MinecraftKey("purpur", "beehive_c2s");
    public static final MinecraftKey BEEHIVE_S2C = new MinecraftKey("purpur", "beehive_s2c");
    private static BeehiveTask instance;
    private final PluginBase plugin = new MinecraftInternalPlugin();

    public static BeehiveTask instance() {
        if (instance == null) {
            instance = new BeehiveTask();
        }
        return instance;
    }

    private BeehiveTask() {
    }

    public void register() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, BEEHIVE_S2C.toString());
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, BEEHIVE_C2S.toString(), (PluginMessageListener)this);
    }

    public void unregister() {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)this.plugin, BEEHIVE_S2C.toString());
        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)this.plugin, BEEHIVE_C2S.toString());
    }

    public void onPluginMessageReceived(@NotNull String channel, Player player, byte[] bytes) {
        ByteArrayDataInput in = BeehiveTask.in(bytes);
        long packedPos = in.readLong();
        BlockPosition pos = BlockPosition.d(packedPos);
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        if (!pos.b().a((IPosition)serverPlayer.dk(), 20.0)) {
            return;
        }
        if (serverPlayer.dM().getChunkIfLoaded(pos) == null) {
            return;
        }
        TileEntity blockEntity = serverPlayer.dM().c_(pos);
        if (!(blockEntity instanceof TileEntityBeehive)) {
            return;
        }
        TileEntityBeehive beehive = (TileEntityBeehive)blockEntity;
        ByteArrayDataOutput out = BeehiveTask.out();
        out.writeInt(beehive.g());
        out.writeLong(packedPos);
        final PacketDataSerializer byteBuf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
        serverPlayer.c.b(new ClientboundCustomPayloadPacket(new CustomPacketPayload(){

            @Override
            public void a(PacketDataSerializer buf) {
                buf.b(byteBuf.copy());
            }

            @Override
            public MinecraftKey a() {
                return BEEHIVE_S2C;
            }
        }));
    }

    private static ByteArrayDataOutput out() {
        return ByteStreams.newDataOutput();
    }

    private static ByteArrayDataInput in(byte[] bytes) {
        return ByteStreams.newDataInput((byte[])bytes);
    }
}

