/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.Index;
import org.bukkit.FeatureFlagImpl;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.ApiStatus;

public interface FeatureFlag
extends Keyed {
    public static final FeatureFlag VANILLA = FeatureFlag.create("vanilla");
    @ApiStatus.Experimental
    public static final FeatureFlag BUNDLE = FeatureFlag.create("bundle");
    @ApiStatus.Experimental
    public static final FeatureFlag TRADE_REBALANCE = FeatureFlag.create("trade_rebalance");
    @Deprecated(since="1.20")
    public static final FeatureFlag UPDATE_1_20 = FeatureFlag.deprecated("update_1_20");
    @Deprecated(since="1.21")
    public static final FeatureFlag UPDATE_121 = FeatureFlag.deprecated("update_1_21");
    public static final Index<Key, FeatureFlag> ALL_FLAGS = Index.create(Keyed::key, List.copyOf(FeatureFlagImpl.ALL_FLAGS));

    private static FeatureFlag create(@Subst(value="vanilla") String name) {
        FeatureFlagImpl flag = new FeatureFlagImpl(NamespacedKey.minecraft(name));
        Preconditions.checkState((boolean)FeatureFlagImpl.ALL_FLAGS.add(flag), (Object)("Tried to add duplicate feature flag: " + name));
        return flag;
    }

    private static FeatureFlag deprecated(@Subst(value="vanilla") String name) {
        return new FeatureFlagImpl.Deprecated(NamespacedKey.minecraft(name));
    }
}

