/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import com.destroystokyo.paper.utils.PaperPluginLogger;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import io.papermc.paper.plugin.provider.classloader.PaperClassLoaderStorage;
import io.papermc.paper.plugin.provider.classloader.PluginClassLoaderGroup;
import io.papermc.paper.plugin.provider.entrypoint.DependencyContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PluginClassLoader
extends URLClassLoader
implements ConfiguredPluginClassLoader {
    private final JavaPluginLoader loader = null;
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();
    private final PluginDescriptionFile description;
    private final File dataFolder;
    private final File file;
    private final JarFile jar;
    private final Manifest manifest;
    private final URL url;
    private final ClassLoader libraryLoader;
    final JavaPlugin plugin;
    private JavaPlugin pluginInit;
    private IllegalStateException pluginState;
    private final Set<String> seenIllegalAccess = Collections.newSetFromMap(new ConcurrentHashMap());
    private Logger logger;
    private PluginClassLoaderGroup classLoaderGroup;
    public DependencyContext dependencyContext;
    private boolean closed = false;

    @ApiStatus.Internal
    public PluginClassLoader(@Nullable ClassLoader parent, @NotNull PluginDescriptionFile description, @NotNull File dataFolder, @NotNull File file, @Nullable ClassLoader libraryLoader, JarFile jarFile, DependencyContext dependencyContext) throws IOException, InvalidPluginException, MalformedURLException {
        super(file.getName(), new URL[]{file.toURI().toURL()}, parent);
        Constructor<JavaPlugin> pluginConstructor;
        Class<JavaPlugin> pluginClass;
        Class<?> jarClass;
        this.description = description;
        this.dataFolder = dataFolder;
        this.file = file;
        this.jar = jarFile;
        this.manifest = this.jar.getManifest();
        this.url = file.toURI().toURL();
        this.libraryLoader = libraryLoader;
        this.logger = PaperPluginLogger.getLogger(description);
        this.dependencyContext = dependencyContext;
        this.classLoaderGroup = PaperClassLoaderStorage.instance().registerSpigotGroup(this);
        try {
            jarClass = Class.forName(description.getMain(), true, this);
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidPluginException("Cannot find main class `" + description.getMain() + "'", ex);
        }
        try {
            pluginClass = jarClass.asSubclass(JavaPlugin.class);
        }
        catch (ClassCastException ex) {
            throw new InvalidPluginException("main class `" + description.getMain() + "' must extend JavaPlugin", ex);
        }
        try {
            pluginConstructor = pluginClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new InvalidPluginException("main class `" + description.getMain() + "' must have a public no-args constructor", ex);
        }
        try {
            this.plugin = pluginConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPluginException("main class `" + description.getMain() + "' constructor must be public", ex);
        }
        catch (InstantiationException ex) {
            throw new InvalidPluginException("main class `" + description.getMain() + "' must not be abstract", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidPluginException("Could not invoke main class `" + description.getMain() + "' constructor", ex);
        }
        catch (ExceptionInInitializerError | InvocationTargetException ex) {
            throw new InvalidPluginException("Exception initializing main class `" + description.getMain() + "'", ex);
        }
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.findResource(name);
        if (resource == null && this.libraryLoader != null) {
            return this.libraryLoader.getResource(name);
        }
        return resource;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList resources = new ArrayList();
        this.addEnumeration(resources, this.findResources(name));
        if (this.libraryLoader != null) {
            this.addEnumeration(resources, this.libraryLoader.getResources(name));
        }
        return Collections.enumeration(resources);
    }

    private <T> void addEnumeration(ArrayList<T> list, Enumeration<T> enumeration) {
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
    }

    @Override
    public Class<?> loadClass(@NotNull String name, boolean resolve, boolean checkGlobal, boolean checkLibraries) throws ClassNotFoundException {
        return this.loadClass0(name, resolve, checkGlobal, checkLibraries);
    }

    @Override
    public PluginMeta getConfiguration() {
        return this.description;
    }

    @Override
    public void init(JavaPlugin plugin) {
        this.initialize(plugin);
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass0(name, resolve, true, true);
    }

    Class<?> loadClass0(@NotNull String name, boolean resolve, boolean checkGlobal, boolean checkLibraries) throws ClassNotFoundException {
        try {
            Class<?> result = super.loadClass(name, resolve);
            if (checkGlobal || result.getClassLoader() == this) {
                return result;
            }
        }
        catch (ClassNotFoundException result) {
            // empty catch block
        }
        if (checkLibraries && this.libraryLoader != null) {
            try {
                return this.libraryLoader.loadClass(name);
            }
            catch (ClassNotFoundException result) {
                // empty catch block
            }
        }
        if (checkGlobal && (result = this.classLoaderGroup.getClassByName(name, resolve, this)) != null) {
            return result;
        }
        throw new ClassNotFoundException(name);
    }

    public boolean _airplane_hasClass(@NotNull String name) {
        return this.classes.containsKey(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("org.bukkit.") || name.startsWith("net.minecraft.")) {
            throw new ClassNotFoundException(name);
        }
        Class<?> result = this.classes.get(name);
        if (result == null && !this.closed) {
            String path = name.replace('.', '/').concat(".class");
            JarEntry entry = this.jar.getJarEntry(path);
            if (entry != null) {
                byte[] classBytes;
                block19: {
                    String pkgName;
                    try (InputStream is = this.jar.getInputStream(entry);){
                        classBytes = ByteStreams.toByteArray((InputStream)is);
                    }
                    catch (IOException ex) {
                        throw new ClassNotFoundException(name, ex);
                    }
                    classBytes = Bukkit.getServer().getUnsafe().processClass(this.description, path, classBytes);
                    int dot = name.lastIndexOf(46);
                    if (dot != -1 && this.getPackage(pkgName = name.substring(0, dot)) == null) {
                        try {
                            if (this.manifest != null) {
                                this.definePackage(pkgName, this.manifest, this.url);
                            } else {
                                this.definePackage(pkgName, null, null, null, null, null, null, null);
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            if (this.getPackage(pkgName) != null) break block19;
                            throw new IllegalStateException("Cannot find package " + pkgName);
                        }
                    }
                }
                CodeSigner[] signers = entry.getCodeSigners();
                CodeSource source = new CodeSource(this.url, signers);
                result = this.defineClass(name, classBytes, 0, classBytes.length, source);
            }
            if (result == null) {
                result = super.findClass(name);
            }
            this.classes.put(name, result);
            this.setClass(name, result);
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            Collection<Class<?>> classes = this.getClasses();
            for (Class<?> clazz : classes) {
                this.removeClass(clazz);
            }
            super.close();
        }
        finally {
            this.closed = true;
            this.jar.close();
        }
    }

    @NotNull
    Collection<Class<?>> getClasses() {
        return this.classes.values();
    }

    public synchronized void initialize(@NotNull JavaPlugin javaPlugin) {
        Preconditions.checkArgument((javaPlugin != null ? 1 : 0) != 0, (Object)"Initializing plugin cannot be null");
        Preconditions.checkArgument((javaPlugin.getClass().getClassLoader() == this ? 1 : 0) != 0, (Object)"Cannot initialize plugin outside of this class loader");
        if (this.plugin != null || this.pluginInit != null) {
            throw new IllegalArgumentException("Plugin already initialized!", this.pluginState);
        }
        this.pluginState = new IllegalStateException("Initial initialization");
        this.pluginInit = javaPlugin;
        javaPlugin.init(Bukkit.getServer(), this.description, this.dataFolder, this.file, this, this.description, this.logger);
    }

    public String toString() {
        JavaPlugin currPlugin = this.plugin != null ? this.plugin : this.pluginInit;
        return "PluginClassLoader{plugin=" + String.valueOf(currPlugin) + ", pluginEnabled=" + String.valueOf(currPlugin == null ? "uninitialized" : Boolean.valueOf(currPlugin.isEnabled())) + ", url=" + String.valueOf(this.file) + "}";
    }

    void setClass(@NotNull String name, @NotNull Class<?> clazz) {
        if (ConfigurationSerializable.class.isAssignableFrom(clazz)) {
            Class<ConfigurationSerializable> serializable = clazz.asSubclass(ConfigurationSerializable.class);
            ConfigurationSerialization.registerClass(serializable);
        }
    }

    private void removeClass(@NotNull Class<?> clazz) {
        if (ConfigurationSerializable.class.isAssignableFrom(clazz)) {
            Class<ConfigurationSerializable> serializable = clazz.asSubclass(ConfigurationSerializable.class);
            ConfigurationSerialization.unregisterClass(serializable);
        }
    }

    @Override
    @Nullable
    public PluginClassLoaderGroup getGroup() {
        return this.classLoaderGroup;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

