/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.potion;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import io.papermc.paper.world.flag.FeatureDependant;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Translatable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectTypeCategory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PotionEffectType
implements Keyed,
Translatable,
net.kyori.adventure.translation.Translatable,
FeatureDependant {
    private static final BiMap<Integer, PotionEffectType> ID_MAP = HashBiMap.create();
    public static final PotionEffectType SPEED = PotionEffectType.getPotionEffectType(1, "speed");
    public static final PotionEffectType SLOWNESS = PotionEffectType.getPotionEffectType(2, "slowness");
    public static final PotionEffectType HASTE = PotionEffectType.getPotionEffectType(3, "haste");
    public static final PotionEffectType MINING_FATIGUE = PotionEffectType.getPotionEffectType(4, "mining_fatigue");
    public static final PotionEffectType STRENGTH = PotionEffectType.getPotionEffectType(5, "strength");
    public static final PotionEffectType INSTANT_HEALTH = PotionEffectType.getPotionEffectType(6, "instant_health");
    public static final PotionEffectType INSTANT_DAMAGE = PotionEffectType.getPotionEffectType(7, "instant_damage");
    public static final PotionEffectType JUMP_BOOST = PotionEffectType.getPotionEffectType(8, "jump_boost");
    public static final PotionEffectType NAUSEA = PotionEffectType.getPotionEffectType(9, "nausea");
    public static final PotionEffectType REGENERATION = PotionEffectType.getPotionEffectType(10, "regeneration");
    public static final PotionEffectType RESISTANCE = PotionEffectType.getPotionEffectType(11, "resistance");
    public static final PotionEffectType FIRE_RESISTANCE = PotionEffectType.getPotionEffectType(12, "fire_resistance");
    public static final PotionEffectType WATER_BREATHING = PotionEffectType.getPotionEffectType(13, "water_breathing");
    public static final PotionEffectType INVISIBILITY = PotionEffectType.getPotionEffectType(14, "invisibility");
    public static final PotionEffectType BLINDNESS = PotionEffectType.getPotionEffectType(15, "blindness");
    public static final PotionEffectType NIGHT_VISION = PotionEffectType.getPotionEffectType(16, "night_vision");
    public static final PotionEffectType HUNGER = PotionEffectType.getPotionEffectType(17, "hunger");
    public static final PotionEffectType WEAKNESS = PotionEffectType.getPotionEffectType(18, "weakness");
    public static final PotionEffectType POISON = PotionEffectType.getPotionEffectType(19, "poison");
    public static final PotionEffectType WITHER = PotionEffectType.getPotionEffectType(20, "wither");
    public static final PotionEffectType HEALTH_BOOST = PotionEffectType.getPotionEffectType(21, "health_boost");
    public static final PotionEffectType ABSORPTION = PotionEffectType.getPotionEffectType(22, "absorption");
    public static final PotionEffectType SATURATION = PotionEffectType.getPotionEffectType(23, "saturation");
    public static final PotionEffectType GLOWING = PotionEffectType.getPotionEffectType(24, "glowing");
    public static final PotionEffectType LEVITATION = PotionEffectType.getPotionEffectType(25, "levitation");
    public static final PotionEffectType LUCK = PotionEffectType.getPotionEffectType(26, "luck");
    public static final PotionEffectType UNLUCK = PotionEffectType.getPotionEffectType(27, "unluck");
    public static final PotionEffectType SLOW_FALLING = PotionEffectType.getPotionEffectType(28, "slow_falling");
    public static final PotionEffectType CONDUIT_POWER = PotionEffectType.getPotionEffectType(29, "conduit_power");
    public static final PotionEffectType DOLPHINS_GRACE = PotionEffectType.getPotionEffectType(30, "dolphins_grace");
    public static final PotionEffectType BAD_OMEN = PotionEffectType.getPotionEffectType(31, "bad_omen");
    public static final PotionEffectType HERO_OF_THE_VILLAGE = PotionEffectType.getPotionEffectType(32, "hero_of_the_village");
    public static final PotionEffectType DARKNESS = PotionEffectType.getPotionEffectType(33, "darkness");
    public static final PotionEffectType TRIAL_OMEN = PotionEffectType.getPotionEffectType(34, "trial_omen");
    public static final PotionEffectType RAID_OMEN = PotionEffectType.getPotionEffectType(35, "raid_omen");
    public static final PotionEffectType WIND_CHARGED = PotionEffectType.getPotionEffectType(36, "wind_charged");
    public static final PotionEffectType WEAVING = PotionEffectType.getPotionEffectType(37, "weaving");
    public static final PotionEffectType OOZING = PotionEffectType.getPotionEffectType(38, "oozing");
    public static final PotionEffectType INFESTED = PotionEffectType.getPotionEffectType(39, "infested");

    @NotNull
    private static PotionEffectType getPotionEffectType(int typeId, @NotNull String key) {
        PotionEffectType potionEffectType = Registry.EFFECT.getOrThrow(NamespacedKey.minecraft(key));
        if (typeId > 0) {
            ID_MAP.put((Object)typeId, (Object)potionEffectType);
        }
        return potionEffectType;
    }

    @NotNull
    public abstract PotionEffect createEffect(int var1, int var2);

    public abstract boolean isInstant();

    @NotNull
    public abstract PotionEffectTypeCategory getCategory();

    @NotNull
    public abstract Color getColor();

    @Deprecated
    public abstract double getDurationModifier();

    @Deprecated(forRemoval=true, since="1.20.2")
    public abstract int getId();

    @Deprecated
    @NotNull
    public abstract String getName();

    @Deprecated
    @Contract(value="null -> null")
    @Nullable
    public static PotionEffectType getByKey(@Nullable NamespacedKey key) {
        if (key == null) {
            return null;
        }
        return Registry.EFFECT.get(key);
    }

    @ApiStatus.Internal
    @Nullable
    public static PotionEffectType getById(int id) {
        PotionEffectType type = (PotionEffectType)ID_MAP.get((Object)id);
        if (type != null) {
            return type;
        }
        for (PotionEffectType other : Registry.EFFECT) {
            if (other.getId() != id) continue;
            ID_MAP.put((Object)id, (Object)other);
            return other;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static PotionEffectType getByName(@NotNull String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        return Registry.EFFECT.get(NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
    }

    @Deprecated
    @NotNull
    public static PotionEffectType[] values() {
        return Lists.newArrayList(Registry.EFFECT).toArray(new PotionEffectType[0]);
    }

    @NotNull
    public abstract Map<Attribute, AttributeModifier> getEffectAttributes();

    public abstract double getAttributeModifierAmount(@NotNull Attribute var1, int var2);

    @NotNull
    public abstract Category getEffectCategory();

    public static enum Category {
        BENEFICIAL((TextColor)NamedTextColor.BLUE),
        HARMFUL((TextColor)NamedTextColor.RED),
        NEUTRAL((TextColor)NamedTextColor.BLUE);

        private final TextColor color;

        private Category(TextColor color) {
            this.color = color;
        }

        @NotNull
        public TextColor getColor() {
            return this.color;
        }
    }
}

